
import threading
from H_9U.api.sync_queue import QueueToApi
from H_9U.api.websender import push_by_upload, push_org_by_upload
from H_9U.models.syncdataname import SyncDataName


class SyncApiManager:
    """
    openApi同步数据线程
    openApi 将操作发送给队列，此线程根据队列数据执行推送
    openApi 只将自身发生的操作加入队列，由本线程根据操作执行业务逻辑并推送

    使用时需提前设计好推送逻辑
    """

    def __init__(self):
        self.delay_time = 5
        self.timer = threading.Timer(self.delay_time, self.sync_task)

    def start(self):
        if self.timer is None:
            self.timer = threading.Timer(self.delay_time, self.sync_task)
        self.timer.start()

    def sync_task(self):
        try:
            while not QueueToApi.empty():
                self.add_push_data(QueueToApi.get())
        except Exception as e:
            print('SyncApiManager', e)

        self.timer = threading.Timer(self.delay_time, self.sync_task)
        self.timer.start()

    def add_push_data(self, params):
        user, token, name, data, args = params
        # bkg
        if name == SyncDataName.Bkg_Read_All_List:
            from H_9U.api.bkg import bkg_read_list
            push_by_upload(bkg_read_list, user, token, name, *args)
        # ipc
        elif name == SyncDataName.Input_IPC_Source_Create or name == SyncDataName.Input_IPC_Source_Rename:
            push_org_by_upload(user, token, name, data)
        elif name == SyncDataName.Input_IPC_Source_Delete:
            from H_9U.api.screen import screen_list
            push_by_upload(screen_list, user, token, name, *args)
        elif name == SyncDataName.Input_IPC_Channel_Edit:
            from H_9U.service.open_ipc_svc import ipc_channel_detail
            push_by_upload(ipc_channel_detail, user, token, name, *args)
        elif name == SyncDataName.Input_IPC_Channel_Add:
            from H_9U.service.open_ipc_svc import ipc_channel_detail_list
            push_by_upload(ipc_channel_detail_list, user, token, name, *args)
        elif name == SyncDataName.Input_IPC_Channel_Delete:
            from H_9U.api.screen import screen_list
            push_by_upload(screen_list, user, token, name, *args)
        elif name == SyncDataName.Input_IPC_GROUP_CREATE:
            push_org_by_upload(user, token, name, data)
        elif name == SyncDataName.Input_IPC_GROUP_DELETE:
            push_org_by_upload(user, token, name, data)
        elif name == SyncDataName.Input_IPC_GROUP_UPDATE:
            push_org_by_upload(user, token, name, data)
        elif name == SyncDataName.Input_IPC_Montage_Save:
            push_org_by_upload(user, token, name, data)
        elif name == SyncDataName.Input_IPC_Montage_Template_Delete:
            push_org_by_upload(user, token, name, data)
        elif name == SyncDataName.Input_IPC_Montage_Template_Apply:
            push_org_by_upload(user, token, name, data)
        elif name == SyncDataName.Input_IPC_Montage_Rename:
            push_org_by_upload(user, token, name, data)
        # input
        elif name == SyncDataName.Input_Read_List:
            from H_9U.api.input import input_read_all_list
            push_by_upload(input_read_all_list, user, token, name, *args)
        elif name == SyncDataName.Input_Group_Data:
            from H_9U.api.input import input_group_detail
            push_by_upload(input_group_detail, user, token, name, *args)
        elif name == SyncDataName.Input_Group_List \
                or name == SyncDataName.Input_Group_Delete \
                or name == SyncDataName.Input_Group_Node_Delete:
            push_org_by_upload(user, token, name, data)

        # layer
        elif name == SyncDataName.Layer_Screen_Layout \
                or name == SyncDataName.Layer_Write_Window \
                or name == SyncDataName.Layer_Screen_Take \
                or name == SyncDataName.Layer_Delete \
                or name == SyncDataName.Layer_Delete_All:
            push_org_by_upload(user, token, name, data)
        elif name == SyncDataName.Layer_Write_Z_Index:
            from H_9U import app
            from flask import g
            from H_9U.api.screen import screen_detail, screen_non_time_detail, screen_zorder_read
            with app.app_context():
                g.token = 'updtoken'
                device_id, screen_id, layer_id = args
                rs = screen_detail(device_id, screen_id)
                if rs['status'] == 0:
                    nontime = rs['data']['nonTime']
                    if nontime == 0:
                        push_by_upload(
                            screen_zorder_read,
                            user,
                            token,
                            name,
                            device_id,
                            screen_id)
                    elif nontime == 1:
                        from H_9U.api.screen import screen_non_time_detail
                        rs = screen_non_time_detail(device_id, screen_id)
                        if rs['status'] == 0:
                            layers = [x for x in rs['data']['layers']]
                            if layers:
                                data = {
                                    "screenId": screen_id,
                                    "deviceId": device_id,
                                    "layersZOrder": []}
                                for layer in layers:
                                    data["layersZOrder"].append(
                                        {'layerId': layer['layerId'], 'zOrder': layer['general']['zorder']})
                                push_org_by_upload(user, token, name, data)

        elif name == SyncDataName.Layer_Write_Source \
                or name == SyncDataName.Layer_Write_Lock\
                or name == SyncDataName.Layer_Create \
                or name == SyncDataName.Layer_Write_General \
                or name == SyncDataName.Layer_Freeze:
            device_id, screen_id, layer_id = args
            self.sync_layer_detail_data(
                user, token, name, device_id, screen_id, layer_id)

        # output
        elif name == SyncDataName.Output_Read_List:
            from H_9U.api.output import output_read_all_list
            push_by_upload(output_read_all_list, user, token, name, *args)


        # preset
        elif name == SyncDataName.Preset_Add \
                or name == SyncDataName.Preset_Write_General \
                or name == SyncDataName.Preset_Over_Write:
            from H_9U.api.preset import preset_detail
            push_by_upload(preset_detail, user, token, name, *args)
        elif name == SyncDataName.Preset_Delete or name == SyncDataName.Preset_Play or name == SyncDataName.Preset_Poll:
            push_org_by_upload(user, token, name, data)
        elif name == SyncDataName.Preset_Group_List:
            from H_9U.api.preset import preset_group_list
            push_by_upload(preset_group_list, user, token, name, *args)
        elif name == SyncDataName.Preset_Read_List:
            from H_9U.api.preset import preset_read_list
            push_by_upload(preset_read_list, user, token, name, *args)

        # 屏幕
        elif name == SyncDataName.Screen_Delete \
                or name == SyncDataName.Screen_Ftb \
                or name == SyncDataName.Screen_Write_Freeze \
                or name == SyncDataName.Screen_Write_3D:
            push_org_by_upload(user, token, name, data)
        elif name == SyncDataName.Screen_Create:
            from H_9U.api.screen import screen_detail
            push_by_upload(screen_detail, user, token, name, *args)
        elif name == SyncDataName.Screen_Read_All_List:
            from H_9U.api.screen import screen_list
            push_by_upload(screen_list, user, token, name, *args)
        elif name == SyncDataName.Screen_Write_OSD:
            device_id, screen_id = args
            from H_9U import app
            from flask import g
            from H_9U.api.screen import screen_detail, screen_non_time_detail
            with app.app_context():
                g.token = 'updtoken'
                rs = screen_detail(device_id, screen_id)
                if rs['status'] == 0 and rs['data']:
                    osd_data = {
                        "deviceId": device_id,
                        "screenId": screen_id,
                        "Osd": rs['data']['Osd'],
                        "OsdImage": rs['data']['OsdImage']
                    }
                    push_org_by_upload(user, token, name, osd_data)
        elif name == SyncDataName.Screen_Write_Output_Mode:
            from H_9U.api.screen import screen_detail
            push_by_upload(screen_detail, user, token, name, *args)
        # elif name == SyncDataName.Screen_Read_All_List:
        #     from H_9U.api.screen import screen_list
        #     push_by_upload(screen_list, user, token, name, *args)
        elif name == SyncDataName.Screen_Write_BKG:
            device_id, screen_id = args
            from H_9U.api.screen import screen_detail
            from H_9U import app
            from flask import g
            from H_9U.api.screen import screen_detail, screen_non_time_detail
            from H_9U.api.layer import layer_read_detail
            with app.app_context():
                g.token = 'updtoken'
                rs = screen_detail(device_id, screen_id)
                if rs['status'] == 0 and rs['data']:
                    data = rs['data']['Bkg']
                    data['deviceId'] = device_id
                    data['screenId'] = screen_id
                    push_org_by_upload(user, token, name, data)

    def sync_layer_detail_data(
            self,
            user,
            token,
            name,
            device_id,
            screen_id,
            layer_id):
        from H_9U import app
        from flask import g
        from H_9U.api.screen import screen_detail, screen_non_time_detail
        from H_9U.api.layer import layer_read_detail
        with app.app_context():
            g.token = 'updtoken'
            rs = screen_detail(device_id, screen_id)
            if rs['status'] == 0:
                nontime = rs['data']['nonTime']
                if nontime == 0:
                    push_by_upload(
                        layer_read_detail,
                        user,
                        token,
                        name,
                        device_id,
                        screen_id,
                        layer_id)
                elif nontime == 1:
                    rs = screen_non_time_detail(device_id, screen_id)
                    if rs['status'] == 0:
                        layers = [x for x in rs['data']['layers']
                                  if x['layerId'] == layer_id]
                        if layers:
                            layer = layers[0]
                            layer['screenId'] = screen_id
                            layer['deviceId'] = device_id
                            push_org_by_upload(user, token, name, layer)
