"""
Created on 2023年2月2日
@author: 程声清
input_filter
返回值统一为 {data:JSON结构体, msg:"", status:0}
"""
from H_9U.api.filter.input_filter import _filter_input_func, _filter_input_group_func, _filter_input_group_list_func, \
    _filter_input_group_push_func, _filter_ipc_func
from H_9U.api.filter.output_filter import _filter_output_func
from H_9U.api.filter.role_filter import _filter_role_func
from H_9U.api.filter.screen_filter import _filter_screen_func, _filter_list_screen_func
from H_9U.api.filter.user_filter import _filter_user_func


from H_9U.models.result import get_result_model
from H_9U.models.sysconst import DataType


def _filter_input_data(role_type, role_data, data):
    """
    获取当前登录用户的输入列表数据
    :return: 无分组信息
    """
    # 查询当前角色拥有的输入源权限

    return _filter_input_func(role_type, role_data, data)


def _filter_api_input_group_data(role_type, role_data, data):
    """
    推送数据过滤
    :param role_type: role_id
    :param data: 推送数据
    :param role_data: role_data
    :return: 数据
    """
    return _filter_input_group_func(role_type, role_data, data)


def _filter_input_list_group_data(role_type, role_data, data_message):
    """
    推送数据过滤
    :param data_message: 推送数据
    :param role_data: role_data
    :param role_type: role_type
    :return: 数据
    """
    return _filter_input_group_list_func(role_type, role_data, data_message)


def _filter_input_group_data(role_type, role_data, data_message):
    """
    推送数据过滤
    :param data_message: 推送数据
    :param role_type: role_type
    :param role_data: role_data
    :return: 数据
    """
    return _filter_input_group_push_func(role_type, role_data, data_message)


def _filter_output_data(role_type, role_data, data):
    """
    获取当前登录用户的输入列表数据
    :return: 无分组信息
    """
    # 查询当前角色拥有的输入源权限

    return _filter_output_func(role_type, role_data, data)


def _filter_screen_list_data(role_type, role_data, data):
    """
    获取当前登录用户的输入列表数据
    :return: 无分组信息
    """
    # 查询当前角色拥有的输入源权限

    return _filter_list_screen_func(role_type, role_data, data)


def _filter_screen_data(role_type, role_data, data):
    """
    获取当前登录用户的输入列表数据
    :return: 无分组信息
    """
    # 查询当前角色拥有的输入源权限

    return _filter_screen_func(role_type, role_data, data)


def _filter_role_data(role_type, role_data, data):
    """
    获取当前登录用户的输入列表数据
    :return: 无分组信息
    """
    # 查询当前角色拥有的输入源权限

    return _filter_role_func(role_type, role_data, data)


def _filter_user_data(role_type, role_data, data):
    """
    获取当前登录用户的输入列表数据
    :return: 无分组信息
    """
    # 查询当前角色拥有的输入源权限

    return _filter_user_func(role_type, role_data, data)


def _filter_ipc_data(role_type, role_data, data):
    """
    获取当前登录用户的ipc拼接源列表数据
    :return: 无分组信息
    """
    # 查询当前角色拥有的输入源权限

    return _filter_ipc_func(role_type, role_data, data)


def role_filter_data_func(role_id):
    """
    获取角色类型以及角色对应的输入源权限数据
    :param role_id: 角色Id
    :return: 数据
    """

    rs = get_result_model()
    input_list = []
    output_list = []
    screen_list = []
    mvr_list = []
    from H_9U.service.user import usersvc
    role_type = usersvc.user_role_type(role_id)
    from H_9U.service.role import rolesvc
    role_rs = rolesvc.get_all_data_by_role_id(role_id)
    if role_rs['status'] == 0 and role_rs['data']:
        for x in role_rs['data']:
            if x['dataType'] == DataType.Input_Type:
                input_dict = {
                    "inputId": x['inputId']
                }
                input_list.append(input_dict)
            if x['dataType'] == DataType.Output_Type:
                output_dict = {
                    "outputId": x['outputId']
                    }
                output_list.append(output_dict)
            if x['dataType'] == DataType.Screen_Type:
                screen_dict = {
                    "screenId": x['screenId']
                }
                screen_list.append(screen_dict)
            if x['dataType'] == DataType.Mvr_Type:
                mvr_dict = {
                    "mvrId": x['mvrId']
                }
                mvr_list.append(mvr_dict)
    rs['data']['inputList'] = input_list
    rs['data']['outputList'] = output_list
    rs['data']['screenList'] = screen_list
    rs['data']['mvrList'] = mvr_list
    return rs, role_type
