"""
Created on 2024年3月1日
@author: 程声清
ndi接口.
对应前端接口ndi
返回值统一为 {data:JSON结构体, msg:"", status:0}
"""

from flask import Blueprint, g
from flask.globals import request
from flask.json import jsonify

from H_9U.api.websender import push_data_org, push_data
from H_9U.models.syncdataname import SyncDataName
from H_9U.service.ndi import ndi_svc
from H_9U.util.logwrapper import api_log
from H_9U.util.common import valid_json, valid_params
from H_9U.models.result import get_result_model, ResInfo


ndi_bp = Blueprint('ndi', __name__)


@ndi_bp.route('/create', methods=['GET', 'POST'])
@api_log
def ndi_create():
    """
    创建ndi
    """
    params = valid_json(request.get_data().decode())
    if not params:
        return jsonify(get_result_model(ResInfo.Request_Json_Error))
    values = valid_params(params, 'deviceId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id = values
    params = params['sourceList']
    rs = ndi_svc.ndi_source_create(device_id, params)
    if rs['status'] == 0 and rs['data']:
        # 刷新列表数据
        push_data_org(SyncDataName.Ndi_Source_List, device_id)
    return jsonify(rs)


@ndi_bp.route('/delete', methods=['GET', 'POST'])
@api_log
def ndi_delete():
    """
    创建ndi
    """
    params = valid_json(request.get_data().decode())
    if not params:
        return jsonify(get_result_model(ResInfo.Request_Json_Error))
    values = valid_params(params, 'deviceId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id = values
    rs = ndi_svc.ndi_source_delete(device_id, params)
    if rs['status'] == 0:
        push_data_org(SyncDataName.Ndi_Source_Delete, params)
    return jsonify(rs)


@ndi_bp.route('/update', methods=['GET', 'POST'])
@api_log
def ndi_update():
    """
    创建ndi
    """
    params = valid_json(request.get_data().decode())
    if not params:
        return jsonify(get_result_model(ResInfo.Request_Json_Error))
    values = valid_params(params, 'deviceId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id = values
    rs = ndi_svc.ndi_source_update(device_id, params)
    if rs['status'] == 0:
        push_data_org(SyncDataName.Ndi_Source_Update, params)
    return jsonify(rs)


@ndi_bp.route('/rename', methods=['GET', 'POST'])
@api_log
def ndi_rename():
    """
    创建ndi
    """
    params = valid_json(request.get_data().decode())
    if not params:
        return jsonify(get_result_model(ResInfo.Request_Json_Error))
    values = valid_params(params, 'deviceId', 'sourceId', 'sourceName', 'sourceType')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, source_id, source_name, source_type = values
    rs = ndi_svc.ndi_source_update(device_id, params)
    if rs['status'] == 0:
        push_data_org(SyncDataName.Ndi_Source_Update, params)
    return jsonify(rs)


@ndi_bp.route('/list', methods=['GET', 'POST'])
@api_log
def ndi_list():
    """
    创建ndi
    """
    params = valid_json(request.get_data().decode())
    if not params:
        return jsonify(get_result_model(ResInfo.Request_Json_Error))
    values = valid_params(params, 'deviceId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id = values
    params['seqPageIndex'] =  params['seqPageIndex'] -1
    return jsonify(ndi_svc.ndi_source_list(device_id, params))


@ndi_bp.route('/search', methods=['GET', 'POST'])
@api_log
def ndi_search():
    """
    创建ndi
    """
    params = valid_json(request.get_data().decode())
    if not params:
        return jsonify(get_result_model(ResInfo.Request_Json_Error))
    values = valid_params(params, 'deviceId', 'sourceMode')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, source_mode = values
    return jsonify(ndi_svc.ndi_source_search(device_id, source_mode))


@ndi_bp.route('/detail', methods=['GET', 'POST'])
@api_log
def ndi_detail():
    """
    创建ndi
    """
    params = valid_json(request.get_data().decode())
    if not params:
        return jsonify(get_result_model(ResInfo.Request_Json_Error))
    values = valid_params(params, 'deviceId', 'sourceId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id,  source_id= values
    return jsonify(ndi_svc.ndi_source_detail(device_id, source_id))


@ndi_bp.route('/createCrop', methods=['GET', 'POST'])
@api_log
def ndi_create_crop():
    """
    创建ndi
    """
    params = valid_json(request.get_data().decode())
    if not params:
        return jsonify(get_result_model(ResInfo.Request_Json_Error))
    values = valid_params(params, 'deviceId', 'sourceType', 'inputId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, source_type, input_id = values
    rs = ndi_svc.ndi_source_crop_create(device_id, input_id, params)
    if rs['status'] == 0:
        crop_rs = ndi_svc.ndi_source_crop_detail(device_id, params.get('inputId'), rs['data']['id'], source_type)
        if crop_rs['status'] == 0:
            crop_rs['data']['inputId'] = input_id
            crop_rs['data']['id'] = rs['data']['id']
            push_data_org(SyncDataName.Ndi_Crop_Create, crop_rs['data'])
    return jsonify(rs)


@ndi_bp.route('/deleteCrop', methods=['GET', 'POST'])
@api_log
def ndi_delete_crop():
    """
    创建ndi
    """
    params = valid_json(request.get_data().decode())
    if not params:
        return jsonify(get_result_model(ResInfo.Request_Json_Error))
    values = valid_params(params, 'deviceId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id = values
    rs = ndi_svc.ndi_source_crop_delete(device_id, params)
    if rs['status'] == 0:
        push_data_org(SyncDataName.Ndi_Crop_Delete, params)
        from H_9U.api.screen import screen_list
        push_data(screen_list, SyncDataName.Screen_Read_All_List, device_id)
    return jsonify(rs)


@ndi_bp.route('/updateCrop', methods=['GET', 'POST'])
@api_log
def ndi_update_crop():
    """
    创建ndi
    """
    params = valid_json(request.get_data().decode())
    if not params:
        return jsonify(get_result_model(ResInfo.Request_Json_Error))
    values = valid_params(params, 'deviceId','inputId', 'cropId', 'sourceType')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, input_id, crop_id, source_type = values
    rs = ndi_svc.ndi_source_crop_update(device_id, input_id, crop_id, params)
    if rs['status'] == 0:
        push_data_org(SyncDataName.Ndi_Crop_Update, params)
        from H_9U.api.screen import screen_list
        push_data(screen_list, SyncDataName.Screen_Read_All_List, device_id)
    return jsonify(rs)


@ndi_bp.route('/cropList', methods=['GET', 'POST'])
@api_log
def ndi_crop_list():
    """
    创建ndi
    """
    params = valid_json(request.get_data().decode())
    if not params:
        return jsonify(get_result_model(ResInfo.Request_Json_Error))
    values = valid_params(params, 'deviceId', 'inputId', 'sourceType')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, source_id, source_type = values
    return jsonify(ndi_svc.ndi_source_crop_list(device_id, source_id, source_type))


@ndi_bp.route('/ndiStreamStatus', methods=['GET', 'POST'])
@api_log
def ndi_stream_status():
    """
    ndi数据源详情列表
    """
    params = valid_json(request.get_data().decode())
    if not params:
        return jsonify(get_result_model(ResInfo.Request_Json_Error))
    values = valid_params(params, 'deviceId', 'sourceType')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, source_type = values
    rs = ndi_svc.ndi_stream_detail(device_id, params)
    return jsonify(rs)


@ndi_bp.route('/ndiStreamList', methods=['GET', 'POST'])
@api_log
def ndi_stream_list():
    """
    ndi数据源详情列表
    """
    params = valid_json(request.get_data().decode())
    if not params:
        return jsonify(get_result_model(ResInfo.Request_Json_Error))

    values = valid_params(params, 'deviceId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id = values
    rs = ndi_svc.ndi_stream_list(device_id)
    return jsonify(rs)




def ndi_source_list(device_id, params):
    return ndi_svc.ndi_source_list(device_id, params)