"""
Created on 2024年3月1日
@author: 程声清
network接口.
对应前端接口network
返回值统一为 {data:JSON结构体, msg:"", status:0}
"""

from flask import Blueprint, g
from flask.globals import request
from flask.json import jsonify
from H_9U.service.role import rolesvc
from H_9U.api.websender import push_data_org
from H_9U.models.syncdataname import SyncDataName
from H_9U.service.network import network_svc
from H_9U.util.logwrapper import api_log
from H_9U.util.common import valid_json, valid_params
from H_9U.models.result import get_result_model, ResInfo


network_bp = Blueprint('network', __name__)


@network_bp.route('/createGroup', methods=['GET', 'POST'])
@api_log
def network_create_group():
    """
    创建ndi
    """
    params = valid_json(request.get_data().decode())
    if not params:
        return jsonify(get_result_model(ResInfo.Request_Json_Error))
    values = valid_params(params, 'deviceId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id = values
    # 获取当前登录用户的角色
    user = g.user
    role_id = user['roleId']
    role_rs = rolesvc.get_role_by_id(role_id)
    if role_rs['status'] == 0 and role_rs['data']:
        if role_rs['data']['role_type'] != 1:
            return jsonify(get_result_model(ResInfo.Role_Jurisdiction_Code))
    rs = network_svc.network_source_group_create(device_id, params)
    if rs['status'] == 0:
        params['groupId'] = rs['data']['id']
        push_data_org(SyncDataName.NetWork_Group_Create, params)
    return jsonify(rs)


@network_bp.route('/updateGroup', methods=['GET', 'POST'])
@api_log
def network_update_group():
    """
    创建ndi
    """
    params = valid_json(request.get_data().decode())
    if not params:
        return jsonify(get_result_model(ResInfo.Request_Json_Error))
    values = valid_params(params, 'deviceId', 'groupId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, group_id = values
    # 获取当前登录用户的角色
    user = g.user
    role_id = user['roleId']
    role_rs = rolesvc.get_role_by_id(role_id)
    if role_rs['status'] == 0 and role_rs['data']:
        if role_rs['data']['role_type'] != 1:
            return jsonify(get_result_model(ResInfo.Role_Jurisdiction_Code))

    rs = network_svc.network_source_group_update(device_id, group_id, params)
    if rs['status'] == 0:
        push_data_org(SyncDataName.NetWork_Group_Update, params)
    return jsonify(rs)

@network_bp.route('/deleteGroup', methods=['GET', 'POST'])
@api_log
def network_delete_group():
    """
    创建ndi
    """
    params = valid_json(request.get_data().decode())
    if not params:
        return jsonify(get_result_model(ResInfo.Request_Json_Error))
    values = valid_params(params, 'deviceId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id = values
    # 获取当前登录用户的角色
    user = g.user
    role_id = user['roleId']
    role_rs = rolesvc.get_role_by_id(role_id)
    if role_rs['status'] == 0 and role_rs['data']:
        if role_rs['data']['role_type'] != 1:
            return jsonify(get_result_model(ResInfo.Role_Jurisdiction_Code))
    rs = network_svc.network_source_group_delete(device_id, params)
    if rs['status'] == 0:
        push_data_org(SyncDataName.NetWork_Group_Delete, params)
    return jsonify(rs)

@network_bp.route('/createGroupNode', methods=['GET', 'POST'])
@api_log
def network_create_group_node():
    """
    创建ndi
    """
    params = valid_json(request.get_data().decode())
    if not params:
        return jsonify(get_result_model(ResInfo.Request_Json_Error))
    values = valid_params(params, 'deviceId', 'groupId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, group_id = values

    # 获取当前登录用户的角色
    user = g.user
    role_id = user['roleId']
    role_rs = rolesvc.get_role_by_id(role_id)
    if role_rs['status'] == 0 and role_rs['data']:
        if role_rs['data']['role_type'] != 1:
            return jsonify(get_result_model(ResInfo.Role_Jurisdiction_Code))

    rs = network_svc.network_source_group_node_create(device_id, group_id, params)
    if rs['status'] == 0:
        push_data_org(SyncDataName.NetWork_Group_Create_Node, params)
    return jsonify(rs)

@network_bp.route('/deleteGroupNode', methods=['GET', 'POST'])
@api_log
def network_delete_group_node():
    """
    创建ndi
    """
    params = valid_json(request.get_data().decode())
    if not params:
        return jsonify(get_result_model(ResInfo.Request_Json_Error))
    values = valid_params(params, 'deviceId', 'groupId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, group_id = values

    # 获取当前登录用户的角色
    user = g.user
    role_id = user['roleId']
    role_rs = rolesvc.get_role_by_id(role_id)
    if role_rs['status'] == 0 and role_rs['data']:
        if role_rs['data']['role_type'] != 1:
            return jsonify(get_result_model(ResInfo.Role_Jurisdiction_Code))

    rs = network_svc.network_source_group_node_delete(device_id, group_id, params)
    if rs['status'] == 0:
        push_data_org(SyncDataName.NetWork_Group_Delete_Node, params)
    return jsonify(rs)

@network_bp.route('/clearGroupNode', methods=['GET', 'POST'])
@api_log
def network_clear_group_node():
    """
    创建ndi
    """
    params = valid_json(request.get_data().decode())
    if not params:
        return jsonify(get_result_model(ResInfo.Request_Json_Error))
    values = valid_params(params, 'deviceId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id = values

    # 获取当前登录用户的角色
    user = g.user
    role_id = user['roleId']
    role_rs = rolesvc.get_role_by_id(role_id)
    if role_rs['status'] == 0 and role_rs['data']:
        if role_rs['data']['role_type'] != 1:
            return jsonify(get_result_model(ResInfo.Role_Jurisdiction_Code))

    rs = network_svc.network_source_group_node_clear(device_id, params)
    if rs['status'] == 0:
        push_data_org(SyncDataName.NetWork_Group_Clear_Node, params)
    return jsonify(rs)

@network_bp.route('/groupList', methods=['GET', 'POST'])
@api_log
def network_group_list():
    """
    创建ndi
    """
    params = valid_json(request.get_data().decode())
    if not params:
        return jsonify(get_result_model(ResInfo.Request_Json_Error))
    values = valid_params(params, 'deviceId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id = values
    rs = network_svc.network_source_group_list(device_id)
    return jsonify(rs)

@network_bp.route('/groupDetail', methods=['GET', 'POST'])
@api_log
def network_group_detail():
    """
    创建ndi
    """
    params = valid_json(request.get_data().decode())
    if not params:
        return jsonify(get_result_model(ResInfo.Request_Json_Error))
    values = valid_params(params, 'deviceId', 'groupId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, group_id = values
    rs = network_svc.network_source_group_detail(device_id, group_id)
    return jsonify(rs)

@network_bp.route('/networkInputSourceList', methods=['GET', 'POST'])
@api_log
def network_input_source_free_list():
    """
    创建ndi
    """
    params = valid_json(request.get_data().decode())
    if not params:
        return jsonify(get_result_model(ResInfo.Request_Json_Error))
    values = valid_params(params, 'deviceId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id = values
    rs = network_svc.network_source_free_list(device_id, params)
    return jsonify(rs)

