"""
Created on 2021年9月17日
@author: 程声清
对应接口文档bkg
返回值统一为 {data:JSON结构体, msg:"", status:0}
"""

from flask import Blueprint, g
from flask.json import jsonify
from H_9U.service import open_bkg_svc
from H_9U.util.common import get_params
from H_9U.util.logwrapper import open_log
from H_9U.util.request_handle import response_parameter_resolution
from H_9U.models.result import get_result_model, ResInfo
from H_9U.api.sync_queue import add_to_web
from H_9U.models.syncdataname import SyncDataName

open_bkg_bp = Blueprint('open_bkg', __name__)


@open_bkg_bp.route('/create', methods=['GET', 'POST'])
@open_log
def bkg_create():
    """
    创建BKG
    :return: bkg Id数据
    """
    params = g.data
    values = get_params(params, 'deviceId', 'name', 'file', 'fileName')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, name, file_data, file_name = values
    rs = open_bkg_svc.bkg_create(device_id, name, file_data, file_name)
    # 加入推送，推送整个bkg列表
    if rs['status'] == 0:
        add_to_web(SyncDataName.Bkg_Read_All_List, None, device_id)
    return jsonify(response_parameter_resolution(rs))


@open_bkg_bp.route('/delete', methods=['GET', 'POST'])
@open_log
def bkg_delete():
    """
    删除指定的BKG
    :return: bkg Id数据
    """
    params = g.data
    values = get_params(params, 'deviceId', 'bkgIdList')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, bkg_id_list = values
    rs = open_bkg_svc.bkg_delete(device_id, bkg_id_list)
    # 加入推送，推送整个bkg列表
    if rs['status'] == 0:
        add_to_web(SyncDataName.Bkg_Read_All_List, None, device_id)
    return jsonify(response_parameter_resolution(rs))


@open_bkg_bp.route('/readDetail', methods=['GET', 'POST'])
@open_log
def bkg_read_detail():
    """
    读取全部bkg信息
    :return:见前端bkg文档
    """
    params = g.data
    values = get_params(params, 'deviceId', 'bkgId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, bkg_id = values
    rs = open_bkg_svc.bkg_read_detail(device_id, bkg_id)
    return jsonify(response_parameter_resolution(rs))


@open_bkg_bp.route('/readAllList', methods=['GET', 'POST'])
@open_log
def bkg_read_all_list():
    """
    读取全部bkg信息
    :return: 见前端bkg文档
    """
    params = g.data
    values = get_params(params, 'deviceId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id = values
    rs = open_bkg_svc.bkg_read_all_list(device_id)
    return jsonify(response_parameter_resolution(rs))
