"""
Created on 2021年9月06日
@author: 程声清
main接口..
对应前端接口main
返回值统一为 {body:加密串, msg:"", sign:"", status:0}
"""
from flask import Blueprint, g
from flask.json import jsonify
from H_9U.models.result import get_result_model, ResInfo
from H_9U.service import open_main_svc
from H_9U.util.common import get_params
from H_9U.util.logwrapper import open_log
from H_9U.util.request_handle import response_parameter_resolution

open_main_bp = Blueprint('opn_main', __name__)


@open_main_bp.route('/initStatus', methods=['GET', 'POST'])
@open_log
def main_init_status():
    """
    读取系统初始化状态
    :return: 初始化状态和语言模式
    """
    params = g.data
    values = get_params(params, 'deviceId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id = values
    rs = open_main_svc.main_init_status(device_id)
    return jsonify(response_parameter_resolution(rs))


@open_main_bp.route('/readVideoServerInfo', methods=['GET', 'POST'])
@open_log
def main_read_video_server_info():
    """
    读取视频服务器地址
    :return:
    """
    params = g.data
    values = get_params(params, 'deviceId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id = values
    rs = open_main_svc.main_read_video_server_info(device_id)
    return jsonify(response_parameter_resolution(rs))
