"""
Created on 2021年9月17日
@author: 程声清
对应接口文档preset
返回值统一为 {data:JSON结构体, msg:"", status:0}
"""
from flask import Blueprint, g
from flask.json import jsonify
from H_9U.service import open_preset_svc
from H_9U.util.common import get_params
from H_9U.util.logwrapper import open_log
from H_9U.util.request_handle import response_parameter_resolution
from H_9U.models.result import get_result_model, ResInfo
from H_9U.api.sync_queue import add_to_web
from H_9U.models.syncdataname import SyncDataName


open_preset_bp = Blueprint('open_preset', __name__)


@open_preset_bp.route('/createPreset', methods=['GET', 'POST'])
@open_log
def preset_create():
    """
    创建场景
    :return: 参考接口文档createPreset
    """
    params = g.data
    values = get_params(params, 'deviceId', 'screenId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, screen_id = values
    rs = open_preset_svc.preset_create(device_id, screen_id, params)
    if rs['status'] == 0:
        preset_id = rs['data']['id']
        add_to_web(SyncDataName.Preset_Add, None, device_id, screen_id, preset_id)
    return jsonify(response_parameter_resolution(rs))


@open_preset_bp.route('/deletePreset', methods=['GET', 'POST'])
@open_log
def preset_delete():
    """
    删除场景
    :return: 结果对象，status==0表示成功
    """
    params = g.data
    values = get_params(params, 'deviceId', 'screenId', 'presetId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, screen_id, preset_id = values
    rs = open_preset_svc.preset_delete(
        device_id, screen_id, preset_id, params)
    if rs['status'] == 0:
        add_to_web(SyncDataName.Preset_Delete, {'deviceId': device_id, 'screenId': screen_id, 'presetId': preset_id})
        add_to_web(SyncDataName.Preset_Group_List, None, device_id, screen_id)
    return jsonify(response_parameter_resolution(rs))


@open_preset_bp.route('/writeGeneral', methods=['GET', 'POST'])
@open_log
def preset_write_general():
    """
    设置基本信息
    :return:参考前端接口文档writeGeneral
    """
    params = g.data
    values = get_params(params, 'deviceId', 'screenId', 'presetId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, screen_id, preset_id = values
    rs = open_preset_svc.preset_general_write(
        device_id, screen_id, preset_id, params)
    if rs['status'] == 0:
        add_to_web(SyncDataName.Preset_Write_General, None, device_id, screen_id, preset_id)
        add_to_web(SyncDataName.Preset_Group_List, None, device_id, screen_id)
    return jsonify(response_parameter_resolution(rs))


@open_preset_bp.route('/play', methods=['GET', 'POST'])
@open_log
def preset_play():
    """
    播放场景
    :return: 参考前端接口文档play
    """
    params = g.data
    values = get_params(params, 'deviceId', 'screenId', 'presetId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, screen_id, preset_id = values
    rs = open_preset_svc.preset_play(
        device_id, screen_id, preset_id, params)
    if rs['status'] == 0:
        add_to_web(SyncDataName.Preset_Play, params)
    return jsonify(response_parameter_resolution(rs))


@open_preset_bp.route('/readDetail', methods=['GET', 'POST'])
@open_log
def preset_read_detail():
    """
    读取指定场景的详细信息
    :return:
    """
    params = g.data
    values = get_params(params, 'deviceId', 'screenId', 'presetId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, screen_id, preset_id = values
    rs = open_preset_svc.preset_read_detail(
        device_id, screen_id, preset_id)
    return jsonify(response_parameter_resolution(rs))


@open_preset_bp.route('/deleteAll', methods=['GET', 'POST'])
@open_log
def preset_delete_all():
    """
    清空场景
    :return: 删除场景列表数据
    """
    params = g.data
    values = get_params(params, 'deviceId', 'screenId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, screen_id = values
    rs = open_preset_svc.preset_delete_all(device_id, screen_id)
    if rs['status'] == 0:
        add_to_web(SyncDataName.Preset_Read_List, None, device_id, screen_id)
        add_to_web(SyncDataName.Preset_Group_List, None, device_id, screen_id)
    return jsonify(response_parameter_resolution(rs))


@open_preset_bp.route('/groupList', methods=['GET', 'POST'])
@open_log
def preset_group_list():
    """
     场景分组列表数据
    :return: 场景分组列表数据
    """
    params = g.data
    values = get_params(params, 'deviceId', 'screenId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, screen_id = values
    rs = open_preset_svc.preset_group_list(device_id, screen_id)
    return jsonify(response_parameter_resolution(rs))


@open_preset_bp.route('/groupCreate', methods=['GET', 'POST'])
@open_log
def preset_group_create():
    """
    创建场景分组
    设备id， 屏幕id，group_name, preset_id_list
    :return: 屏幕分组创建结果Id
    """
    params = g.data
    values = get_params(params, 'deviceId', 'screenId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, screen_id = values
    rs = open_preset_svc.preset_group_create(device_id, screen_id, params)
    if rs['status'] == 0:
        add_to_web(SyncDataName.Preset_Group_List, None, device_id, screen_id)
    return jsonify(response_parameter_resolution(rs))


@open_preset_bp.route('/groupDelete', methods=['GET', 'POST'])
@open_log
def preset_group_delete():
    """
    删除场景分组
    :return: 参考结果文档groupDelete
    """
    params = g.data
    values = get_params(params, 'deviceId', 'screenId', 'presetGroupId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, screen_id, group_id = values
    rs = open_preset_svc.preset_group_delete(
        device_id, screen_id, group_id)
    if rs['status'] == 0:
        add_to_web(SyncDataName.Preset_Group_List, None, device_id, screen_id)
    return jsonify(response_parameter_resolution(rs))


@open_preset_bp.route('/groupNodeList', methods=['GET', 'POST'])
@open_log
def preset_group_node_list():
    """
    读取场景分组节点列表
    :return: 参考前端接口文档groupNodeList
    """
    params = g.data
    values = get_params(params, 'deviceId', 'screenId', 'presetGroupId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, screen_id, group_id = values
    rs = open_preset_svc.preset_group_node_list(
        device_id, screen_id, group_id)
    return jsonify(response_parameter_resolution(rs))


@open_preset_bp.route('/presetPoll', methods=['GET', 'POST'])
@open_log
def preset_poll():
    """
    场景轮询
    :return: 参考前端接口文档 presetPoll
    """
    params = g.data
    values = get_params(params, 'deviceId', 'screenId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, screen_id = values
    rs = open_preset_svc.preset_poll(device_id, screen_id, params)
    if rs['status'] == 0:
        add_to_web(SyncDataName.Preset_Poll, params)
        add_to_web(SyncDataName.Output_Read_List, None, device_id)
    return jsonify(response_parameter_resolution(rs))


@open_preset_bp.route('/readList', methods=['GET', 'POST'])
@open_log
def preset_read_list():
    """
    读取场景列表不含分组信息
    :return: 参考前端接口文档 readList
    """
    params = g.data
    values = get_params(params, 'deviceId', 'screenId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, screen_id = values
    rs = open_preset_svc.preset_read_list(device_id, screen_id)
    return jsonify(response_parameter_resolution(rs))


@open_preset_bp.route('/readPresetPoll', methods=['GET', 'POST'])
@open_log
def preset_poll_read():
    """
    场景轮询读取信息
    :return: 参考前端接口文档 readPresetPoll
    """
    params = g.data
    values = get_params(params, 'deviceId', 'screenId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, screen_id = values
    rs = open_preset_svc.preset_poll_read(device_id, screen_id)
    return jsonify(response_parameter_resolution(rs))


@open_preset_bp.route('/readPlay', methods=['GET', 'POST'])
@open_log
def preset_play_read():
    """
    读取屏幕当前播放场景
    :return: 场景Id
    """
    params = g.data
    values = get_params(params, 'deviceId', 'screenId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, screen_id = values
    rs = open_preset_svc.preset_play_read(device_id, screen_id)
    return jsonify(response_parameter_resolution(rs))


@open_preset_bp.route('/groupUpdate', methods=['GET', 'POST'])
@open_log
def preset_group_update():
    """
    修改场景分组
    :return: 场景Id
    """
    params = g.data
    values = get_params(params, 'deviceId', 'screenId', 'presetGroupId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, screen_id, group_id = values
    rs = open_preset_svc.preset_group_update(device_id, screen_id, params)
    if rs['status'] == 0:
        add_to_web(SyncDataName.Preset_Group_List, None, device_id, screen_id)
    return jsonify(response_parameter_resolution(rs))


@open_preset_bp.route('/overWrite', methods=['GET', 'POST'])
@open_log
def preset_overwrite():
    """
    场景覆盖
    :return: 场景Id
    """
    params = g.data
    values = get_params(params, 'deviceId', 'screenId', "presetId")
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, screen_id, preset_id = values
    rs = open_preset_svc.preset_overwrite(
        device_id, screen_id, preset_id, params)
    if rs['status'] == 0:
        add_to_web(SyncDataName.Preset_Over_Write, None, device_id, screen_id, preset_id)
    return jsonify(response_parameter_resolution(rs))
