"""
Created on 2021年9月07日
@author: 程声清
Screen接口.
对应前端接口
返回值统一为 {data:JSON结构体, msg:"", status:0}
"""


from flask import Blueprint, g
from flask.json import jsonify
from H_9U.models.result import get_result_model, ResInfo
from H_9U.service import open_screen_svc
from H_9U.util.common import get_params
from H_9U.util.logwrapper import open_log
from H_9U.util.request_handle import response_parameter_resolution
from H_9U.api.sync_queue import add_to_web
from H_9U.models.syncdataname import SyncDataName

open_screen_bp = Blueprint('open_screen', __name__)


@open_screen_bp.route('/createScreen', methods=['GET', 'POST'])
@open_log
def screen_create():
    """
    创建Screen
    :return:参考文档createScreen
    """
    params = g.data
    values = get_params(params, 'deviceId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id = values
    rs = open_screen_svc.screen_create(device_id, params)
    if rs['status'] == 0:
        screen_id = rs['data']['id']
        add_to_web(SyncDataName.Output_Read_List, None, device_id)
        add_to_web(SyncDataName.Screen_Create, None, device_id, screen_id)
    return jsonify(response_parameter_resolution(rs))


@open_screen_bp.route('/deleteScreen', methods=['GET', 'POST'])
@open_log
def screen_delete():
    """
    删除Screen
    :return: 参考文档deleteScreen
    """
    params = g.data
    values = get_params(params, 'deviceId', 'screenIdList')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, screen_list = values
    rs = open_screen_svc.screen_delete(device_id, screen_list)
    if rs['status'] == 0:
        add_to_web(SyncDataName.Output_Read_List, None, device_id)
        for screen_id in screen_list:
            add_to_web(SyncDataName.Screen_Delete, {'deviceId': device_id, 'screenId': screen_id})
    return jsonify(response_parameter_resolution(rs))


@open_screen_bp.route('/clear', methods=['GET', 'POST'])
@open_log
def screen_delete_screen_batch():
    """
    批量删除Screen
    :return: 参考文档deleteScreen
    """
    params = g.data
    device_id = params['deviceId']
    rs = open_screen_svc.screen_delete_batch(device_id)
    if rs['status'] == 0:
        add_to_web(SyncDataName.Output_Read_List, None, device_id)
        add_to_web(SyncDataName.Screen_Read_All_List, None, device_id)
    return jsonify(response_parameter_resolution(rs))


@open_screen_bp.route('/readDetail', methods=['GET', 'POST'])
@open_log
def screen_read_detail():
    """
    读取屏幕详情
    :return: 参考readDetail
    """
    params = g.data
    values = get_params(params, 'deviceId', 'screenId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, screen_id = values
    rs = open_screen_svc.screen_read_detail(device_id, screen_id)
    return jsonify(response_parameter_resolution(rs))


@open_screen_bp.route('/readList', methods=['GET', 'POST'])
@open_log
def screen_read_list():
    """
    读取Screen列表
    :return: readAllList
    """
    params = g.data
    values = get_params(params, 'deviceId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id = values
    rs = open_screen_svc.screen_read_list(device_id)
    return jsonify(response_parameter_resolution(rs))


@open_screen_bp.route('/rename', methods=['GET', 'POST'])
@open_log
def screen_rename():
    """
    屏幕重命名
    :return:
    """
    params = g.data
    values = get_params(params, 'deviceId', 'screenId', 'name')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, screen_id, name = values
    rs = open_screen_svc.screen_rename(device_id, screen_id, params)
    return jsonify(response_parameter_resolution(rs))


@open_screen_bp.route('/ftb', methods=['GET', 'POST'])
@open_log
def screen_ftb():
    """
    ftb
    :return:参考文档ftb
    """
    params = g.data
    values = get_params(params, 'deviceId', 'screenId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, screen_id = values
    rs = open_screen_svc.ftb(device_id, screen_id, params)
    if rs['status'] == 0:
        add_to_web(SyncDataName.Screen_Ftb, params)
        add_to_web(SyncDataName.Output_Read_List, None, device_id)
    return jsonify(response_parameter_resolution(rs))


@open_screen_bp.route('/writeBKG', methods=['GET', 'POST'])
@open_log
def screen_write_bkg():
    """
    设置屏幕BKG
    :return:参考文档 writeBkg
    """
    params = g.data
    values = get_params(params, 'deviceId', 'screenId', 'bkgId', 'enable')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, screen_id, bkg_id, enable = values
    rs = open_screen_svc.screen_bkg_write(
        device_id, screen_id, bkg_id, enable, params)
    if rs['status'] == 0:
        add_to_web(SyncDataName.Screen_Write_BKG, None, device_id, screen_id)
    return jsonify(response_parameter_resolution(rs))


@open_screen_bp.route('/writeFreeze', methods=['GET', 'POST'])
@open_log
def screen_write_freeze():
    """
    freeze
    :return:参考文档freeze
    """
    params = g.data
    values = get_params(params, 'deviceId', 'screenId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, screen_id = values
    rs = open_screen_svc.screen_write_freeze(device_id, screen_id, params)
    if rs['status'] == 0:
        add_to_web(SyncDataName.Screen_Write_Freeze, params)
        add_to_web(SyncDataName.Output_Read_List, None, device_id)
    return jsonify(response_parameter_resolution(rs))


@open_screen_bp.route('/writeImageOSD', methods=['GET', 'POST'])
@open_log
def screen_write_image_osd():
    """
    设置屏幕osd
    :return:参考文档writeOsd
    """
    params = g.data
    values = get_params(params, 'deviceId', 'screenId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, screen_id = values
    rs = open_screen_svc.screen_write_image_osd(
        device_id, screen_id, params)
    if rs['status'] == 0:
        add_to_web(SyncDataName.Screen_Write_OSD, None, device_id, screen_id)
    return jsonify(response_parameter_resolution(rs))


@open_screen_bp.route('/writeOSD', methods=['GET', 'POST'])
@open_log
def screen_write_osd():
    """
    设置屏幕osd
    :return:参考文档writeOsd
    """
    params = g.data
    values = get_params(params, 'deviceId', 'screenId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, screen_id = values
    rs = open_screen_svc.screen_osd_write(
        device_id, screen_id, params, False)
    if rs['status'] == 0:
        add_to_web(SyncDataName.Screen_Write_OSD, None, device_id, screen_id)
    return jsonify(response_parameter_resolution(rs))


@open_screen_bp.route('/nonTimeDetail', methods=['GET', 'POST'])
@open_log
def non_time_detail():
    """
   读指定 screen 的非实时状态下所有图层信息
    :return:参考文档nonTimeDetail
    """
    params = g.data
    values = get_params(params, 'deviceId', 'screenId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, screen_id = values
    rs = open_screen_svc.screen_non_time_detail(device_id, screen_id)
    return jsonify(response_parameter_resolution(rs))


@open_screen_bp.route('/write3D', methods=['GET', 'POST'])
@open_log
def screen_write_3d():
    """
   读指定 screen 的非实时状态下所有图层信息
    :return:参考文档nonTimeDetail
    """
    params = g.data
    values = get_params(params, 'deviceId', 'screenId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, screen_id = values
    rs = open_screen_svc.screen_write_3d(
        device_id, screen_id, params)
    if rs['status'] == 0:
        add_to_web(SyncDataName.Screen_Write_3D, params)
    return jsonify(response_parameter_resolution(rs))


@open_screen_bp.route('/writeOutputMode', methods=['GET', 'POST'])
@open_log
def screen_write_output_mode():
    """
    读取屏幕output布局
    :return: 见文档writeOutputMode
    """
    params = g.data
    values = get_params(params, 'deviceId', 'screenId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, screen_id = values
    rs = open_screen_svc.screen_write_output_mode(
        device_id, screen_id, params)
    if rs['status'] == 0:
        add_to_web(SyncDataName.Output_Read_List, None, device_id)
        add_to_web(SyncDataName.Screen_Write_Output_Mode, None, device_id, screen_id)
    return jsonify(response_parameter_resolution(rs))


@open_screen_bp.route('/writeGamma', methods=['GET', 'POST'])
@open_log
def screen_write_gamma():
    """
    :return:参考文档nonTimeDetail
    """
    params = g.data
    values = get_params(params, 'deviceId', 'screenId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, screen_id = values
    rs = open_screen_svc.screen_write_gamma(
        device_id, screen_id, params)
    if rs['status'] == 0:
        add_to_web(SyncDataName.Screen_Write_Gamma, params)
    return jsonify(response_parameter_resolution(rs))
