"""
Created on 2021年9月06日
@author: 程声清
User接口.
对应前端接口User
返回值统一为 {data:JSON结构体, msg:"", status:0}
"""


from flask import Blueprint, g
from flask.json import jsonify
from H_9U.models.result import get_result_model, ResInfo
from H_9U.service.user import usersvc
from H_9U.util.common import get_params
from H_9U.util.logwrapper import open_log
from H_9U.util.request_handle import response_parameter_resolution

# openapi
open_user_bp = Blueprint('open_user', __name__)


@open_user_bp.route('/login', endpoint='login', methods=['GET', 'POST'])
@open_log
def login():
    """
    用户登录
    :return: token， device_id
    """
    params = g.data
    values = get_params(params, 'username', 'password')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    username, password = values
    rs = usersvc.login(username, password)
    return jsonify(response_parameter_resolution(rs))
