"""
@Project ：h_series 
@File    ：security.py
@IDE     ：PyCharm 
@Author  ：程声清
@Date    ：2023/5/4 11:41 
"""
from flask import Blueprint, g
from flask.json import jsonify

from H_9U.service.security import securitysvc
from H_9U.service.user import usersvc
from H_9U.util.logwrapper import api_log
from H_9U.models.result import get_result_model, ResInfo
from H_9U.util.common import valid_json, valid_params
from flask.globals import request

security_bp = Blueprint('security', __name__)

@security_bp.route('/readSettings', methods=['GET', 'POST'])
@api_log
def api_security_settings_read():
    """
    用户登录
    :return: token， deviceid
    """
    params = valid_json(request.get_data().decode())
    if not params:
        return jsonify(get_result_model(ResInfo.Request_Json_Error))

    values = valid_params(params, 'deviceId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id = values
    rs = securitysvc.settings_read(device_id)
    return jsonify(rs)


@security_bp.route('/pwdRule', methods=['GET', 'POST'])
@api_log
def api_security_pwd_rule():
    """
    用户登录re
    :return: token， deviceid
    """
    params = valid_json(request.get_data().decode())
    if not params:
        return jsonify(get_result_model(ResInfo.Request_Json_Error))

    values = valid_params(params, 'deviceId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id = values
    rs = securitysvc.password_rule_read(device_id)
    return jsonify(rs)


@security_bp.route('/writeSettings', methods=['GET', 'POST'])
@api_log
def api_security_settings_write():
    """
    用户登录
    :return: token， deviceid
    """
    params = valid_json(request.get_data().decode())
    if not params:
        return jsonify(get_result_model(ResInfo.Request_Json_Error))

    values = valid_params(params, 'deviceId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    params.pop('deviceId')
    if len(params.keys()) > 1:
        return jsonify(get_result_model(ResInfo.Params_Error))
    rs = securitysvc.settings_write(params)
    if rs['status'] == 0:
        usersvc.init_config()
    return jsonify(rs)


@security_bp.route('/reset', methods=['GET', 'POST'])
@api_log
def api_security_reset():
    """
    重置安全模式
    :return: token， deviceid
    """
    params = valid_json(request.get_data().decode())
    if not params:
        return jsonify(get_result_model(ResInfo.Request_Json_Error))

    values = valid_params(params, 'deviceId', 'key')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))

    device_id, key = values
    rs = securitysvc.security_config_reset(key)
    if rs['status'] == 0:
        usersvc.init_config()
    return jsonify(rs)


@security_bp.route('/resetAll', methods=['GET', 'POST'])
@api_log
def api_security_reset_all():
    """
    所有安全模式重置
    :return: token， deviceid
    """
    params = valid_json(request.get_data().decode())
    if not params:
        return jsonify(get_result_model(ResInfo.Request_Json_Error))

    values = valid_params(params, 'deviceId', 'type')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))

    device_id, mode = values
    rs = securitysvc.settings_reset_all(mode)
    if rs['status'] == 0:
        usersvc.init_config()
    return jsonify(rs)