from queue import Queue
from flask.globals import g

QueueToApi = Queue()
QueueToOpen = Queue()


def add_to_web(name, data, *args):
    """
    openApi 添加推推送数据给web
    @param name: 推送消息的name，来自SyncName文件
    @param data: 推送数据，如不为空则直接推送数据，不去执行函数
    @param data: 执行函数的参数，将函数执行结果推送，data为None时使用

    使用此队列时需提前设计好逻辑

    1、推送data数据举例
        如： 用户通过openApi移动了图层位置，为提升效率，直接推送图层坐标信息
            name = SyncDataName.Layer_Write_Window
            data = {"screenId": 0, "layerId": 0, "x": 1000, "y": 1000, "width": 960, "height": 540, "deviceId": 0}
            *args = None
        SyncApiManager接收此推送后，根据Name和设计好的业务判断，需要直接推送data数据，则直接推送data
    2、推送函数结果举例：
        如：用户通过openApi创建了新的bkg，依据业务逻辑，web推送全部bkg数据
            name = SyncDataName.Bkg_Read_All_List
            data = None
            *args = 0 // 0表示deviceId
        SyncApiManager接收此推送后，根据Name和设计好的业务判断，需要查询所有bkg并推送查询结果，
        因此会执行bkg_read_list(device_id)方法，方法参数为*args：0
        直接完成后推送方法的执行结果。
    """
    user = g.project_name  # 触发推送的用户名
    token = g.token        # 触发推送的用户token
    QueueToApi.put((user, token, name, data, args))
