"""
Created on 2019年6月28日
@author: 刘益宗
websocket服务
启用线程监听端口
提供发送数据方法
"""
import json
import threading
import time
import queue

from H_9U.api.websocket_server import WebsocketServer
from H_9U.conf.syssettings import SysSettings
from H_9U.util.log import logger


class MessageThread(threading.Thread):
    """
    推送线程类
    """
    def __init__(self, client):
        """
        构造函数
        """
        threading.Thread.__init__(self)
        self.q = queue.Queue()
        self.client = client
        self.loop = True

    def end_loop(self):
        self.loop = False

    def add_queue(self, msg):
        self.q.put(msg)

    def run(self):
        # 加入当前app作用域
        try:
            while self.loop:
                msg = self.q.get(block=True)
                websocket_server.send_message(self.client, msg)
        except Exception as e:
            print(e)

# Called for every client connecting (after handshake)
def _new_client(client, server):
    """
    新客户端连接钩子函数
    :param client: 客户端
    :param server: 服务器
    :return: None
    """
    print("New client connected and was given id %d" % len(websocket_server.clients))
    client['thread'] = MessageThread(client)
    client['thread'].start()
    # client['handler'].request.settimeout(120)
    # server.send_message_to_all("Hey all, a new client has joined us")


# Called for every client disconnecting
def _client_left(client, server):
    """
    客户端断开钩子函数
    :param client: 客户端
    :param server: 服务器
    :return: None
    """
    print("Client(%d) disconnected" % len(websocket_server.clients))
    client['thread'].end_loop()


# Called when a client sends a message
def _message_received(client, server, message):
    """
    接收消息钩子函数
    :param client: 客户端
    :param server: 服务器
    :param message: 消息
    :return: None
    """
    if len(message) > 200:
        message = message[:200] + '..'
    print("Client(%d) said: %s" % (client['id'], message))
    if client not in server.clients:
        client['thread'].end_loop()
        client['handler'].close()
        client['handler'].finish()
    else:
        server.send_message(client, 'i got it')


def message_send(data):
    """
    发送消息函数
    :param data: 消息
    :return: None
    """
    # logger.info('推送数据：%s 开始' % data['name'])
    # 存在websocketServer并且客户端数量大于0
    if websocket_server and len(websocket_server.clients) > 0:
        msg = json.dumps(data, ensure_ascii=False)
        for client in websocket_server.clients:
            try:
                client['thread'].add_queue(msg)
            except Exception as e:
                logger.exception(e)
                logger.error('推送数据异常：%s' % client['address'])
                client['handler'].finish()
        print('8'*100)
        print(threading.active_count())


def clear_clients():
    if websocket_server and len(websocket_server.clients) > 0:
        for client in websocket_server.clients:
            client['handler'].finish()


class WebSocketServerThread(threading.Thread):
    """
    websocket线程类
    """
    def __init__(self):
        super(WebSocketServerThread, self).__init__()

    def run(self):
        global websocket_server
        while True:
            try:
                # 启动线程
                websocket_server = WebsocketServer(SysSettings.WebSocket_Port, host='0.0.0.0')
                websocket_server.set_fn_new_client(_new_client)
                websocket_server.set_fn_client_left(_client_left)
                websocket_server.set_fn_message_received(_message_received)
                # websocket_server.timeout = 5
                # websocket_server.socket.settimeout(5)

                websocket_server.run_forever()
            except Exception as e:
                print('socketserver err', e)
                logger.error('websocket thread err', e)
                if websocket_server:
                    websocket_server.server_close()
            time.sleep(1)

