
"""
Created on 2019年6月28日
@author: 刘益宗
系统统一配置
"""
import os
import platform


class SysSettings:

    # socket链接设备IP和端口
    ServerIP = '127.0.0.1'
    ServerPort = 8200

    # 上行-数据采集Socket-UDP组播地址、端口
    MULTICAST_ADDRESS = "235.235.235.236"
    MULTICAST_PORT = 7777
    MULTICAST_BUF_SIZE = 4096

    # udp搜索设备列表端口
    UDP_DEVICE_DETECT_PORT = 7788

    # 通讯器是否计算耗时
    CalCommunicationUsedTime = 0

    if platform.system() == 'Linux':
        Device_Download_Path = r'/tmp/download'  # 中间件导出设备信息文件路径
        Upload_Upgrade_File_Path = r'/usr/Hseries/bin/web/upgrade'  # 升级文件夹路径
        Download_IPC_File_Path = r'/tmp/download'  # ipc文件下载路径
        # Device_Download_Path = os.path.join('static', 'download')
    else:  # if platform.system() == 'Windows':
        Device_Download_Path = r'D:\tmp\download'
        Upload_Upgrade_File_Path = r'D:\usr\upgrade'
        Download_IPC_File_Path = r'D:\tmp\download'  # ipc文件下载路径

    # 文件上传允许扩展名
    AllowedFileTypeList = ['bmp', 'png', 'jpg', 'jpeg', 'zip', 'dat', 'ttf', 'otf', 'woff', 'fnt', 'csv', 'sdp']
    # bkg 上传目录
    Upload_BKG_Path = os.path.join('static', 'bkg')
    # 升级文件上传路径
    # Upload_Upgrade_File_Path = os.path.join('static', 'upgrade')
    # edid文件上传路径
    Upload_Edid_File_Path = os.path.join('static', 'edid')
    # osd文件上传路径
    Upload_OSD_File_Path = os.path.join('static', 'osd')
    # 设备信息上传路径
    Upload_Device_Settings_File_Path = os.path.join('static', 'devicesettings')
    # bkg缩略图路径
    Image_Thumbnail_Path = os.path.join('static', 'thumbnail')
    # 中性文件上传路径
    Nomark_Mode_File_Path = os.path.join('static', 'nomarkdata')
    # 普通文件上传路径
    Normal_File_Path = os.path.join('static', 'upload')
    # 字体上传路径
    Font_File_Path = os.path.join('static', 'uploadFont')
    Link_Font_File_Path = os.path.join('static', 'midfont')
    # ipc上传目录
    Upload_IPC_Path = os.path.join('static', 'ipc')
    # spd上传目录
    Upload_SPD_Path = os.path.join('static', 'sdp')
    # 设备Id号
    Device_Id = 0
    # openapi bkg文件上传允许扩展名
    OpenAllowedFileTypeList = ['bmp', 'png', 'jpg', 'jpeg']

    # # 是否加密 1 加密 0  是不加密
    # is_encrypt = 0

    # 缩略图默认大小
    BKG_Thumbnail_Size = (136, 80)
    Max_BKG_File_Length = 1 * 1024 * 1024 * 1024  # 1G

    # User Token Key
    Token_Key = '123456'

    # 预监和回显地址
    MVR_URL = 'ws://192.168.0.11:8081'
    Echo_URL = 'ws://192.168.0.11:8082'
    Config_URL = 'ws://192.168.0.11:7999'

    # 数据同步websocket端口
    WebSocket_Port = 8080
    HTTPSWebSocketPort = 8089

    # 系统最大token数量
    Max_User_Token_Count = 500
    Max_Login_Time = 3600 * 168

    # 不校验token的url
    Not_Valid_Token_Url = [
        '/api/user/login',
        '/api/user/logout',
        '/api/main/initStatus',
        '/api/log/export',
        '/api/device/exportSettings',
        '/api/main/cacheClear',
        '/api/main/readNomarkMode',
        '/api/main/readLanguageMode',
        '/api/main/writeLanguageMode',
        '/api/device/selfCheckStatus',
        '/api/user/getVerifyCode',
        '/api/security/pwdRule',
        '/api/device/readMainControl',
        '/api/device/checkAuthCode',
        '/api/user/forgetSetPwd',
        '/api/user/checkVerifyCode',
    ]
    # 不处理加密的url
    Not_Valid_Des_Url = ['/open/api/main/initStatus']

    # 查询升级状态url
    Upgrade_Url = [
        '/api/device/upgradeStatus',
        '/api/device/upgradeInfo',
        '/api/user/login',
        '/api/log/export',
        '/api/device/endProcess',
        '/api/main/readLanguageMode']

    # 查询升级状态url
    Open_Upgrade_Url = [
        '/open/api/device/upgradeStatus',
        '/open/api/device/upgradeInfo',
        '/open/api/user/login',
        '/open/api/log/export',
        '/open/api/device/endProcess',
        '/open/api/main/readLanguageMode']
    # 设备自建不拦截url
    Device_Self_Check_Url = [
        '/api/user/login',
        '/api/log/export',
        '/api/device/selfCheckStatus',
        '/api/device/selfCheck',
        '/api/device/endProcess',
        '/api/main/readLanguageMode']
    # 设备自建不拦截url
    Open_Device_Self_Check_Url = [
        '/open/api/user/login',
        '/open/api/log/export',
        '/open/api/device/selfCheckStatus',
        '/open/api/device/selfCheck',
        '/open/api/device/endProcess',
        '/open/api/main/readLanguageMode']

    # initurl不校验地址
    Init_Url = [
        '/api/log/export',
        '/api/main/initStatus',
        '/open/api/main/initStatus',
        'open/api/log/export',
        '/open/api/main/initStatus']

    # openapi initurl不校验地址
    # Open_Init_Url = ['open/api/log/export', '/open/api/main/initStatus']

    # 升级时间限制,秒
    Upgrade_Time = 60 * 180

    # 中间件日志绝对路径
    Middleware_Abs_Path = r'/usr/Hseries/bin/Middleware/log'
    # 中间件字体路径
    Middleware_Font_Data_Abs_Path = '/usr/Hseries/bin/Middleware/'
    # 中间件数据文件夹路径
    Middleware_Data_Abs_Path = '/usr/Hseries/bin/Middleware/data'  # H系列
    E_Middleware_Data_Abs_Path = '/usr/Hseries/bin/Middleware/SYNC_DATA/data'  # E系列
    Middleware_Nomark_Data_Abs_Path = '/usr/Hseries/bin/Middleware/custom'  # H系列
    E_Middleware_Nomark_Data_Abs_Path = '/usr/Hseries/bin/Middleware/SYNC_DATA/custom'  # E系列
    Middleware_All_Slot_Version_Path = '/usr/Hseries/bin/Middleware/hw_version'
    Middleware_Safe_Config_Path = '/usr/Hseries/bin/Middleware/safe.conf' # 系统安全配置文件
    Middleware_Core_File_Path = '/usr/Hseries/bin/Middleware/core'
    Middleware_CoreDump_File_Path ='/usr/Hseries/bin/Middleware/coreDump/core'
    # Middleware_Safe_Config_Path =  'I:\safe.conf'  # 系统安全配置文件
    # 当前程序版本类型文件地址
    Middleware_Version_Type_Path = '/usr/Hseries/bin/Middleware/version.conf'
    # 当前版本类型，0-主线，1-定制，-1-未初始化
    Version_Type = -1
    Middleware_BKG_Folder = 'BKGImage'
    Middleware_Web_Data_Path = os.path.join('static', 'data')
    Local_Device_Type = 1  # 设备类型： 1 H系列； 2 E系列
    Safe_Config_SH_Path = '/usr/Hseries/bin/web/H_9U/H_9U/conf/nginx_config.sh'
    Safe_Valid_File = 'safe_valid_conf'
    H20_Valid_File = 'MasterProcess_H20U'
    A20_Valid_File = 'MasterProcess_Alita_20U'
    SoftwareVersion = '1.9.8.3'
    InnerVersion = 'H1930_20231201_Screen_Name_Repeat'


