"""
Created on 2021年10月26日
@author: 程声清
初始化建表脚本
"""
import time

from flask import json, g


from H_9U.models.sysconst import NormalModeSettings, SecurityConfigType, SafeConfig, SafeModeSettings, DeviceType

from H_9U.util.log import logger
from H_9U.util.sqlitepool import sqllock



def _created_all_table(conn_pool):
    print("start created table")
    sqllock.acquire()
    conn = conn_pool.get()
    cursor = conn.cursor()
    try:
        # 初始化device_info表
        cursor.execute(
            'CREATE TABLE IF NOT EXISTS device_info('
            'id INTEGER PRIMARY KEY AUTOINCREMENT, '
            'device_id int(10) NOT NULL DEFAULT (0),'
            'data_type longtext NOT NULL,'
            'data_json longtext NOT NULL,'
            'create_time datetime NOT NULL)')

        cursor.execute("select data_json from device_info  where  data_type=:data_type",
                       {"data_type": 'security_' + SecurityConfigType.SecurityModeConfig})
        rows = cursor.fetchone()
        if rows is None:
            cursor.execute("insert into device_info (data_type, data_json, create_time) values(?, ?, ?)",
                           ('security_securityModeConfig', '{"mode": 1}', int(time.time())))
        cursor.execute("select data_json from device_info  where  data_type=:data_type",
                       {"data_type": 'security_' + SecurityConfigType.LoginConfig})
        rows = cursor.fetchone()
        if rows is None:
            cursor.execute("insert into device_info (data_type, data_json, create_time) values(?, ?, ?)",
                           ('security_loginConfig', json.dumps(NormalModeSettings['loginConfig']), int(time.time())))
        cursor.execute("select data_json from device_info  where  data_type=:data_type",
                       {"data_type": 'security_' + SecurityConfigType.PwdConfig})
        rows = cursor.fetchone()
        if rows is None:
            cursor.execute("insert into device_info (data_type, data_json, create_time) values(?, ?, ?)",
                           ('security_pwdConfig', json.dumps(NormalModeSettings['pwdConfig']), int(time.time())))
        cursor.execute("select data_json from device_info  where  data_type=:data_type",
                       {"data_type": 'http_enable'})
        rows = cursor.fetchone()
        if rows is None:
            cursor.execute("insert into device_info (data_type, data_json, create_time) values(?, ?, ?)",
                           ('http_enable', json.dumps({"is_open":0}), int(time.time())))

        cursor.execute("select data_json from device_info  where  data_type=:data_type",
                       {"data_type": 'device_safe_reset'})
        rows = cursor.fetchone()
        if rows is None:
            cursor.execute("insert into device_info (data_type, data_json, create_time) values(?, ?, ?)",
                           ('device_safe_reset', json.dumps({"is_reset":0}), int(time.time())))

        cursor.execute("select data_json from device_info  where  data_type=:data_type",
                       {"data_type": 'is_displayed'})
        rows = cursor.fetchone()
        if rows is None:
            cursor.execute("insert into device_info (data_type, data_json, create_time) values(?, ?, ?)",
                           ('is_displayed', json.dumps({"is_displayed": 1}), int(time.time())))


        cursor.execute("select data_json from device_info  where  data_type=:data_type",
                       {"data_type": 'is_preset_id'})
        rows = cursor.fetchone()
        if rows is None:
            cursor.execute("insert into device_info (data_type, data_json, create_time) values(?, ?, ?)",
                           ('is_preset_id', json.dumps({"is_preset_id": 0}), int(time.time())))
        # 初始化用户表
        cursor.execute(
            'CREATE TABLE IF NOT EXISTS user('
            'id INTEGER PRIMARY KEY AUTOINCREMENT, '
            'username  VARHCAR (50)  UNIQUE NOT NULL,'
            'password VARHCAR (50),'
            'tel VARHCAR (50),'
            'email VARHCAR (50),'
            'type INTEGER DEFAULT (1),'
            'status INTEGER  DEFAULT (1),'
            'superadmin INTEGER DEFAULT(0))')
        cursor.execute(
            "select * from  user where  superadmin=:superadmin", {"superadmin": 1})
        rows = cursor.fetchone()
        if rows is None:
            # 初始化用户表数据
            cursor.execute(
                "INSERT INTO user(id,username, password, tel, email, [type],status, superadmin)"
                "VALUES(1,'admin','21232f297a57a5a743894a0e4a801fc3','','', 0, 1, 1)")
            cursor.execute(
                "INSERT INTO user(id,username, password, tel, email,[type],status, superadmin)"
                "VALUES(2,'HseriesAdmin','Nova_password.','', '', 1, 1, 0)")
        # 初始化菜单表
        cursor.execute(
            'CREATE TABLE IF NOT EXISTS menu ('
            'id INTEGER PRIMARY KEY AUTOINCREMENT, '
            'name  VARHCAR (50)  UNIQUE NOT NULL,'
            'level INTEGER DEFAULT (0),'
            'parent_id INTEGER,'
            'sort INTEGER,'
            'active INTEGER  DEFAULT (1),'
            'endPoint VARHCAR (50),'
            'code INTEGER,'
            'type INTEGER)')
        cursor.execute(
            "select id, name, level, parent_id, sort, active, endPoint,code, [type] from  menu ")
        rows = cursor.fetchall()
        if len(rows) == 0:
            # 初始化菜单表数据
            cursor.execute(
                    "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                    "VALUES(1,'配屏模块',0, 0, 1, 1,'',1,1)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(2, '编辑模块',0, 0, 8, 1,'',2,1)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(3, '预监模块',0, 0, 9, 1,'',3,1)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(4, '设备模块',0, 0, 10, 1,'',4,1)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(5, '设置模块',0, 0, 13, 1,'',5,1)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(6, 'EDID管理',1, 5, 14, 1,'',6,1)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(7, '用户管理',1, 23, 33, 1,'',7,1)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(8, '备份管理',1, 5, 18, 1,'',8,1)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(9, '通信设置',1, 5, 19, 1,'',9,1)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(10, '固件升级',1, 5, 20, 1,'',10,1)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(11, '其他',1, 5, 21, 1,'',11,1)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(12, 'IPC管理',1, 5, 27, 1,'',12,1)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(13, '重置',1, 5, 30, 1,'',13,1)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(14,'OpenApi管理',1, 5, 31, 1,'',14,1)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(15, '关于',0, 0, 6, 0,'',15,1)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(16, '新建屏幕',1, 1, 3, 1,'',16,2)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(17, '删除屏幕',1, 1, 4, 1,'',17,2)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(18, '3D',1, 1, 5, 1,'',18,2)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(19, 'HDR',1, 1, 6, 1,'',19,2)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(20, '同步相位偏移',1, 1, 7, 1,'',20,2)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(21, '设备自检',1, 4, 12, 1,'',21,2)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(22, 'IPC查看/编辑',1, 12, 29, 1,'',27,2)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(23, '权限管理',1, 5, 32, 1,'',28,1)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(24, '查看/编辑角色权限',1, 25, 38, 1,'',30,2)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(25, '角色管理',1, 23, 36, 1,'',31,1)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(26, '编辑区域视频流',1, 11, 23, 1,'',32,2)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(27, '开启GenLock',1, 11, 24, 1,'',33,2)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(28, '场景特效',1, 11, 25, 1,'',34,2)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(29, '开启设备备份',1, 11, 26, 1,'',35,2)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(30, 'EDID输入',1, 6, 16, 1,'',39,2)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(31, 'EDID输出',1, 6, 17, 1,'',40,2)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(32, 'IPC仅查看',1, 12, 28, 1,'',41,2)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(33, '用户仅查看',1, 7, 34, 1,'',42,2)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(34, '用户查看/编辑',1, 7, 35, 1,'',43,2)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(35, '角色仅查看',1, 25, 37, 1,'',44,2)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(36, 'EDID仅查看',1, 6, 15, 1,'',46,2)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(37, '配屏模块仅查看',1, 1, 2, 1,'',47,2)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(38, '设备模块仅查看',1, 4, 11, 1,'',48,2)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(39, '其他仅查看',1, 11, 22, 1,'',49,2)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(40, '日志管理',1, 5, 1, 1,'',50,1)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(41, '登录日志',1, 40, 1, 1,'',51,1)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(42, '操作日志',1, 40, 1, 1,'',52,1)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(43, '会话管理',1, 5, 1, 1,'',53,1)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(44, '会话查看',1, 43, 1, 1,'',54,2)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(45, '结束会话',1, 43, 2, 1,'',55,2)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(46, '查看登录日志',1, 41, 1, 1,'',56,2)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(47, '删除登录日志',1, 41, 2, 1,'',57,2)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(48, '查看操作日志',1, 42, 1, 1,'',58,2)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(49, '删除操作日志',1, 42, 2, 1,'',59,2)")
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(50, '屏幕及图层背景样式',1, 11, 6, 1,'',60,2)")
            #  "VALUES(15, '关于',0, 0, 6, 0,'',15,1)")

        else:
            for row in rows:
                active = row[5]
                code = row[7]
                if code == 50 and active == 0:
                    menu_status_handle(cursor, code, 5, 1)
                if code == 51 and active == 0:
                    menu_status_handle(cursor, code, 40, 1)
                if code == 52 and active == 0:
                    menu_status_handle(cursor, code, 40, 1)
                if code == 53 and active == 0:
                    menu_status_handle(cursor, code, 5, 1)
                if code == 54 and active == 0:
                    menu_status_handle(cursor, code, 43, 1)
                if code == 55 and active == 0:
                    menu_status_handle(cursor, code, 43, 1)
                if code == 56 and active == 0:
                    menu_status_handle(cursor, code, 41, 1)
                if code == 57 and active == 0:
                    menu_status_handle(cursor, code, 41, 1)
                if code == 58 and active == 0:
                    menu_status_handle(cursor, code, 42, 1)
                if code == 59 and active == 0:
                    menu_status_handle(cursor, code, 42, 1)
        menu_status_add(cursor)
        from H_9U import app
        with app.app_context():
            g.token = "server_token"
            safe_config(cursor)
        # from H_9U import app
        # with app.app_context():
        #     g.token = "server_token"
        #     is_safe = safe_config(cursor)
        # # 安全模式不显示帮助与openApi菜单
        # if is_safe == SafeConfig.IsSafe:
        #     cursor.execute("update menu set active=? where code=?", (0, 14))
        #     cursor.execute("update menu set active=? where code=?", (0, 62))
        # 初始化角色表
        cursor.execute(
            'CREATE TABLE IF NOT EXISTS role ('
            'id INTEGER PRIMARY KEY AUTOINCREMENT, '
            'name  VARHCAR (50)  UNIQUE NOT NULL,'
            'parent_id INTEGER,'
            'sort INTEGER,'
            'active INTEGER  DEFAULT (1),'
            'role_type INTEGER DEFAULT(3))')
        cursor.execute(
            "select * from  role ")
        rows = cursor.fetchall()
        if len(rows) == 0:
            # 初始化角色表数据
            cursor.execute(
                 "insert into role(id,name, parent_id, sort, active, role_type)"
                 " values(1,'admin',0,1,1,1)")
            cursor.execute(
                "insert into role(id,name, parent_id, sort, active, role_type)"
                " values(2,'默认角色',-1,0,1,2)")

        # 初始化用户_角色表
        cursor.execute(
            'CREATE TABLE IF NOT EXISTS user_role ('
            'id INTEGER PRIMARY KEY AUTOINCREMENT, '
            'user_id INTEGER,'
            'role_id INTEGER)')
        cursor.execute(
            "select * from  user_role ")
        rows = cursor.fetchall()
        if len(rows) == 0:
            # 初始化用户_角色表数据
            cursor.execute(
            "INSERT INTO user_role(id,user_id, role_id)"
            "VALUES(1,1,1)")

        # 初始化角色_数据表
        cursor.execute(
        'CREATE TABLE IF NOT EXISTS role_data ('
        'id INTEGER PRIMARY KEY AUTOINCREMENT, '
        'input_id INTEGER,'
        'output_id INTEGER,'
        'screen_id INTEGER,'
        'menu_id INTEGER,'
        'mvr_id INTEGER,'
        'data_type INTEGER,'
        'role_id INTEGER)')

        # 初始化openApi表
        cursor.execute(
            'CREATE TABLE IF NOT EXISTS openUserInfo('
            'id INTEGER PRIMARY KEY AUTOINCREMENT, '
            'pId  VARHCAR (50)  UNIQUE     NOT NULL,'
            'projectName VARHCAR (50)  NOT NULL,'
            'status INTEGER  NOT NULL   DEFAULT (1),'
            'isEncrypt INTEGER  NOT NULL DEFAULT (0),'
            'secretKey VARCHAR (50)  NOT NULL)')
        cursor.execute(
            "select * from  openUserInfo ")
        # 初始化日志表
        cursor.execute(
            'CREATE TABLE IF NOT EXISTS sys_log('
            'id INTEGER PRIMARY KEY AUTOINCREMENT, '
            'type  tinyint(4) NOT NULL,'
            'ip VARHCAR (64)  NOT NULL,'
            'log_time datetime NOT NULL,'
            'log_module int(11) NOT NULL,'
            'operation varchar(64) NOT NULL,'
            'message text NOT NULL,'
            'username varchar(64) NOT NULL,'
            'userid int(10) NOT NULL,'
            'client tinyint(4) NOT NULL,'
            'function varchar(255) NOT NULL)')
        # 初始化device_auth_code表
        cursor.execute(
            'CREATE TABLE IF NOT EXISTS device_auth_code('
            'id INTEGER PRIMARY KEY AUTOINCREMENT, '
            'sn VARHCAR (128)  NOT NULL,'
            'id_code varchar(128) NOT NULL,'
            'auth_code varchar(128) NOT NULL,'
            'create_time datetime NOT NULL)')
        # 初始化openApi表数据;删除大华的标记
        cursor.execute("delete from openUserInfo where pId=:pId", {"pId": "1"})
        # 初始化modelConf表
        cursor.execute(
            'CREATE TABLE IF NOT EXISTS modelConf('
            'id INTEGER PRIMARY KEY AUTOINCREMENT, '
            'model varchar(64) NOT NULL,'
            'key varchar(64) NOT NULL,'
            'value INTEGER NOT NULL)')
    except Exception as e:
        print(e)
        logger.error("...........Create table failed ...........")
        return False
    finally:
        if sqllock.locked():
            sqllock.release()
    conn.commit()
    conn.close()
    logger.info("Create table success")


def menu_status_handle(cursor, code, parent_id, active):
    try:
        cursor.execute("update menu set active=?, parent_id=? where code=?",(active, parent_id, code))
    except Exception as e:
        logger.error("...........Execute sql failed ...........", e)
        return False

def menu_status_add(cursor):
    try:
        cursor.execute(
            "select * from  menu where  code=:code", {"code": 61})
        row = cursor.fetchone()
        if row is None:
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(51,'安全配置',1, 5, 1, 1,'',61,1)")
        cursor.execute(
            "select * from  menu where  code=:code", {"code": 62})
        row = cursor.fetchone()
        if row is None:
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(52, '帮助',0, 0, 6, 1,'',62, 1)")
        cursor.execute(
            "select * from  menu where  code=:code", {"code": 63})
        row = cursor.fetchone()
        if row is None:
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(53, 'NDI',1, 5, 6, 1,'',63, 1)")
        cursor.execute(
            "select * from  menu where  code=:code", {"code": 64})
        row = cursor.fetchone()
        if row is None:
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(54, 'NDI仅查看',1, 53, 6, 1,'',64, 2)")
        cursor.execute(
            "select * from  menu where  code=:code", {"code": 65})
        row = cursor.fetchone()
        if row is None:
            cursor.execute(
                "INSERT INTO menu(id, name, level, parent_id, sort, active, endPoint,code, [type])"
                "VALUES(55, 'NDI编辑',1, 53, 6, 1,'',65, 2)")
    except Exception as e:
        logger.error("...........Execute sql failed ...........", e)
        return False


def safe_config(cursor):
    from H_9U.util.cache import cacher
    from H_9U.models.cachekey import CacheKey
    device_id = 0
    key = CacheKey.device_is_safe(device_id)
    is_safe = cacher.DeviceCache.get(key)
    if is_safe is None:
        from H_9U.util.common import device_safe_config_read
        from H_9U import SysSettings
        is_safe = device_safe_config_read(SysSettings.Middleware_Safe_Config_Path)
    cursor.execute("select data_json from device_info  where  data_type=:data_type",
                   {"data_type": 'device_safe_reset'})
    row = cursor.fetchone()
    print("is_reset==", json.loads(row[0])['is_reset'])

    # 未重置且是安全版本
    if json.loads(row[0])['is_reset']== 0 and is_safe == SafeConfig.IsSafe:
        safe_data_init(cursor)
    # 未重置且是主线版本
    if is_safe == SafeConfig.IsNotSafe:
        common_data_init(cursor)
    return is_safe


def safe_data_init(cursor):
    try:
        # 初始化用户表数据
        cursor.execute(
            "update user set password = ? where username <> ?",('pbkdf2:sha256:100000$qIoQ2da7JVzy0Xoz$28698afc7b91e7ef8546a0cb14aec1ab05839dbbaf67fac5c6120c8241c3d715', 'HseriesAdmin'))
        cursor.execute(
            "update user set password = ? where username = ?",('pbkdf2:sha256:100000$QmRzDScUJ85jS2Lo$363232a6031d0ae1b7e7a61cd0553bd609fed296db74ff97315f53fe9e7b2d26', 'HseriesAdmin'))
        cursor.execute(
            "update device_info set  data_json =?, create_time =? where data_type =?",
            (json.dumps(SafeModeSettings['loginConfig']), int(time.time()),'security_loginConfig'))
        cursor.execute(
            "update device_info set  data_json =?, create_time =? where data_type =?",
            (json.dumps(SafeModeSettings['pwdConfig']), int(time.time()), 'security_pwdConfig'))
        cursor.execute(
            "update device_info set  data_json =?, create_time =? where data_type =?",(json.dumps({"is_reset":1}), int(time.time()), 'device_safe_reset'))
        cursor.execute(
            "update menu set active=? where code=?", (0, 14))
        cursor.execute(
            "update menu set active=? where code=?", (0, 62))
        cursor.execute(
            "update menu set active=? where code=?", (1, 61))

    except Exception as e:
        logger.error("...........Execute sql failed ...........", e)
        return False


def common_data_init(cursor):
    try:
        # 初始化用户表数据
        # cursor.execute("update user set password =? where username =?",('21232f297a57a5a743894a0e4a801fc3', 'admin'))
        #
        # cursor.execute("update user set password =? where username =?",('Nova_password.', 'HseriesAdmin'))
        #
        # cursor.execute("update device_info set data_json =?, create_time = ? WHERE data_type =?",(json.dumps({'is_reset':1}), int(time.time()), 'device_safe_reset'))
        cursor.execute(
            "update menu set active=? where code=?", (0, 61))
        from H_9U.util.common import get_main_model_id
        is_flag = get_main_model_id()
        if is_flag:
            cursor.execute( "update menu set active=? where code=?", (0, 12))
            cursor.execute(
                "select * from  device_info where  data_type=:data_type", {"data_type": 'main_packagePwd'})
            row = cursor.fetchone()
            if row is None:
                cursor.execute("insert into device_info (data_type, data_json, create_time) values(?, ?, ?)",
                               ('main_packagePwd', "Pass123Word!@2", int(time.time())))
    except Exception as e:
        logger.error("...........Execute sql failed ...........", e)
        return False
