"""
Created on 2024年3月5日
@author: 程声清
network接口.
对应前端接口network_mao_impl
返回值统一为 {data:JSON结构体, msg:"", status:0}
"""
from H_9U.protocol.fncode import FnCode
from H_9U.models.result import transfer_midware_resp
from H_9U import controller as ctrl
from H_9U.util.logwrapper import log_wrapper




@log_wrapper
def network_source_group_create(device_id, data):
    """
    创建ndi源分组
    :param device_id: 设备id
    :return: 源id
    """
    return transfer_midware_resp(ctrl.write(FnCode.NETWORK_SOURCE_GROUP_CREATE, [data],  device_id))


@log_wrapper
def network_source_group_delete(device_id, data):
    """
    编辑ndi源
    :param device_id: 设备id
    :return: 源id
    """
    return transfer_midware_resp(ctrl.write(FnCode.NETWORK_SOURCE_GROUP_DELETE, [data], device_id))


@log_wrapper
def network_source_group_update(device_id, group_id, data):
    """
    编辑ndi源
    :param device_id: 设备id
    :return: 源id
    """
    return transfer_midware_resp(ctrl.write(FnCode.NETWORK_SOURCE_GROUP_UPDATE, [data], device_id, group_id))


@log_wrapper
def network_source_group_list(device_id):
    """
    编辑ndi源
    :param device_id: 设备id
    :return: 源id
    """
    return transfer_midware_resp(ctrl.read(FnCode.NETWORK_SOURCE_GROUP_LIST, device_id))


@log_wrapper
def network_source_group_detail(device_id, group_id):
    """
    编辑ndi源
    :param device_id: 设备id
    :return: 源id
    """
    # 分组Id低字节
    group_id_low = group_id % 256
    # 分组Id高字节
    group_id_high = group_id // 256

    print("group_id_low==",group_id_low)
    print("group_id_high==", group_id_high)
    return transfer_midware_resp(ctrl.read(FnCode.NETWORK_SOURCE_GROUP_DETAIL, device_id, group_id_low, group_id_high))


@log_wrapper
def network_source_group_node_create(device_id, group_id, data):
    """
    编辑ndi源
    :param device_id: 设备id
    :return: 源id
    """
    return transfer_midware_resp(ctrl.write(FnCode.NETWORK_SOURCE_GROUP_NODE_CREATE, [data], device_id, group_id))


@log_wrapper
def network_source_group_node_delete(device_id, group_id, data):
    """
    编辑ndi源
    :param device_id: 设备id
    :return: 源id
    """
    return transfer_midware_resp(ctrl.write(FnCode.NETWORK_SOURCE_GROUP_NODE_DELETE, [data], device_id, group_id))


@log_wrapper
def network_source_group_node_clear(device_id, data):
    """
    编辑ndi源
    :param device_id: 设备id
    :return: 源id
    """
    return transfer_midware_resp(ctrl.write(FnCode.NETWORK_SOURCE_GROUP_NODE_CLEAR, [data], device_id))