"""
Created on 2019年6月28日
@author: 刘益宗
场景接口.
对应协议中的<presest>.
返回值统一为 {data:JSON结构体, msg:"", status:0}
"""
from H_9U.models.sysconst import ReadSign
from H_9U.protocol.fncode import FnCode
from H_9U.models.result import transfer_midware_resp
from H_9U import controller as ctrl
from H_9U.util.logwrapper import log_wrapper
from H_9U.util.formatdata import format_client_data, format_server_data

@log_wrapper
def preset_list_read(device_id, screen_id):
    """
    获取屏幕的场景枚举
    :param device_id: 设备id
    :param screen_id: 屏幕id
    :return: 参考接口文档presetList
    """
    return transfer_midware_resp(ctrl.read(FnCode.PRESET_LIST, device_id, screen_id, ReadSign.Is_Not_ALL))


@log_wrapper
def preset_full_detail_read(device_id, screen_id, preset_id):
    """
    场景详情
    :param device_id: 设备id
    :param screen_id: 屏幕id
    :param preset_id: 场景id
    :return: 参考接口文档presetFullDetail
    """
    return transfer_midware_resp(ctrl.read(FnCode.PRESET_FULL_DETAIL, device_id, screen_id, preset_id))


@log_wrapper
def preset_create_write(device_id, screen_id, data):
    """
    创建场景
    :param device_id: 设备号
    :param screen_id: 屏幕号
    :param data: JSON对象
    :return: 参考接口文档presetCreate
    """
    return transfer_midware_resp(ctrl.write(FnCode.PRESET_CREATE, [data], device_id, screen_id))


@log_wrapper
def preset_delete_write(device_id, screen_id, preset_id, data):
    """
    删除场景
    :param device_id: 设备和
    :param screen_id: 屏幕号
    :param preset_id: 场景号
    :param data: json data
    :return: 参考接口文档presetDelete
    """
    return transfer_midware_resp(ctrl.write(FnCode.PRESET_DELETE, [data], device_id, screen_id, preset_id))


@log_wrapper
def preset_general_read(device_id, screen_id, preset_id):
    """
    读取场景的基本信息
    :param device_id: 设备号
    :param screen_id: 屏幕号
    :param preset_id: 场景号
    :return: 参考接口文档presetGeneral
    """
    return transfer_midware_resp(ctrl.read(FnCode.PRESET_GENERAL, device_id, screen_id, preset_id))


@log_wrapper
def preset_general_write(device_id, screen_id, preset_id, data):
    """
    设置场景基本信息
    :param device_id: 设备号
    :param preset_id: 场景号
    :param screen_id: 屏幕号
    :param data: 参数
    :return: 参考接口文档presetGeneral
    """
    return transfer_midware_resp(ctrl.write(FnCode.PRESET_GENERAL, [data], device_id, screen_id, preset_id))


@log_wrapper
def preset_play_write(device_id, screen_id, preset_id, data):
    """
    播放场景
    :param device_id: 设备号
    :param screen_id: 屏幕号
    :param preset_id: 场景号
    :return: 参考接口文档presetPlay
    """
    return transfer_midware_resp(ctrl.write(FnCode.PRESET_PLAY, [data], device_id, screen_id, preset_id))


@log_wrapper
def preset_group_list_read(device_id, screen_id):
    """
    获取屏幕的场景枚举
    :param device_id: 设备id
    :param screen_id: 屏幕id
    :return: 参考接口文档presetGroupList
    """
    return transfer_midware_resp(ctrl.read(FnCode.PRESET_GROUP_LIST, device_id, screen_id))


@log_wrapper
def preset_group_create_write(device_id, screen_id, data):
    """
    创建分组
    :param device_id: 设备id
    :param screen_id: 屏幕id
    :param data: json
    :return: 参考接口文档presetGroupCreate
    """
    return transfer_midware_resp(ctrl.write(FnCode.PRESET_GROUP_CREATE, [data], device_id, screen_id))


@log_wrapper
def preset_group_update_write(device_id, screen_id, data):
    """
    修改分组
    :param device_id: 设备id
    :param screen_id: 屏幕id
    :param data: json
    :return: 参考接口文档presetGroupUpdate
    """
    return transfer_midware_resp(ctrl.write(FnCode.PRESET_GROUP_UPDATE, [data], device_id, screen_id))


@log_wrapper
def preset_group_delete_write(device_id, screen_id, data):
    """
    删除场景分组
    :param device_id: 设备id
    :param screen_id:  屏幕id
    :param data: 场景组信息
    :return: 参考接口文档presetGroupDelete
    """
    return transfer_midware_resp(ctrl.write(FnCode.PRESET_GROUP_DELETE, [data], device_id, screen_id))


@log_wrapper
def preset_group_node_list_read(device_id, screen_id, group_id):
    """
    获取屏幕的场景组节点枚举
    :param device_id: 设备id
    :param screen_id: 屏幕id
    :param group_id: 场景组id
    :return: 参考接口文档presetGroupNodeList
    """
    return transfer_midware_resp(ctrl.read(FnCode.PRESET_GROUP_NODE_LIST, device_id, screen_id, group_id))


@log_wrapper
def preset_group_node_list_write(device_id, screen_id, group_id, data):
    """
    写屏幕的场景组节点枚举
    :param device_id: 设备id
    :param screen_id: 屏幕id
    :param group_id: 场景组id
    :param data: json
    :return: 参考接口文档presetGroupNodeList
    """
    return transfer_midware_resp(ctrl.write
                                 (FnCode.PRESET_GROUP_NODE_LIST, [data], device_id, screen_id, group_id))


@log_wrapper
def preset_group_node_add_write(device_id, screen_id, group_id, data):
    """
    为场景组中添加场景节点
    :param device_id: 设备Id
    :param screen_id: 屏幕id
    :param group_id: 场景组id
    :param data: 场景数据
    :return: 参考接口文档presetGroupNodeAdd
    """
    return transfer_midware_resp(ctrl.write
                                 (FnCode.PRESET_GROUP_NODE_ADD, [data], device_id, screen_id, group_id))


@log_wrapper
def preset_group_node_delete_write(device_id, screen_id, group_id, data):
    """
    为场景组中添加场景节点
    :param device_id: 设备Id
    :param screen_id: 屏幕id
    :param group_id: 场景组id
    :param data: 场景数据
    :return: 参考接口文档groupNodeDelete
    """
    return transfer_midware_resp(ctrl.write
                                 (FnCode.PRESET_GROUP_NODE_DELETE, [data], device_id, screen_id, group_id))


@log_wrapper
def preset_poll_write(device_id, screen_id, data):
    """
    设置场景轮询
    :param device_id: 设备Id
    :param screen_id: 屏幕id
    :param data: json data
    :return:参考接口文档presetPoll
    """
    return transfer_midware_resp(ctrl.write(FnCode.PRESET_POLL, [data], device_id, screen_id))


@log_wrapper
def preset_poll_read(device_id, screen_id):
    """
    设置场景轮询
    :param device_id: 设备Id
    :param screen_id: 屏幕id
    :return:
    """
    return transfer_midware_resp(ctrl.read(FnCode.PRESET_POLL, device_id, screen_id))


@log_wrapper
def preset_cory_write(device_id, screen_id, data):
    """
    复制场景
    :param device_id: 设备Id
    :param screen_id:  屏幕Id
    :param data:  复制场景参数
    :return:  场景Id
    """
    return transfer_midware_resp(ctrl.write(FnCode.PRESET_COPY, [data], device_id, screen_id))


@log_wrapper
def preset_nontime_create(device_id, screen_id, data):
    """
    复制场景
    :param device_id: 设备Id
    :param screen_id:  屏幕Id
    :param data:  复制场景参数
    :return:  场景Id
    """
    return transfer_midware_resp(ctrl.write(FnCode.PRESET_NONTIME_CREATE, [data], device_id, screen_id))


@log_wrapper
def preset_config_read(device_id):
    """
    读取场景切换特效模式
    :param device_id: 设备Id
    :return: 切换模式
    """

    rs = transfer_midware_resp(ctrl.read(FnCode.PRESET_CONFIG, device_id))
    format_server_data(rs['data'])
    return rs


@log_wrapper
def preset_config_write(device_id, data):
    """
    设置场景切换特效模式
    :param device_id: 设备Id
    :return: 切换模式
    """
    format_client_data(data)
    return transfer_midware_resp(ctrl.write(FnCode.PRESET_CONFIG, [data], device_id))