from H_9U.mao.impl import mvrwindow
from H_9U.util.cache import cacher
from H_9U.models.cachekey import CacheKey, CacheDuration


class MvrWindowApi:

    def read_list(self, device_id, mvr_id):
        """
        读取mvrwindow列表并加入缓存
        :param device_id: 设备id
        :param mvr_id: mvrid
        :return: 列表数据
        """
        key = CacheKey.mvr_window_list(device_id, mvr_id)
        return cacher.MvrWindowCache.try_get_value(key, CacheDuration.Default, mvrwindow.mvr_windows_list_read,
                                                   device_id, mvr_id)

    def read_detail(self, device_id, mvr_id, window_id):
        """
        读取mvrwindow详情并加入缓存
        :param device_id: 设备id
        :param mvr_id: mvrid
        :param window_id: 窗口id
        :return: 窗口详情
        """
        key = CacheKey.mvr_window_detail(device_id, mvr_id, window_id)
        return cacher.MvrWindowCache.try_get_value(key, CacheDuration.Default, mvrwindow.mvr_window_full_detail_read,
                                                   device_id, mvr_id, window_id)

    def write_create(self, device_id, mvr_id, data):
        """
        创建预监窗口
        清除预监窗口列表缓存
        :param device_id: 设备id
        :param mvr_id: 预监id
        :param data: 数据对象
        :return: 结果对象
        """
        rs = mvrwindow.mvr_window_create_write(device_id, mvr_id, data)
        if rs['status'] == 0:
            cacher.MvrWindowCache.clear()
            cacher.DeviceCache.clear()
        return rs

    def write_delete(self, device_id, mvr_id, window_id, data):
        """
        删除预监窗口
        清除预监窗口列表缓存
        清除预监窗口详情缓存
        :param device_id: 设备id
        :param mvr_id: 预监id
        :param window_id: 窗口id
        :param data:
        :return: 结果对象
        """
        rs = mvrwindow.mvr_window_delete_write(device_id, mvr_id, window_id, data)
        if rs['status'] == 0:
            cacher.MvrWindowCache.delete(CacheKey.mvr_window_list(device_id, mvr_id))
            cacher.MvrWindowCache.delete(CacheKey.mvr_window_detail(device_id, mvr_id, window_id))
            cacher.DeviceCache.clear()
        return rs

    def write_general(self, device_id, mvr_id, window_id, data):
        """
        设置预监窗口基本信息
        清除预监窗口列表缓存
        清除预监窗口详情缓存
        :param device_id: 设备id
        :param mvr_id: mvrid
        :param window_id: 窗口id
        :param data: 基本信息
        :return: 结果对象
        """
        rs = mvrwindow.mvr_window_general_write(device_id, mvr_id, window_id, data)
        if rs['status'] == 0:
            cacher.MvrWindowCache.delete(CacheKey.mvr_window_list(device_id, mvr_id))
            cacher.MvrWindowCache.delete(CacheKey.mvr_window_detail(device_id, mvr_id, window_id))
        return rs

    def read_general(self, device_id, mvr_id, window_id):
        """
        读取预监窗口基本信息
        :param device_id: 设备id
        :param mvr_id: mvrid
        :param window_id: 窗口id
        :return: 结果数据
        """
        return mvrwindow.mvr_window_general_read(device_id, mvr_id, window_id)

    def write_umd_enable(self, device_id, mvr_id, window_id, data):
        """
        umd停用启用接口
        清除预监窗口列表缓存
        清除预监窗口详情缓存
        :param device_id: 设备id
        :param mvr_id: mvrid
        :param window_id: 窗口id
        :param data: 数据信息
        :return: 结果对象
        """
        rs = mvrwindow.mvr_window_umd_enable_write(device_id, mvr_id, window_id, data)
        if rs['status'] == 0:
            cacher.MvrWindowCache.delete(CacheKey.mvr_window_list(device_id, mvr_id))
            cacher.MvrWindowCache.delete(CacheKey.mvr_window_detail(device_id, mvr_id, window_id))
        return rs

    def read_umd_enable(self, device_id, mvr_id, window_id):
        """
        读取umd状态
        :param device_id: 设备id
        :param mvr_id: mvrid
        :param window_id: 窗口id
        :return: 结果兑现
        """
        return mvrwindow.mvr_window_umd_enable_read(device_id, mvr_id, window_id)

    def read_umd_color(self, device_id, mvr_id, window_id):
        """
        读取umd颜色
        :param device_id: 设备id
        :param mvr_id: mvrid
        :param window_id: 窗口id
        :return:
        """
        return mvrwindow.mvr_window_umd_color_read(device_id, mvr_id, window_id)

    def write_umd_color(self, device_id, mvr_id, window_id, data):
        """
        设置umd颜色
        清除预监窗口列表缓存
        清除预监窗口详情缓存
        :param device_id: 设备id
        :param mvr_id: mvrid
        :param window_id: 窗口id
        :param data:
        :return:
        """
        rs = mvrwindow.mvr_window_umd_color_write(device_id, mvr_id, window_id, data)
        if rs['status'] == 0:
            cacher.MvrWindowCache.delete(CacheKey.mvr_window_list(device_id, mvr_id))
            cacher.MvrWindowCache.delete(CacheKey.mvr_window_detail(device_id, mvr_id, window_id))
        return rs

    def write_border_width(self, device_id, mvr_id, window_id, data):
        """
        设置预监窗口边框
        清除预监窗口列表缓存
        清除预监窗口详情缓存
        :param device_id: 设备id
        :param mvr_id: mvrid
        :param window_id: 窗口id
        :param data: 边框数据
        :return: 结果对象
        """
        rs = mvrwindow.mvr_window_border_width_write(device_id, mvr_id, window_id, data)
        if rs['status'] == 0:
            cacher.MvrWindowCache.delete(CacheKey.mvr_window_list(device_id, mvr_id))
            cacher.MvrWindowCache.delete(CacheKey.mvr_window_detail(device_id, mvr_id, window_id))
        return rs

    def read_border_width(self, device_id, mvr_id, window_id):
        """
        读取预监窗口边框信息
        :param device_id: 设备id
        :param mvr_id: mvrid
        :param window_id: 窗口id
        :return: 结果对象
        """
        return mvrwindow.mvr_window_border_width_read(device_id, mvr_id, window_id)

    def read_border_color(self, device_id, mvr_id, window_id):
        """
        读取边框颜色
        :param device_id: 设备id
        :param mvr_id: mvrid
        :param window_id: 窗口id
        :return: 结果对象
        """
        return mvrwindow.mvr_window_border_color_read(device_id, mvr_id, window_id)

    def write_border_color(self, device_id, mvr_id, window_id, data):
        """
        设备边框颜色
        清除预监窗口列表缓存
        清除预监窗口详情缓存
        :param device_id: 设备id
        :param mvr_id: mvrid
        :param window_id: 窗口id
        :param data: 颜色对象
        :return: 结果对象
        """
        rs = mvrwindow.mvr_window_border_color_write(device_id, mvr_id, window_id, data)
        if rs['status'] == 0:
            cacher.MvrWindowCache.delete(CacheKey.mvr_window_list(device_id, mvr_id))
            cacher.MvrWindowCache.delete(CacheKey.mvr_window_detail(device_id, mvr_id, window_id))
        return rs

    def write_source(self, device_id, mvr_id, window_id, data):
        """
        预监窗口换源
        清除预监窗口详情缓存
        :param device_id: 设备id
        :param mvr_id: mvrid
        :param window_id: 窗口id
        :param data: 源对象
        :return: 结果对象
        """
        rs = mvrwindow.mvr_window_write_source(device_id, mvr_id, window_id, data)
        if rs['status'] == 0:
            cacher.MvrWindowCache.delete(CacheKey.mvr_window_detail(device_id, mvr_id, window_id))
            cacher.DeviceCache.clear()
        return rs


mvrwindow_api = MvrWindowApi()
