"""
Created on 2021年9月10日
@author: 程声清
返回值统一为 {data:JSON结构体, msg:"", status:0}
"""
from H_9U.mao.device_mao import device_api
from H_9U.mao.impl import device
from H_9U.models.cachekey import CacheKey
from H_9U.models.sysconst import CardCategory
from H_9U.util.cache import cacher


def device_init_status_middle(device_id):
    """
    读取系统初始化状态
    :param device_id 设备号
    :return: 设备初始化状态
    """
    return device_api.device_init_status_read(device_id)


def read_device_language_middle(device_id):
    """
    读取设备语言模式
    :param device_id 设备号
    :return: 设备语言模式
    """
    return device_api.read_device_language(device_id)


def device_read_detail_middle(device_id):
    """
    读取设备详细信息
    :param device_id:设备id
    :return:
    """
    return device_api.read_detail(device_id)


def device_firware_version_read_middle( device_id):
    """
    获取程序版本号
    :param device_id:设备id
    :return:
    """
    return device_api.read_firware_version(device_id)


def device_ipc_mode_read_middle(device_id):
    """
    读取设备IPC mode
    :param device_id: 设备id
    :return: 结果对象
    """
    return device_api.read_ipc_mode(device_id)


def device_detail_middle(device_id):
    """
    读取设备详情
    :param device_id: 设备Id
    :return: 结果对象，参考DeviceDetail
    """
    rs = device_read_detail_middle(device_id)
    return _device_solve_data(rs)
    # if rs['status'] == 0 and rs['data']:
    #     # 网口 1 正常， 0 异常
    #     rs['data']['ethernetStatus'] = 1
    #     # 判断是否二合一卡
    #     for slot in rs['data']['slotList']:
    #         slot['cardCategory'] = CardCategory.get_card_category(
    #             slot['modelId'])
    # return rs


def device_detail_without_cache_middle(device_id):
    """
    读取设备详情
    :param device_id: 设备Id
    :return: 结果对象，参考DeviceDetail
    """
    rs = read_detail_without_cache_middle(device_id)
    return _device_solve_data(rs)
    # if rs['status'] == 0 and rs['data']:
    #     # 网口 1 正常， 0 异常
    #     rs['data']['ethernetStatus'] = 1
    #     # 判断是否二合一卡
    #     for slot in rs['data']['slotList']:
    #         slot['cardCategory'] = CardCategory.get_card_category(
    #             slot['modelId'])
    # return rs


def _device_solve_data(rs):
    """
    处理数据
    :param rs: 结果数据
    :return: 结果对象
    """
    if rs['status'] == 0 and rs['data']:
        # 网口 1 正常， 0 异常
        rs['data']['ethernetStatus'] = 1
        # 判断是否二合一卡
        for slot in rs['data']['slotList']:
            slot['cardCategory'] = CardCategory.get_card_category(
                slot['modelId'])
    return rs


def read_detail_without_cache_middle(device_id):
    """
    读取设备详情
    :param device_id: 设备Id
    :return: 结果对象，参考DeviceDetail
    """
    return device_api.read_detail_without_cache(device_id)

#
def ipc_mode_read_middle(device_id, slot_id):
    """
    读取设备IPC mode
    :param device_id: 设备id
    :return: 结果对象
    """
    return device_api.read_ipc_mode(device_id, slot_id)

def ipc_read_mode_middle(device_id, slot_id):
    """
    读取设备IPC mode
    :param device_id: 设备id
    :param slot_id:slot_id
    :return: 结果对象
    """
    return device_api.ipc_mode_info(device_id, slot_id)


def write_slot_middle(device_id, slot_id, data):
    """
    设置槽位信息
    移除槽位信息缓存
    :param device_id: 设备Id
    :param slot_id: slot id
    :param data: 槽位信息
    :return:  结果对象
    """
    rs = device.device_slot_write(device_id, slot_id, data)
    if rs['status'] == 0:
        key = CacheKey.device_slot(device_id, slot_id)
        cacher.DeviceCache.delete(key)
    return rs


def device_init_status_read_middle(device_id):
    """
    读取设备初始化状态
    :param device_id: 设备id
    :return: 结果对象
    """
    return device_api.init_status_read(device_id)


def device_detail_read_middle(device_id):
    """
      读取设备详细信息
      :param device_id:设备id
      :return: 参考协议文档：0x00 - key: deviceDetail
      """
    rs = device_api.read_detail(device_id)
    # if rs['status'] == 0 and rs['data']:
    #     # 网口 1 正常， 0 异常
    #     rs['data']['ethernetStatus'] = 1
    #
    #     # 判断是否二合一卡
    #     for slot in rs['data']['slotList']:
    #         slot['cardCategory'] = CardCategory.get_card_category(
    #             slot['modelId'])
    # return rs
    return _device_solve_data(rs)


def device_slot_read_middle(device_id, slot_id):
    """
     读取设备槽信息
    :param device_id:设备Id
    :param slot_id: 卡槽Id
    :return: 参考前端接口协议文档：readSlot
    """
    rs = device_api.read_slot(device_id, slot_id)
    if rs['status'] == 0:
        # 设置默认值
        rs['data']['sn'] = ''
        rs['data']['hardwareVersion'] = ''
        rs['data']['mcuVersion'] = ''
        rs['data']['fpgaVersion'] = ''
    return rs
