"""
Created on 2021年9月07日
@author: 程声清
Input业务处理层.
返回值统一为 {data:JSON结构体, msg:"", status:0}
"""
from H_9U.mao.impl import ipcmao, input
from H_9U.mao.input_mao import input_api
from H_9U.middle import open_device_middle
from H_9U.models.cachekey import CacheKey, CacheDuration
from H_9U.models.result import get_result_model, ResInfo
from H_9U.models.sysconst import UploadFileType, CardCategory, CardType, InterfaceType, FunctionType
from H_9U.service import common
from H_9U.util.cache import cacher
from H_9U.util.log import logger


def input_read_all_list_middle(device_id):
    """
    获取输入列表
    param device_id 设备号
    :return:
    """
    input_list_rs = input_read_list_middle(device_id)
    rs = get_result_model()
    if input_list_rs["status"] == 0:
        inputs_list = []
        if input_list_rs['data']['inputs']:
            for item in input_list_rs['data']['inputs']:
                dict_list = {}
                dict_list['name'] = item['name']
                dict_list['inputId'] = item['inputId']
                inputs_list.append(dict_list)
        rs['data']['inputs'] = inputs_list
        rs['data']['deviceId'] = device_id
    else:
        rs = get_result_model(ResInfo.Middle_Data_Err)
    return rs


def crop_create_middle(device_id, input_id, data):
    """
    创建结果参数
    :param: json参数
    :return: 结果对象
    """
    rs = input_api.write_crop_create(device_id, input_id, data)
    if rs["status"] == 0:
        logger.debug("创建CROP-成功! CODE:%i, params:%s" % (rs["status"], data))
    else:
        logger.error("创建CROP-失败! CODE:%i, params:%s" % (rs["status"], data))
    return rs


def input_crop_delete_middle(device_id, input_id, crop_id, params):
    """
    删除crop
    :param device_id: 设备id
    :param input_id: 输入id
    :param crop_id: 截取id
    :param params: json参数
    :return: 结果对象
    """
    rs = input_api.write_crop_delete(device_id, input_id, crop_id, params)
    if rs["status"] == 0:
        logger.debug("删除CROP-成功! CODE:%i, params:%s" % (rs["status"], params))
    else:
        logger.error("删除CROP-失败! CODE:%i, params:%s" % (rs["status"], params))
    return rs


def input_crop_update_middle(device_id, input_id, crop_id, params):
    """
    修改输入截取
    :param params: 参考接口文档updateCrop
    :param device_id: 设备Id
    :param input_id: input id
    :param crop_id: 截取 id
    :return: 结果对象
    """
    rs = input_api.write_crop_update(device_id, input_id, crop_id, params)
    if rs["status"] == 0:
        logger.debug("修改CROP-成功! CODE:%i, params:%s" % (rs["status"], params))
    else:
        logger.error("修改CROP-失败! CODE:%i, params:%s" % (rs["status"], params))
    return rs


def input_ed_id_import_middle(device_id, input_ids):
    """
    批量导入edId
    :param device_id: 设备Id
    :param input_ids: 输入Id列表
    :return: 结果对象
    """
    # st = time.time()  # 返回当前时间的时间戳（1970纪元后经过的浮点秒数）
    up_rs = common.upload_file(UploadFileType.Input_EDID, extract=False)
    # 文件上传成功后还要调用中间件进行设备升级
    if up_rs["bln"] is not True:
        logger.error("导入edId-文件上传-失败!")
        return get_result_model(ResInfo.Upload_File_Fail)
    input_id = 255 if len(input_ids) > 1 else int(input_ids[0])
    path_nm = up_rs["pathNm"]
    lst_data = []
    for x in input_ids:
        lst_data.append({
            "inputId": int(x),
            "deviceId": device_id,
            "file": {
                "fileName": path_nm,
                "fileData": '',
                "hashSum": 0
            }
        })
    rs = input_api.write_edid(device_id, input_id, lst_data)
    if rs['status'] == 0:
        for x in input_ids:
            data = {
                'inputId': int(x),
                'deviceId': device_id,
                'templateOperationType': 1
            }
            input_api.write_timing(device_id, int(x), data)
    return rs


def input_write_timing_middle(device_id, input_id, data):
    """
    设置timing
    :param device_id: 设备id
    :param input_id : 输入id
    :param  data :
    :return: 结果对象
    """
    return input_api.write_timing(device_id, input_id, data)


def input_write_ed_id_middle(device_id, input_id, lst_data):
    """
    设置edId
    移除输入详情缓存
    :param device_id: 设备id
    :param input_id: 输入id
    :param lst_data: edId list对象
    :return: 结果对象
    """
    return input_api.write_edid(device_id, input_id, lst_data)


# def write_timing_middle(device_id, input_list, params):
#     """
#     批量设置
#      :param device_id: 设备id
#     :param input_list: 输入id列表
#     :param params: json 参数
#     :return: 结果对象
#     """
#     data = []
#     # noinspection PyBroadException
#     try:
#         # 处理刷新率
#         # format_client_data(params)
#         # 循环设置
#         partial = False
#         for input_id in input_list:
#             timing = deepcopy(params)
#             timing['inputId'] = input_id
#             rs = input_api.write_timing(device_id, input_id, timing)
#             success = 1
#             if rs["status"] != 0:
#                 logger.debug(
#                     "设置Timing-失败! CODE:%i, params:%s" %
#                     (rs["status"], input_id))
#                 success = 0
#                 # 是否部分成功
#                 partial = True
#             data.append({
#                 'inputId': input_id,
#                 'success': success
#             })
#         if partial:  # 部分成功
#             rs = get_result_model(
#                 ResInfo.Input_Write_Timing_List_Partial_Success)
#             rs['data'] = data
#         else:  # 全部成功
#             rs = get_result_model()
#             rs['data'] = data
#     except Exception:
#         rs = get_result_model(ResInfo.Input_Write_Timing_List_Error)
#     return rs


def input_read_ipc_source_list_middle(device_id, slot_id):
    """
    读取ipc_source列表
    :param device_id: 设备id
    :param slot_id: slot id
    :return: ipc列表
    """
    key = CacheKey.input_ipc_source_list(device_id, slot_id)
    return cacher.InputCache.try_get_value(
        key,
        CacheDuration.Default,
        ipcmao.ipc_source_list,
        device_id,
        slot_id)


def input_ipc_source_detail_middle(device_id, slot_id, source_id):
    """
    读取ipc_source详情
    :param device_id: 设备id
    :param slot_id: slot id
    :param source_id: source_id
    :return: ipc列表
    """
    return input_api.read_ipc_source_detail(device_id, slot_id, source_id)


def input_read_ipc_crop_list_middle(ipc_mode, device_id, slot_id, source_id):
    """
    读取IPC截取列表
    :param ipc_mode: ipc模式
    :param device_id: 设备id
    :param slot_id: slot_id
    :param source_id: 源id
    :return:
    """
    key = CacheKey.input_ipc_crop_list(ipc_mode, device_id, slot_id, source_id)
    return cacher.InputCache.try_get_value(
        key,
        CacheDuration.Default,
        ipcmao.ipc_crop_list,
        device_id,
        slot_id,
        source_id)


def input_ipc_source_list_middle(device_id):
    """
    读取IPC源列表
    :param device_id: 设备id
    :return:
    """
    ipc_cards = _get_ipc_card_list_middle(device_id)
    ipc_list = []
    if ipc_cards:
        for slot_id in ipc_cards:
            rs = ipc_source_detail_list_middle(device_id, slot_id)
            if rs['status'] == 0:
                ipc_list.append(rs['data'])
    rs = get_result_model()
    rs['data'] = {'deviceId': device_id, 'ipcList': ipc_list}
    return rs


def input_ipc_montage_list_middle(device_id):
    """
     读取IPC拼接列表
     :param device_id: 设备id
     :return:
     """
    slots = _get_ipc_card_list_middle(device_id)
    mode_list = []
    for slot_id in slots:
        rs = ipc_montage_detail_middle(device_id, slot_id)
        if rs['status'] == 0 and rs['data'] and rs['data']['sourcePosList']:
            mode_list.append(rs['data'])
    rs = get_result_model()
    rs['data'] = mode_list
    return rs


def ipc_montage_detail_middle(device_id, slot_id):
    """
     读取ipc拼接详情
     :param device_id: 设备id
     :param slot_id: slotId
     :return: 拼接详情
     """
    rs = read_ipc_source_size_pos_middle(device_id, slot_id)
    if rs['status'] == 0 and rs['data']['sourcePosList']:
        ipc_input_id = -1
        is_signal = 0

        for source in rs['data']['sourcePosList']:
            name = ''
            source_detail = read_ipc_source_detail_middle(
                device_id, slot_id, source['ipcSourceId'])
            if source_detail['status'] == 0 and source_detail['data']:
                name = source_detail['data']['name']
                if ipc_input_id == -1:
                    ipc_input_id = source_detail['data']['inputId']
                if is_signal == 0:
                    is_signal = source_detail['data']['iSignal']
            source['ipcSourceName'] = name

        rs['data']['ipcInputId'] = ipc_input_id
        rs['data']['iSignal'] = is_signal
        crop_rs = ipc_crop_list_middle(1, device_id, slot_id, 0)
        crops = crop_rs['data']['crops'] if rs['status'] == 0 else []
        rs['data']['crops'] = crops
    return rs


def read_ipc_source_size_pos_middle(device_id, slot_id):
    """
    读取ipc源位置
    :param device_id:  设备id
    :param slot_id: slot_id
    :return: 结果对象
    """
    def _read_ipc_source_size_pos_middle():
        rs = ipcmao.ipc_source_size_pos_read(device_id, slot_id)
        return rs

    key = CacheKey.input_ipc_montage_detail(device_id, slot_id)
    return cacher.InputCache.try_get_value(
        key, CacheDuration.Default, _read_ipc_source_size_pos_middle)


def ipc_source_detail_list_middle(device_id, slot_id):
    """
    读取ipc_source列表
    :param device_id: 设备id
    :param slot_id: slot id
    :return: ipc列表
    """
    rs = input_read_ipc_source_list_middle(device_id, slot_id)
    if rs['status'] == 0:
        source_list = []
        for source in rs['data']['ipcSourceList']:
            source_id = source['ipcSourceId']
            source_info = ipc_source_detail_middle(
                0, device_id, slot_id, source_id)
            if source_info['status'] == 0 and source_info['data']:
                source_list.append(source_info['data'])

        rs['data'] = {'slotId': slot_id, 'ipcSourceList': source_list}

    return rs


def ipc_source_detail_middle(ipc_mode, device_id, slot_id, source_id):
    """
    获取所有ipc卡输入源
    :param ipc_mode: ipc_mode
    :param device_id: 设备Id
    :param slot_id: 槽位Id
    :param source_id: 源Id
    :return: upc输入源id数组
    """
    rs = input_ipc_source_detail_middle(device_id, slot_id, source_id)
    if rs['status'] == 0 and rs['data']:
        rs['data']['ipcInputId'] = rs['data']['inputId']
        crop_rs = ipc_crop_list_middle(ipc_mode, device_id, slot_id, source_id)
        crops = crop_rs['data']['crops'] if crop_rs['status'] == 0 else []
        rs['data']['crops'] = crops
    return rs


def _get_ipc_card_list_middle(device_id):
    """
    获取所有ipc卡输入源
    :param device_id: 设备Id
    :return: upc输入源id数组
    """
    rs = ipc_card_list_middle(device_id)
    ipc_list = []
    if rs['status'] == 0:
        ipc_list = rs['data']
    return ipc_list


def ipc_card_list_middle(device_id):
    """
    获取ipc卡列表
    :param device_id:
    :return: ipc卡列表
    """
    rs = open_device_middle.device_detail_middle(device_id)
    if rs['status'] == 0:
        if rs['data']:
            ipc_list = [x['slotId'] for x in rs['data']['slotList']
                        if x['cardCategory'] == CardCategory.IPCCard]
            rs['data'] = ipc_list
        else:
            rs['data'] = []

    return rs


def ipc_crop_list_middle(ipc_mode, device_id, slot_id, source_id):
    """
    读取IPC截取列表
    :param ipc_mode: ipc_mode
    :param device_id: 设备id
    :param slot_id: slot_id
    :param source_id: 源id
    :return:
    """
    rs = input_read_ipc_crop_list_middle(
        ipc_mode, device_id, slot_id, source_id)
    if rs['status'] == 0 and rs['data']:
        crops = []
        for c in rs['data']['crops']:
            crop_id = c['cropId']
            crop = ipc_crop_detail_middle(
                ipc_mode, device_id, slot_id, source_id, crop_id)
            if crop['status'] == 0 and crop['data']:
                crops.append(crop['data'])
        rs['data']['crops'] = crops
    return rs


def ipc_crop_detail_middle(ipc_mode, device_id, slot_id, source_id, crop_id):
    """
    读取IPC截取详情
    :param ipc_mode: ipc_mode
    :param device_id: 设备id
    :param slot_id: slot_id
    :param source_id: 源id
    :param crop_id: 截取id
    :return:
    """
    return input_api.read_ipc_crop_detail(
        ipc_mode, device_id, slot_id, source_id, crop_id)


def read_ipc_source_detail_middle(device_id, slot_id, source_id):
    """
    读取ipc列表
    :param device_id: 设备id
    :param slot_id: slot id
    :param source_id: source id
    :return: ipc列表
    """
    key = CacheKey.input_ipc_source_detail(device_id, slot_id, source_id)
    return cacher.InputCache.try_get_value(
        key,
        CacheDuration.Default,
        ipcmao.ipc_source_detail_read,
        device_id,
        slot_id,
        source_id)


def input_read_list_middle(device_id):
    """
    读取列表
    :param device_id: 设备Id
    :return: 结果对象
    """
    # 读取全部输入
    rs = input_api.read_list(device_id)
    return rs


def input_read_all_middle(device_id):
    """
    读取列表
    :param device_id: 设备Id
    :return: 结果对象
    """
    # 读取全部输入
    rs = input_read_list_middle(device_id)
    device_rs = open_device_middle.device_detail_middle(device_id)
    used_rs = get_used_inputs_dict_middle(device_id)
    if rs["status"] == 0 and device_rs['status'] == 0 and used_rs['status'] == 0:
        input_list = []
        input_dict = used_rs['data']
        if rs['data']['inputs']:
            input_list = []
            # 循环输入信息
            for item in [x for x in rs['data']['inputs']]:
                # 获取输入详情
                try:
                    detail = read_detail_middle(device_id, item['inputId'])
                    if detail['status'] == 0:
                        detail['data']['iSignal'] = 1 if detail['data']['resolution']['refresh'] > 0 else 0
                        detail['data']['isUsed'] = 1 if detail['data']['slotId'] in input_dict and detail[
                            'data']['interfaceId'] in input_dict[detail['data']['slotId']] else 0
                        detail['data']['isEDIDSetting'] = InterfaceType.allow_edid_setting(
                            detail['data']['interfaceType'])
                        detail['data']['modelId'] = [x for x in device_rs['data']['slotList']
                                                     if x['slotId'] == detail['data']['slotId']][0]['modelId']
                        input_list.append(detail['data'])
                except Exception as e:
                    logger.error("输入源列表异常：" + str(e))
        rs['data'] = input_list

        k4_cards = [x for x in device_rs['data']['slotList']
                    if x['cardCategory'] == CardCategory.K4_HDMI_DP_Card]
        k4_card_slots = [s['slotId'] for s in k4_cards]
        # 含有4k卡
        if k4_cards:
            for i in input_list:
                try:
                    if i['online'] == 1 and i['slotId'] in k4_card_slots:
                        slot = [
                            x for x in k4_cards if x['slotId'] == i['slotId']][0]
                        functions = [x for x in slot['interfaces']
                                     if x['functionType'] != FunctionType.Disable]
                        func_type = functions[0]['functionType'] if functions else FunctionType.Disable
                        if func_type == FunctionType.HDMI20:
                            i['interfaceType'] = InterfaceType.HDMI20
                        elif func_type == FunctionType.DP12:
                            i['interfaceType'] = InterfaceType.DP12
                        i['isUsed'] = 1 if i['slotId'] in input_dict else 0
                except Exception as e:
                    logger.error("4k输入源列表异常：" + str(e))
    else:
        rs = get_result_model(ResInfo.Middle_Data_Err)

    return rs


def get_used_inputs_dict_middle(device_id):
    """
    读取被使用的输入源dict
    :param device_id: dictId
    :return: {slotId:[interfaceId1, interfaceId2, ...]}
    """
    rs = open_device_middle.device_detail_without_cache_middle(device_id)
    if rs['status'] == 0:
        used_dict = {}
        input_slots = [x for x in rs['data']['slotList']
                       if x['cardType'] == CardType.In and x['interfaces']]
        for slot in input_slots:
            for interface in slot['interfaces']:
                if interface['isUsed'] == 1:
                    if slot['slotId'] in used_dict:
                        used_dict[slot['slotId']].append(
                            interface['interfaceId'])
                    else:
                        used_dict[slot['slotId']] = [interface['interfaceId']]
        rs['data'] = used_dict

    return rs


def read_detail_middle(device_id, input_id):
    """
    读取详细信息
    :param device_id: 设备号
    :param input_id: 输入号
    :return: 见文档readDetail
    """
    rs = input_api.read_detail(device_id, input_id)
    if rs['status'] == 0:
        # 补充截取信息
        crops = []
        if rs['data']['online'] == 1:
            crop_rs = read_crop_list_middle(device_id, input_id)
            if crop_rs['status'] == 0 and crop_rs['data']:
                crops = crop_rs['data']['crops']
        rs['data']['crops'] = crops

    return rs


def read_input_detail_middle(device_id, input_id):
    """
    读取详细信息
    :param device_id: 设备号
    :param input_id: 输入号
    :return: 见文档readDetail
    """
    return input_api.read_detail(device_id, input_id)


def read_crop_lists_middle(device_id, input_id):
    """
    读取输入crop信息并加入缓存
    :param device_id: 设备id
    :param input_id: 输入id
    :return: 结果数据
    """
    return input_api.read_crop_list(device_id, input_id)


def read_crop_list_middle(device_id, input_id):
    """
    读取输入crop信息并加入缓存
    :param device_id: 设备id
    :param input_id: 输入id
    :return: 结果数据
    """
    key = CacheKey.input_crop_list(device_id, input_id)
    return cacher.InputCache.try_get_value(
        key,
        CacheDuration.Default,
        input.input_crop_list_read,
        device_id,
        input_id)


def read_group_list_middle(device_id):
    """
    读取输入分组列表
    :param device_id: 设备Id
    :return: 结果对象
    """
    return input_api.read_group_list(device_id)


def write_group_create_middle(device_id, data):
    """
    创建输入分组
    :param device_id: 设备Id
    :param data
    :return: 结果对象
    """
    return input_api.write_group_create(device_id, data)


def input_group_detail_middle(device_id, group_id):
    """
     输入分组详细信息
    :param device_id: 设备Id
    :param group_id ：分组id
    :return: 结果对象
    """
    return input_api.read_group_node_items(device_id, group_id)


def input_group_list_update_middle(device_id, data):
    """
     输入分组节点枚举
     :param device_id: 设备Id
     :param data: 组列表信息
     :return: 结果对象，见文档
     """
    return input_api.write_group_update(device_id, data)


def input_group_node_update_middle(device_id, group_id, data):
    """
    输入源分组更输入源全部数据
    :param device_id: 设备id
    :param group_id: 组Id
    :param data: 输入源列表
    :return: 结果对象
    """
    return input_api.write_group_node_items_update(device_id, group_id, data)


def input_write_group_delete_middle(device_id, group_id, data):
    """
    删除输入分组
    :param device_id: 设备Id
    :param group_id: 组Id
    :param data: 分组数据
    :return: 结果对象
    """
    return input_api.write_group_delete(device_id, group_id, data)


def input_write_group_node_delete_middle(device_id, group_id, input_id, data):
    """
    组内删除元素
    :param device_id: 设备Id
    :param group_id:  组Id
    :param input_id:  输入Id
    :param data:  输入源信息
    :return: 结果对象
    """
    return input_api.write_group_node_item_delete(
        device_id, group_id, input_id, data)


def input_read_ipc_crop_detail_middle(
        ipc_mode,
        device_id,
        slot_id,
        source_id,
        crop_id):
    """
    读取IPC截取详情
    :param ipc_mode: ipc模式
    :param device_id: 设备id
    :param slot_id: slot_id
    :param source_id: 源id
    :param crop_id: 截取id
    :return:
    """
    return input_api.read_ipc_crop_detail(
        ipc_mode, device_id, slot_id, source_id, crop_id)


def input_list_middle(device_id):
    """
    读取输入列表并加入缓存
    :param device_id: 设备id
    :return: 输入列表
    """
    return input_api.read_list(device_id)


def input_rename_middle(device_id, input_id, data):
    """
    设置基本信息
    :param : JSON对象参数
    :param device_id: 设备Id
    :param input_id:  输入Id
    :param data: 数据
    :return: 结果对象
    """
    return input_api.write_general(device_id, input_id, data)