"""
Created on 2019年8月28日
@author: 刘益宗
缓存key模块

/-- device_ 设备模块缓存
    /-- device_detail: 读取设备详情时加入缓存
        /-- deviceGeneralwirte后清除缓存
    /-- device_slot: 读取slot详情时加入缓存
        /-- deviceSlotWrite后清除缓存
    /-- device_version: 读取设备版本信息时加入缓存

/-- input_ 数据模块缓存
    /-- inputList: 读取输入列表加入缓存
        /-- inputGeneralWrite后清除缓存
    /-- inputDetail: 读取输入详情加入缓存
        /-- inputGeneralWrite后清除缓存
        /-- inputTimingWrite后清除缓存
        /-- inputEDIDWrite后清除缓存
        /-- inputOSDWrite后清除缓存
    /-- inputCropList: 读取输入截取列表后加入缓存
        /-- inputCropCreate后清除缓存
        /-- inputCropDelete后清除缓存
        /-- inputCropUpdate后清除缓存

/-- layer_ 图层模块缓存
    /-- layerList: 读取屏幕图层列表加入缓存
        /-- layerCreate后清除缓存
        /-- layerDelete后清除缓存
        /-- layerGeneralWrite后清除缓存
    /-- layerDetail: 读取屏幕图层详情加入缓存
        /-- layerDelete后清除缓存
        /-- layerGeneralWrite后清除缓存
        /-- layerWindowWrite后清除缓存
        /-- layerSourceWrite后清除缓存
    /-- layerZorderWrite： 清空当前屏幕所有缓存

/-- mvrWindow_ 图层模块缓存
    /-- mvrWindowList: 读取mvrWindow列表加入缓存
        /-- mvrWindowCreate 后清除缓存
        /-- mvrWindowGeneralWrite 后清除缓存
        /-- mvrWindowUMDGeneralWrite 后清除缓存
        /-- mvrWindowUMDColorGeneralWrite 后清除缓存
        /-- mvrWindowBorderWidthWrite 后清除缓存
        /-- mvrWindowBorderColorWrite 后清除缓存
    /-- mvrWindowDetail: 读取mvrWindow详情后加入缓存
        /-- mvrWindowGeneralWrite 后清除缓存
        /-- mvrWindowUMDGeneralWrite 后清除缓存
        /-- mvrWindowUMDColorGeneralWrite 后清除缓存
        /-- mvrWindowBorderWidthWrite 后清除缓存
        /-- mvrWindowBorderColorWrite 后清除缓存
        -- mvrWindowDelete 后清除缓存

/-- output_ 图层模块缓存
    /-- outputList: 读取输出列表加入缓存
        /-- outputGeneralWrite后清除缓存
    /-- outputDetail: 读取输出详情加入缓存
        /-- outputGeneralWrite后清除缓存
        /-- outputTestPatternWrite后清除缓存
        /-- outputCropWrite后清除缓存
        /-- outputTimingWrite后清除缓存
        /-- outputEDIDWrite后清除缓存
        /-- outputImageQualityWrite后清除缓存
        /-- outputGammaWrite后清除缓存
    /-- outputTimingWrite
        删除输出详情
        删除全部屏幕缓存
        删除设备详情缓存

/-- preset_ 图层模块缓存
    /-- presetList: 读取场景列表加入缓存
        /-- presetCreateWrite后清除缓存
        /-- presetDeleteWrite后清除缓存
        /-- presetGeneralWrite后清除缓存
    /-- presetDetail: 读取场景详情加入缓存
        /-- presetGeneralWrite后清除缓存
    /-- presetGroupList: 读取场景分组列表后加入缓存
        /-- presetGroupCreateWrite后清除缓存
        /-- presetGroupDeleteWrite后清除缓存
            /-- 清除presetGroupNodeList缓存
        /-- presetGroupUpdateWrite后清除缓存
            /-- 清除presetGroupNodeList缓存
    /-- presetGroupNodeList: 读取场景分组节点列表后加入缓存
        /-- presetGroupNodeListWrite 后清除缓存
        /-- presetGroupNodeAddWrite 后清除缓存
        /-- presetGroupNodeDeleteWrite 后清除缓存

/-- screen_ 图层模块缓存
    /-- screenList: 读取屏幕列表加入缓存
        /-- screenCreateWrite后清除缓存
        /-- screenDeleteWrite后清除缓存
        /-- screenOutputModeWrite后清除缓存
        /-- screenGeneralWrite后清除缓存
    /-- screenDetail: 读取屏幕详情加入缓存
        /-- screenGeneralWrite后清除缓存
        /-- screenMoveInterfaceWrite后清除缓存
        /-- screenAddOutputWrite后清除缓存
            /-- 清空设备详情缓存（isUsed）
        /-- screenRemoveOutputWrite后清除缓存
            /-- 清空设备详情缓存（isUsed）
        /-- screenFtbWrite后清除缓存
        /-- screenFreezeWrite后清除缓存
        /-- screenBkgWrite后清除缓存
        /-- screenOSDWrite后清除缓存
    /-- Screen_ImageQuality/Gamma/TestPattren_Write:
        /-- 清空所有输出缓存
    /-- ScreenCreate 清空设备详情缓存（isUsed）
    /-- ScreenUpdate（updata, addoutput, removeoutput）
        删除设备详情缓存
        删除屏幕详情缓存
        删除屏幕图层列表缓存
        删除屏幕图层详情缓存
    /-- 删除屏幕
        删除屏幕图层列表缓存
        删除屏幕图层详情缓存
        删除屏幕列表缓存
        删除屏幕详情缓存

/-- 数据推送：
    /-- 推送机箱状态
        /-- 清空设备详情缓存
    /-- 推送Slot信息
            /-- 预监卡
                /-- 清除所有预监卡缓存
            /-- 输入卡
                /-- 清除所有输入缓存
                /-- 清除所有屏幕缓存
            /-- 输出卡
                /-- 清除所有输出缓存
                /-- 清除所有屏幕缓存
        /-- 清除设备详情缓存
        /-- 清除slot缓存
        /-- 清除设备版本信息缓存

"""


class CacheDuration:

    Default = 60
    Long = 600


class CacheKeyModel:
    """
    cache key
    """
    # 各模块前缀
    Device_Prefix = 'Device_'
    Screen_Prefix = 'Screen_'
    Input_Prefix = 'Input_'
    Layer_Prefix = 'Layer_'
    MVR_Window_Prefix = 'MVR_Window_'
    Output_Prefix = 'Output_'
    Preset_Prefix = 'Preset_'
    BKG_Prefix = 'BKG_'
    User_Prefix = 'User_'
    IPC_Prefix = 'IPC_'
    Security_Prefix = 'Security_'
    Role_Prefix = 'Role_'

    # device
    def device_detail(self, device_id):
        return self.Device_Prefix + 'D_{}_Detail'.format(device_id)

    def device_slot(self, device_id, slot_id):
        return self.Device_Prefix + 'D_{}_Slot_{}'.format(device_id, slot_id)

    def device_version(self, device_id):
        return self.Device_Prefix + 'D_{}_Version'.format(device_id)

    def device_hdr_support(self, device_id):
        # hdr support key
        return self.Device_Prefix + 'D_{}_HDR_Support'.format(device_id)

    def device_is_safe(self, device_id):
        return self.Device_Prefix + 'D_{}_is_safe'.format(device_id)

    # input
    def input_detail(self, device_id, input_id):
        return self.Input_Prefix + 'D_{}_Detail_{}'.format(device_id, input_id)

    def input_list(self, device_id):
        return self.Input_Prefix + 'D_{}_List'.format(device_id)

    def input_crop_list(self, device_id, input_id):
        return self.Input_Prefix + 'D_{}_Crop_List_{}'.format(device_id, input_id)

    def ipc_source_channel_list(self, device_id, source_id):
        return self.IPC_Prefix + 'D_{}_S_{}_Channel_List'.format(device_id, source_id)

    def ipc_source_channel_detail_list(self, device_id, source_id):
        return self.IPC_Prefix + 'D_{}_S_{}_Channel_Detail_List'.format(device_id, source_id)

    def ipc_channel_detail(self, device_id, source_id, channel_id):
        return self.IPC_Prefix + 'D_{}_S_{}_C_{}_Detail'.format(device_id, source_id, channel_id)
    # 输入分组缓存
    def input_group_list(self, device_id):
        return self.Input_Prefix + 'D_{}_Group_List'.format(device_id)

    def input_group_node_list(self, device_id, group_id):
        return self.Input_Prefix + 'D_{}_Group_Node_{}_List'.format(device_id, group_id)

    def input_ipc_source_list(self, device_id, slot_id):
        return self.Input_Prefix + 'D_{}_{}_IPC_Source_List'.format(device_id, slot_id)

    def input_ipc_source_detail(self, device_id, source_id):
        return self.Input_Prefix + 'D_{}_IPC_Source_Detail_{}'.format(device_id, source_id)

    def input_ipc_crop_list(self, device_id, source_id):
        return self.Input_Prefix + 'M_D_{}_{}_IPC_Crop_List'.format(device_id, source_id)

    def input_ipc_crop_detail(self, device_id, source_id, crop_id):
        return self.Input_Prefix + 'M_D_{}_{}_IPC_Crop_Detail_{}'.format(device_id, source_id, crop_id)

    def input_ipc_group_node_list(self, device_id, group_id):
        return self.Input_Prefix + 'M_D_{}_IPC_Group_node_list_{}'.format(device_id, group_id)

    def input_ipc_group_list(self, device_id):
        return self.Input_Prefix + 'M_D_{}_IPC_Group_list'.format(device_id)
    # layer
    def layer_detail(self, device_id, screen_id, layer_id):
        return self.Layer_Prefix + 'D_{}_S_{}_Detail_{}'.format(device_id, screen_id, layer_id)

    def layer_screen(self, device_id, screen_id):
        return self.Layer_Prefix + 'D_{}_S_{}_'.format(device_id, screen_id)

    def layer_list(self, device_id, screen_id):
        return self.Layer_Prefix + 'D_{}_S_{}_List'.format(device_id, screen_id)

    # MVR Widow
    def mvr_window_list(self, device_id, mvr_id):
        return self.MVR_Window_Prefix + 'D_{}_M_{}_List'.format(device_id, mvr_id)

    def mvr_window_detail(self, device_id, mvr_id, window_id):
        return self.MVR_Window_Prefix + 'D_{}_M_{}_Detail_{}'.format(device_id, mvr_id, window_id)

    # Output
    def output_detail(self, device_id, output_id):
        return self.Output_Prefix + 'D_{}_Detail_{}'.format(device_id, output_id)

    def output_list(self, device_id):
        return self.Output_Prefix + 'D_{}_List'.format(device_id)

    # Preset
    def preset_detail(self, device_id, screen_id, preset_id):
        return self.Preset_Prefix + 'D_{}_S_{}_Detail_{}'.format(device_id, screen_id, preset_id)

    def preset_list(self, device_id, screen_id):
        return self.Preset_Prefix + 'D_{}_S_{}_List'.format(device_id, screen_id)

    def preset_group_list(self, device_id, screen_id):
        return self.Preset_Prefix + 'D_{}_S_{}_Group_List'.format(device_id, screen_id)

    def preset_group_node_list(self, device_id, screen_id, group_id):
        return self.Preset_Prefix + 'D_{}_S_{}_Group_Node_List_{}'.format(device_id, screen_id, group_id)

    def preset_screen(self, device_id, screen_id):
        return self.Preset_Prefix + 'D_{}_S_{}_'.format(device_id, screen_id)

    # Screen
    def screen_detail(self, device_id, screen_id):
        return self.Screen_Prefix + 'D_{}_S_{}_Detail'.format(device_id, screen_id)

    def screen_list(self, device_id):
        return self.Screen_Prefix + 'D_{}_List'.format(device_id)

    def screen_freezed_outputs(self, device_id):
        return self.Screen_Prefix + 'D_{}_Freeze'.format(device_id)

    #  bkg
    def bkg_list(self, device_id):
        return self.BKG_Prefix + 'D_{}_List'.format(device_id)

    def bkg_detail(self, device_id, bkg_id):
        return self.BKG_Prefix + 'D_{}_{}_Detail'.format(device_id, bkg_id)

    #  bkg
    def user_list(self):
        return self.User_Prefix + 'List'

    def func_list(self):
        return self.User_Prefix + 'Function_List'

    def user_detail(self, user_id):
        return self.User_Prefix + '{}_User_Detail'.format(user_id)

    def user_permission(self, user_id):
        return self.User_Prefix + '{}_Permission'.format(user_id)

    def user_func(self, user_id):
        return self.User_Prefix + '{}_User_Func'.format(user_id)

    def user_func_detail(self, user_id):
        return self.User_Prefix + '{}_Func_Detail'.format(user_id)

    def security_config_all(self, device_id):
        return self.Security_Prefix +'{}_All'.format(device_id)

    def security_config_detail(self, key):
        return self.Security_Prefix +'{}_Config'.format(key)

    def user_permissions(self, user_id):
        return self.User_Prefix + '{}_permission'.format(user_id)

    def role_func(self, role_id):
        return self.Role_Prefix + '{}_Role_Func'.format(role_id)

    def role_detail(self, role_id):
        return self.Role_Prefix + '{}_Role_Detail'.format(role_id)

    def role_menu_func(self, role_id):
        return self.Role_Prefix + '{}_Menu_Func'.format(role_id)

    def role_data_func(self, role_id):
        return self.Role_Prefix + '{}_Data_Func'.format(role_id)

    def role_menu_detail(self, role_id):
        return self.Role_Prefix + '{}_menu_Detail'.format(role_id)

    def role_screen_detail(self, role_id):
        return self.Role_Prefix + '{}_screen_Detail'.format(role_id)

    def role_input_detail(self, role_id):
        return self.Role_Prefix + '{}_input_Detail'.format(role_id)

    def role_output_detail(self, role_id):
        return self.Role_Prefix + '{}_output_Detail'.format(role_id)


CacheKey = CacheKeyModel()
