class ExecTimes:
    def __init__(self):
        pass

    UltraShort = 2
    Shot = 5
    Mid = 8
    MiddleLength = 10
    MidLong = 15
    Long = 300
    SpecialLength = 6000


class FnCode(object):

    def __init__(self, ctrl):
        pass

    # 设备模块
    DEVICE_DETAIL = 0x0100
    DEVICE_GENERAL = 0x0101
    DEVICE_SLOT = 0x0102
    DEVICE_INTERFACE = 0x0103
    DEVICE_POWER = 0x0104
    DEVICE_GENLOCK = 0x0105
    DEVICE_SLOTFUNCTION = 0x0106
    DEVICE_IP = 0x0107
    DEVICE_COM = 0x0108
    DEVICE_SAVE = 0x0109
    DEVICE_SHUTDOWN = 0x010A
    DEVICE_RESTOREFACTORY = 0x010B
    DEVICE_FIRWAREVERSION = 0x010C
    DEVICE_UPGRADE = 0x010D
    DEVICE_UPGRADESTS = 0x010E
    DEVICE_SELF_CHECK = 0x0110
    DEVICE_SELF_CHECK_STS = 0x0111
    DEVICE_NOMARK_MODE = 0x0112
    DEVICE_EFFECTIVE_TIME = 0x0113
    DEVICE_HDR_SUPPORT = 0x0114
    DEVICE_LANGUAGE = 0x0115
    DEVICE_LOCAL_TIME = 0x0116
    DEVICE_IPC_OUT_MODE = 0x0117
    DEVICE_INIT_STATUS = 0x0118
    DEVICE_HEARTBEAT = 0x0120
    DEVICE_EXPORTLOG = 0x0130
    DEVICE_GUIDE_DATA = 0x0131
    DEVICE_DYNAMIC_RESOURCES = 0x0132
    DEVICE_WORK_MODE = 0x0133
    DEVICE_TYPE = 0x0135
    DEVICE_BG_COLOR = 0x0139
    DEVICE_FONT_LIST = 0x013A
    DEVICE_FONT_CREATE = 0x013B
    DEVICE_FONT_DELETE = 0x013C
    DEVICE_CENTRAL_CMD_LIST = 0X013D
    DEVICE_CENTRAL_CMD_FULL_DETAIL = 0X013E
    DEVICE_CENTRAL_CMD_CREATE = 0X013F
    DEVICE_CENTRAL_CMD_MODIFY = 0X0140
    DEVICE_CENTRAL_CMD_DELETE = 0X0141
    DEVICE_CENTRAL_CMD_APPLY = 0X0142
    DEVICE_LCD_ENABLE = 0X0143
    DEVICE_INPUT_BACKUP_SWITCH = 0x0146 # 输入源备份开启/关闭
    DEVICE_INPUT_BACKUP_UPDATE = 0x0147
    DEVICE_INPUT_BACKUP_DELETE = 0x0148
    DEVICE_BRIGHT_MODE_SWITCH = 0x0149  # 亮度调节模式选择 普通/特殊
    DEVICE_AUDIO_CARD_MODE = 0x0150
    DEVICE_AUDIO_INTERFACE_DELAY_TIME = 0x0151
    DEVICE_AUDIO_CARD_DETAIL = 0x0152
    DEVICE_AUDIO_CARD_LIST = 0x0153
    DEVICE_FIBER_CARD_DETAIL = 0x0154


    # 输入模块
    INPUT_LIST = 0x0200
    INPUT_FULL_DETAIL = 0x0201
    INPUT_GENERAL = 0x0202
    INPUT_TIMING = 0x0203
    INPUT_EDID = 0x0204
    INPUT_OSD = 0x0205
    INPUT_CROP_LIST = 0x0206
    INPUT_CROP_CREATE = 0x0207
    INPUT_CROP_DELETE = 0x0208
    INPUT_CROP_GENERAL = 0x0209
    INPUT_GROUP_LIST_READ = 0x020A
    INPUT_GROUP_CREATE = 0x020B
    INPUT_GROUP_UPDATE = 0x020C
    INPUT_GROUP_DELETE = 0x020D
    INPUT_GROUP_NODE_READ = 0x020E
    INPUT_GROUP_NODE_UPDATE = 0x020F
    INPUT_GROUP_NODE_ADD = 0x0210
    INPUT_GROUP_NODE_DELETE = 0x0211
    INPUT_REGULATE = 0x0212
    INPUT_REVERSE_CONTROL = 0x0213
    INPUT_MOSAIC_MONTAGELIST = 0x0214

    # 输出模块
    OUTPUT_LIST = 0x0300
    OUTPUT_FULL_DETAIL = 0x0301
    OUTPUT_GENERAL = 0x0302
    OUTPUT_TEST_PATTERN = 0x0303
    OUTPUT_CROP = 0x0304
    OUTPUT_TIMING = 0x0305
    OUTPUT_IMAGEQUALITY = 0x0306
    OUTPUT_GAMMA = 0x0307
    OUTPUT_MATCHRES = 0x0308
    OUTPUT_FIXEDPOSITION = 0x0309
    OUTPUT_EDID = 0x030A
    OUTPUT_TIMING_FREE_MAPPING = 0x030B

    # 屏幕模块
    SCREEN_LIST = 0x0400
    SCREEN_FULLDETAIL = 0x0401
    SCREEN_CREATE = 0x0402
    SCREEN_DELETE = 0x0403
    SCREEN_GENERAL = 0x0404
    SCREEN_OUTMODE = 0x0405
    SCREEN_MOVEINTERFACE = 0x0406
    SCREEN_ADDOUTPUT = 0x0407
    SCREEN_REMOVEOUTPUT = 0x0408
    SCREEN_FTB = 0x0409
    SCREEN_FREEZE = 0x040A
    SCREEN_BKG = 0x040B
    SCREEN_OSD = 0x040C
    SCREEN_GAMMA = 0x040D
    SCREEN_IMAGE_QUALITY = 0x040E
    SCREEN_TEST_PATTERN = 0x040F
    SCREEN_BRIGHTNESS = 0x0410
    SCREEN_CLEAR_LAYERS = 0x0411
    SCREEN_NOTIME_PLAY = 0x0412
    SCREEN_NONTIME_FULL_DETAIL = 0x0413
    SCREEN_HDR = 0x0414
    SCREEN_3D = 0x0415
    SCREEN_BRIGHTNESS_SAVE = 0x0417
    SCREEN_GENLOCK_PHASE_OFFSET = 0x0418
    SCREEN_LAYER_AUTO_PLAY = 0x0419
    SCREEN_AUDIO_ATTRIBUTE = 0x0422 # 设置屏幕的音频属性
    SCREEN_AUTO_BRIGHT_ADJ = 0x0425
    SCREEN_TEMPLATE_LIST = 0x0427
    SCREEN_TEMPLATE_ADD = 0x0428
    SCREEN_TEMPLATE_DELETE = 0x0429
    SCREEN_VOLUME = 0x041C

    # 图层模块
    LAYER_LIST = 0x0500
    LAYER_FULLDETAIL = 0x0501
    LAYER_CREATE = 0x0502
    LAYER_DELETE = 0x0503
    LAYER_GENERAL = 0x0504
    LAYER_LAYOUTWINDOW = 0x0505
    LAYER_SOURCE = 0x0506
    LAYER_Z_ORDER_LIST = 0x0507
    LAYER_SET_Z_ORDER = 0x0508
    LAYER_FREEZE = 0x0509
    LAYER_LOCK = 0x050A
    LAYER_FULL_DETAIL_LIST = 0x0510
    LAYER_AUDIO_STATUS = 0x0511  # 设置图层的音频状态

    # 场景模块
    PRESET_LIST = 0x0600
    PRESET_FULL_DETAIL = 0x0601
    PRESET_CREATE = 0x0602
    PRESET_DELETE = 0x0603
    PRESET_GENERAL = 0x0604
    PRESET_PLAY = 0x0605
    PRESET_GROUP_LIST = 0x0606
    PRESET_GROUP_CREATE = 0x0607
    PRESET_GROUP_DELETE = 0x0608
    PRESET_GROUP_NODE_LIST = 0x0609
    PRESET_GROUP_NODE_ADD = 0x060A
    PRESET_GROUP_NODE_DELETE = 0x060B
    PRESET_POLL = 0x060C
    PRESET_COPY = 0x060D
    PRESET_GROUP_UPDATE = 0x060E
    PRESET_NONTIME_CREATE = 0x060F
    PRESET_CONFIG = 0x0610

    # 预监模块
    MVR_LIST = 0X0700
    MVR_FULL_DETAIL = 0X0701
    MVR_ENABLE = 0X0702
    MVR_GENERAL = 0X0703
    MVR_BACKGROUND_COLOR = 0X0704

    MVRWINDOW_LIST = 0X0800
    MVRWINDOW_FULL_DETAIL = 0X0801
    MVRWINDOW_CREATE = 0X0802
    MVRWINDOW_DELETE = 0X0803
    MVRWINDOW_GENERAL = 0X0804
    MVRWINDOW_BORDER_WIDTH = 0X0805
    MVRWINDOW_BORDER_CORLOR = 0X0806
    MVRWINDOW_UMD_ENABLE = 0X0807
    MVRWINDOW_UMD_COLOR = 0X0808
    MVRWINDOW_SOURCE = 0X0809

    # BKG模块
    BKG_LIST = 0x0900
    BKG_FULL_DETAIL = 0x0901
    BKG_CREATE = 0x0902
    BKG_DELETE = 0x0903
    BKG_GENERAL = 0x0904

    # IPC模块
    IPC_SOURCE_LIST = 0x0A00
    IPC_CAMERA_LIST = 0x0A01
    IPC_CHANNEL_LIST = 0x0A02
    IPC_SOURCE_CHANNEL_DETAIL = 0x0A03
    IPC_SOURCE_CREATE = 0x0A04
    IPC_CHANNEL_APPEND = 0x0A05
    IPC_SOURCE_DELETE = 0x0A06
    IPC_CHANNEL_DELETE = 0x0A07
    IPC_CHANNEL_CLEAR = 0x0A08
    IPC_SOURCE_GENERAL = 0x0A09
    IPC_CHANNEL_GENERAL = 0x0A0A
    IPC_SLOT_SOURCE_COUNT = 0x0A0B

    IPC_CROP_LIST = 0x0A09
    IPC_CROP_CREATE = 0x0A0A
    IPC_CROP_DELETE = 0x0A0B
    IPC_CROP_GENERAL = 0x0A0C

    IPC_GROUP_LIST = 0x0A10
    IPC_GROUP_CREATE = 0x0A11
    IPC_GROUP_DELETE = 0x0A12
    IPC_GROUP_NODE_LIST = 0x0A13
    IPC_GROUP_NODE_ADD = 0x0A14
    IPC_GROUP_NODE_DELETE = 0x0A15
    IPC_GROUP_NODE_CLEAR = 0x0A16


    IPC_MONTAGE_LIST = 0x0A17
    IPC_MONTAGE_CREATE = 0x0A18
    IPC_MONTAGE_DELETE = 0x0A19
    IPC_MONTAGE_APPLY = 0x0A1A
    IPC_MONTAGE_GENERAL = 0x0A1B
    IPC_MONTAGE_TEMPLATE_DETAIL = 0x0A1C
    IPC_STREAM_DETAIL = 0x0A1D
    IPC_STREAM_LIST = 0x0A1E
    IPC_SOURCE_STATUS_LIST = 0x0A30


    NDI_SOURCE_CREATE = 0x0B00
    NDI_SOURCE_DELETE = 0x0B01
    NDI_SOURCE_UPDATE = 0x0B02
    NDI_SOURCE_LIST = 0x0B03
    NDI_SOURCE_SEARCH = 0x0B04
    NDI_SOURCE_DETAIL = 0x0B05
    NDI_SOURCE_CROP_CREATE = 0x0B10
    NDI_SOURCE_CROP_DELETE = 0x0B11
    NDI_SOURCE_CROP_UPDATE = 0x0B12
    NDI_SOURCE_CROP_LIST = 0x0B13

    NETWORK_SOURCE_GROUP_CREATE = 0x0B20
    NETWORK_SOURCE_GROUP_UPDATE = 0x0B21
    NETWORK_SOURCE_GROUP_DELETE = 0x0B22
    NETWORK_SOURCE_GROUP_NODE_CREATE = 0x0B23
    NETWORK_SOURCE_GROUP_NODE_DELETE = 0x0B24
    NETWORK_SOURCE_GROUP_NODE_CLEAR = 0x0B25
    NETWORK_SOURCE_GROUP_LIST = 0x0B26
    NETWORK_SOURCE_GROUP_LIST_SEARCH = 0x0B27
    NETWORK_SOURCE_GROUP_DETAIL = 0x0B28

    NDI_STREAM_DETAIL = 0x0B30
    NDI_STREAM_LIST = 0x0B31
    NDI_OSD = 0x0B40

    # 功能码分组：根据执行耗时长短来分组
    # fnCodeList为空表示：该分组为默认分组,当从其它分组中找不到指定的fnCode时则使用默认分组
    FnCode_Group = [
        {
            "maxUsedTime": ExecTimes.UltraShort,
            "fnCodeList": [DEVICE_HEARTBEAT]
        },
        {
            "maxUsedTime": ExecTimes.Shot,
            "fnCodeList": [
                OUTPUT_LIST, OUTPUT_FULL_DETAIL, INPUT_LIST,
                SCREEN_OUTMODE, LAYER_SET_Z_ORDER, SCREEN_FULLDETAIL,
                LAYER_LIST, LAYER_CREATE, LAYER_DELETE, LAYER_GENERAL, LAYER_LAYOUTWINDOW, LAYER_FULLDETAIL,
                PRESET_LIST, PRESET_CREATE, PRESET_DELETE, PRESET_FULL_DETAIL, PRESET_FULL_DETAIL,
                MVR_LIST, MVR_FULL_DETAIL, MVRWINDOW_LIST, MVRWINDOW_CREATE, MVRWINDOW_DELETE, MVRWINDOW_GENERAL,
                MVRWINDOW_FULL_DETAIL, BKG_LIST, BKG_FULL_DETAIL,
                MVRWINDOW_UMD_ENABLE
            ]
        },
        {
            "maxUsedTime": ExecTimes.Long,
            "fnCodeList": [BKG_CREATE, SCREEN_OSD, DEVICE_GUIDE_DATA, DEVICE_EXPORTLOG]
        },
        {
            "maxUsedTime": ExecTimes.Mid,
            "fnCodeList": None
        },
        {
            "maxUsedTime": ExecTimes.MidLong,
            "fnCodeList": [INPUT_OSD]
        },
        {
            "maxUsedTime": ExecTimes.SpecialLength,
            "fnCodeList": [SCREEN_BKG]
        }
    ]
