"""
Created on 2019年6月28日
@author: 刘益宗
图层接口.
返回值统一为 {data:JSON结构体, msg:"", status:0}
"""

from H_9U.models.result import get_result_model, ResInfo
from H_9U.mao.layer_mao import layer_api


class LayerSvc:

    def create(self, device_id, screen_id, params):
        """
        创建图层
        :param device_id: 设备Id
        :param screen_id: 屏幕id
        :param params: 中间件协议文档LayerCreate
        :return: {'id':0, 'layersZOrder':[xxx]}
        """
        rs = layer_api.write_create(device_id, screen_id, params)
        return rs

    def delete(self, device_id, screen_id, layer_id):

        """
        删除图层
        :param device_id: 设备Id
        :param screen_id: 屏幕id
        :param layer_id: 图层号
        :return: 结果对象
        """
        data = {
            "screenId": screen_id,
            "deviceId": device_id,
            "layerId": layer_id
        }
        rs = layer_api.write_delete(device_id, screen_id, layer_id, data)
        return rs

    def general_read(self, device_id, screen_id, layer_id):
        """
        读取图层基本信息
        :param device_id: 设备Id
        :param screen_id: 屏幕id
        :param layer_id: 图层号
        :return: 参考中间件接口协议
        """
        return layer_api.read_general(device_id, screen_id, layer_id)

    def general_write(self, device_id, screen_id, layer_id, data):
        """
        读取图层基本信息
        :param device_id: 设备Id
        :param screen_id: 屏幕id
        :param layer_id: 图层号
        :param params: 参考中间件接口协议
        :return: 标准返回
        """
        return layer_api.write_general(device_id, screen_id, layer_id, data)

    def layout_window_write(self, device_id, screen_id, layer_id, data):
        """
        设置图层窗口信息
        :param device_id: 设备Id
        :param screen_id: 屏幕id
        :param layer_id: 图层号
        :param data: 参考中间件接口协议
        :return: 标准返回
        """
        return layer_api.write_layout_window(device_id, screen_id, layer_id, data)

    def layout_window_read(self, device_id, screen_id, layer_id):
        """
        设置图层窗口信息
        :param device_id: 设备Id
        :param screen_id: 屏幕id
        :param layer_id: 图层号
        :param data: 参考中间件接口协议
        :return: 标准返回
        """
        return layer_api.read_layout_window(device_id, screen_id, layer_id)

    def source_write(self, device_id, screen_id, layer_id, data):
        """
        设置图层source 信息
        :param device_id: 设备Id
        :param screen_id: 屏幕id
        :param layer_id: 图层号
        :param data: 参考中间件接口协议
        :return: 标准返回
        """
        return layer_api.write_source(device_id, screen_id, layer_id, data)

    def z_order_read(self, device_id, screen_id):
        """
        设置图层source 信息
        :param device_id: 设备Id
        :param screen_id: 屏幕id
        :return: 参考中间件协议
        """
        return layer_api.read_zorder(device_id, screen_id)

    def z_order_write(self, device_id, screen_id, params):
        """
        设置图层Z序
        :param params: 参考中间件接口协议
        :return: 参考中间件协议
        """
        return layer_api.write_zorder(device_id, screen_id, params)

    def full_detail(self, device_id, screen_id, layer_id):
        rs = layer_api.read_detail(device_id, screen_id, layer_id)
        return rs

    def layer_full_detail_list(self, device_id, screen_id):
        """
        读取屏幕详细信息列表
        :param device_id:  设备id
        :param screen_id: 屏幕Id
        :return: list数组，元素同详细信息
        """
        rs = layer_api.read_list(device_id, screen_id)
        detail_list = []
        if rs['status'] == 0 and rs['data']:
            layers = rs['data']['screenLayers']
            for layer in layers:
                layer_id = layer['layerId']
                rs = layer_api.read_detail(device_id, screen_id, layer_id)
                if rs['status'] == 0 and rs['data']:
                    detail_list.append(rs['data'])
        rs = get_result_model()
        rs['data'] = {
            "screenId": screen_id,
            "deviceId": device_id,
            "screenLayers": detail_list
        }
        return rs

    def delete_batch(self, device_id, screen_id, model, params):
        """
        批量删除图层
        :param params: 删除数据
        model=1时layerIds参数不可为空(节点可不存在).
        model=0时layerIds参数可为空，即：清除所有窗口.
        :return: 结果对象列表
        """
        res_list = []
        # 删除指定数据
        if model == 1 and params:
            id_list = params.get('layerIdList')
            if not id_list:
                return get_result_model(ResInfo.Params_Error)
            for l_id in id_list:
                rs = self.delete(device_id, screen_id, l_id)
                res_list.append({
                    'deviceId': device_id,
                    'screenId': screen_id,
                    'layerId': l_id,
                    'status': rs['status']
                })
        # 删除全部数据
        elif model == 0:
            rs = self.read_list(device_id, screen_id)
            if rs['status'] != 0:
                return rs
            if rs['data'] and rs['data']['screenLayers']:
                layers = rs['data']['screenLayers']
                for layer in layers:
                    rs = self.delete(device_id, screen_id, layer['layerId'])
                    res_list.append({
                        'deviceId': device_id,
                        'screenId': screen_id,
                        'layerId': layer['layerId'],
                        'status': rs['status']
                    })
        rs = get_result_model()
        rs['data'] = res_list
        return rs

    def write_lock(self, device_id, screen_id, layer_id, params):
        """
        设置图层锁定
        :param device_id: 设备Id
        :param screen_id: 屏幕Id
        :param layer_id: 图层Id
        :param is_lock: 是否锁定
        :param nontime: 非实时上屏
        :return:
        """
        return layer_api.write_lock(device_id, screen_id, layer_id, params)

    def read_list(self, device_id, screen_id):
        """
        读取屏幕图层简略信息
        :param device_id:  设备id
        :param screen_id:  屏幕Id
        :return: layer列表
        """
        return layer_api.read_list(device_id, screen_id)

    def screen_layer_take(self, device_id, screen_id, layers):
        """
        屏幕图层上屏
        :param device_id: 设备Id
        :param screen_id: 屏幕Id
        :param layers: 图层信息
        :return: 结果对象
        """
        rs = layer_api.write_create_batch(device_id, screen_id, layers)
        return rs

    def freeze(self, device_id, screen_id, layer_id, data):
        """
        屏幕图层上屏
        :param device_id: 设备Id
        :param screen_id: 屏幕Id
        :param layer_id: 图层id
        :return: 结果对象
        """
        return layer_api.write_freeze(device_id, screen_id, layer_id, data)

    def screen_layer_layout(self, device_id, screen_id, data):
        """
        屏幕图层自动布局（模板开窗）
        :param device_id: 设备Id
        :param screen_id: 屏幕Id
        :param data: 图层数据
        :return: 结果对象
        """
        return layer_api.write_screen_layer_layout(device_id, screen_id, data)

    def screen_audio_status(self, device_id, screen_id, layer_id, data):
        """
        屏幕图层音频设置
        :param device_id: 设备Id
        :param screen_id: 屏幕Id
        :param layer_id: 图层Id
        :param data: 图层数据
        :return: 结果对象
        """
        return layer_api.write_audio_status(device_id, screen_id, layer_id, data)

    def write_layer_lock_ratio(self, device_id, screen_id, layer_id, data):
        """
        设置图层纵横比
        :param device_id: 设备Id
        :param screen_id: 屏幕Id
        :param layer_id: 图层Id
        :param data: 图层数据
        :return: 结果对象
        """
        return layer_api.write_layer_lock_ratio(device_id, screen_id, layer_id, data)


layer_svc = LayerSvc()
