"""
Created on 2024年3月1日
@author: 程声清
ndi接口.
对应前端接口ndi
返回值统一为 {data:JSON结构体, msg:"", status:0}
"""
from H_9U.mao.ndi_mao import ndi_api
from H_9U.models.sysconst import NdiVideoMode, NdiDecodeNumber
from H_9U.models.result import get_result_model
from H_9U.util.log import logger


class NdiSvc:

    def ndi_source_create(self, device_id, data):
        for x in data:
            if x['sourceName'] == "":
                x['sourceName'] = x['source']['ndiId']
        return ndi_api.write_ndi_source_create(device_id, data)

    def ndi_source_delete(self, device_id, data):
        return ndi_api.write_ndi_source_delete(device_id, data)

    def ndi_source_update(self, device_id, data):
        return ndi_api.write_ndi_source_update(device_id, data)

    def ndi_source_list(self, device_id, data):
        rs = ndi_api.read_ndi_source_list(device_id, data)
        if rs['status'] != 0 or not rs ['data']:
            return rs
        for x in rs['data']['sourceList']:
            source_id = x['sourceId']
            source_type = x['sourceType']
            crop_rs = self.ndi_source_crop_list(device_id, source_id, source_type)
            if crop_rs['status'] != 0:
                continue
            crops = crop_rs['data']['crops']
            x['crops'] = crops
        return rs

    def ndi_source_search(self, device_id, source_mode):
        return ndi_api.read_ndi_source_search(device_id, source_mode)

    def ndi_source_detail(self, device_id, source_id):
        rs = ndi_api.read_ndi_source_detail(device_id, source_id)
        if rs['status'] != 0 or not rs['data']:
            return rs
        source_id = rs['data']['sourceId']
        source_type = rs['data']['sourceType']
        crop_rs = self.ndi_source_crop_list(device_id, source_id, source_type)
        if crop_rs['status'] != 0:
            return rs
        rs['data']['crops'] = crop_rs['data']['crops']
        return rs

    def ndi_source_crop_detail(self, device_id,  input_id, crop_id, source_type):
        crop_rs = ndi_api.read_ndi_source_crop_list(device_id, input_id, source_type)
        if crop_rs['status'] == 0 and crop_rs['data']:
            crops = crop_rs['data']['crops']
            if crops:
                crop_rs['data'] = [x for x in crops if x['cropId'] == crop_id][0]
        return crop_rs

    def ndi_source_crop_create(self, device_id, input_id, data):
        return ndi_api.write_ndi_source_crop_create(device_id, input_id, data)

    def ndi_source_crop_delete(self, device_id, params):
        rs = get_result_model()
        crop_id_list = params.get('cropList')
        for crop in crop_id_list:
            param_info = {
                "inputId": params.get('inputId'),
                "cropId": crop,
                "deviceId": device_id,
                "sourceType": params.get('sourceType')
            }
            print("param_info==", param_info)
            rs = ndi_api.write_ndi_source_crop_delete(device_id, param_info)
            if rs["status"] == 0:
                logger.debug("删除CROP-成功! CODE:%i, params:%s" % (rs["status"], param_info))
            else:
                logger.error("删除CROP-失败! CODE:%i, params:%s" % (rs["status"], param_info))
        return rs

    def ndi_source_crop_update(self, device_id, input_id, crop_id, data):
        return ndi_api.write_ndi_source_crop_update(device_id, input_id, crop_id, data)

    def ndi_source_crop_list(self, device_id, source_id, source_type):
        return ndi_api.read_ndi_source_crop_list(device_id, source_id, source_type)

    def ndi_stream_detail(self, device_id, data):
        rs = ndi_api.ndi_stream_detail(device_id, data)
        if rs['status'] == 0 and rs['data'] and rs['data']['sourceList']:
            for stream in rs['data']['sourceList']:
                self.ndi_source_total_count(stream)
        return rs

    def ndi_stream_list(self, device_id):
        rs = ndi_api.ndi_stream_list(device_id)
        if rs['status'] == 0 and rs['data'] and rs['data']['slotList']:
            for stream in rs['data']['slotList']:
                self.ndi_stream_total_count(stream)
        return rs

    def ndi_stream_total_count(self, stream):
        if stream:
            decode_mode = stream['decodeMode']
            # videoMode = 0 能解 1路
            # videoMode = 1 能解 2路
            # videoMode = 2 能解 4路
            if decode_mode == NdiVideoMode.SplicingMode:
                stream['slotTotalCount'] = NdiDecodeNumber.OneWayNumber
            elif decode_mode == NdiVideoMode.OneWayMode:
                stream['slotTotalCount'] = NdiDecodeNumber.TwoWayNumber
            elif decode_mode == NdiVideoMode.TwoWayMode:
                stream['slotTotalCount'] = NdiDecodeNumber.FourWayNumber
            else:
                stream['slotTotalCount'] = 0

    def ndi_source_total_count(self, stream):
        if stream['source']:
            decode_mode = stream['source']['sourceMode']
            # videoMode = 0 能解 1路
            # videoMode = 1 能解 2路
            # videoMode = 2 能解 4路
            if decode_mode == NdiVideoMode.SplicingMode:
                stream['slotTotalCount'] = NdiDecodeNumber.OneWayNumber
            elif decode_mode == NdiVideoMode.OneWayMode:
                stream['slotTotalCount'] = NdiDecodeNumber.TwoWayNumber
            elif decode_mode == NdiVideoMode.TwoWayMode:
                stream['slotTotalCount'] = NdiDecodeNumber.FourWayNumber
            else:
                stream['slotTotalCount'] = 0




ndi_svc = NdiSvc()