
"""
Created on 2024年3月5日
@author: 程声清
network接口.
对应前端接口network
返回值统一为 {data:JSON结构体, msg:"", status:0}
"""
import math

from H_9U.mao.ndi_mao import ndi_api
from H_9U.mao.network_mao import network_api
from H_9U.models.result import get_result_model, ResInfo
from H_9U.mao.ipc_mao import ipc_api
from H_9U.models.sysconst import SourceType


class NetworkSvc:
    def network_source_group_create(self, device_id, data):
        return network_api.network_source_group_create(device_id, data)

    def network_source_group_delete(self,  device_id, data):
        return network_api.network_source_group_delete(device_id, data)

    def network_source_group_update(self, device_id, group_id, data):
        return network_api.network_source_group_update(device_id, group_id, data)

    def network_source_group_list(self, device_id):
        rs = network_api.network_source_group_list(device_id)
        if rs['status'] == 0 and rs['data']:
            self._get_source_count(device_id, rs['data'])
        return rs

    def _get_source_count(self, device_id, data):
        """
         递归补充分组下的源数据数量
         :param device_id: 设备Id
         :return: 结果数据
         """
        if 'groupList' in data and len(data['groupList']) > 0:
            for group in data['groupList']:
                # for x in group['sourceList']:
                    # if x['sourceType'] == SourceType.NdiSource:
                    #     crop_rs = ndi_api.read_ndi_source_crop_list(device_id, x['sourceId'], x['sourceType'])
                    #     if crop_rs != 0 or not crop_rs['data']:
                    #         x['crops'] = []
                    #     x['crops'] = crop_rs['data']['crops']
                group_id = group['groupId']
                group_node_rs = network_api.network_source_group_detail(device_id, group_id)
                if group_node_rs['status'] == 0 and group_node_rs['data']:
                   group['totalCount'] = len(group_node_rs['data']['sourceList'])
                self._get_source_count(device_id, group)

    def network_source_group_detail(self, device_id, group_id):
        a_rs = []
        rs = network_api.network_source_group_detail(device_id, group_id)
        if rs['status'] == 0 and rs['data']:
            for x in rs['data']['sourceList']:
                if x['sourceType'] == SourceType.IPCSource:
                    detail_Info_rs = ipc_api.ipc_source_detail_Info(device_id, x['sourceId'])
                    if detail_Info_rs['status'] == 0 and detail_Info_rs['data']:
                        channel_detail_rs = ipc_api.ipc_channel_detail_list(device_id, detail_Info_rs['data']['sourceId'])
                        if channel_detail_rs['status'] == 0 and channel_detail_rs['data']:
                            detail_Info_rs['data']['channelList'] = channel_detail_rs['data']['channelList']
                            if 'protocol' in detail_Info_rs['data']:
                                detail_Info_rs['data'].pop('protocol')
                            x['groupSource'] = detail_Info_rs['data']
                            a_rs.append(x)
                if x['sourceType'] == SourceType.NdiSource:
                    ndi_rs = ndi_api.read_ndi_source_detail(device_id, x['sourceId'])
                    if ndi_rs['status'] == 0 and ndi_rs['data']:
                        crop_rs = ndi_api.read_ndi_source_crop_list(device_id, x['sourceId'], x['sourceType'])
                        if crop_rs['status'] == 0 and crop_rs['data']:
                            ndi_rs['data']['crops'] = crop_rs['data']['crops']
                        else:
                            ndi_rs['data']['crops'] = []
                    if ndi_rs['status'] == 0 and ndi_rs['data']:
                       x['groupSource'] = ndi_rs['data']
                       a_rs.append(x)
        rs = get_result_model()
        rs['data'] = a_rs
        return rs


    def network_source_group_node_create(self, device_id, group_id, data):
        return network_api.network_source_group_node_create(device_id, group_id, data)

    def network_source_group_node_delete(self, device_id, group_id, data):
        return network_api.network_source_group_node_delete(device_id, group_id, data)

    def network_source_group_node_clear(self, device_id, data):
        return network_api.network_source_group_node_clear(device_id, data)

    def network_source_free_list(self, device_id, data):
        """
        读取除分组外的信号源列表，data为分页数据
        :param device_id: 设备Id
        :param data: 分页参数
        :return 结果数据
        """
        # 1.先查询除当前分组有的所有源id
        ipc_id_list = []
        ndi_id_list = []
        source_data_list = self.get_source_id_list(device_id)
        for x in source_data_list:
            if x['sourceType'] == SourceType.IPCSource:
                ipc_id_list.append(x['sourceId'])
            if x['sourceType'] == SourceType.NdiSource:
                ndi_id_list.append(x['sourceId'])
        index = 1
        size = 100
        ipc_source_list = []
        rs = get_result_model()
        while index > 0:
            data['seqPageIndex'] = index - 1
            data['seqPageSize'] = size
            rs = ipc_api.read_ipc_source_free_list(device_id, data)
            if rs['status'] == 0 and rs['data']:
                ipc_source_list.extend(rs['data']['sourceList'])
                nums = rs['data']['nums']
                if math.ceil(nums / size) > index:
                    index += 1
                else:
                    index = 0
            else:
                break
        ndi_source_list = []
        index_ndi = 1
        while index_ndi > 0:
            data['seqPageIndex'] = index_ndi - 1
            data['seqPageSize'] = size
            rs = ndi_api.read_ndi_source_list(device_id, data)
            if rs['status'] == 0 and rs['data']:
                ndi_source_list.extend(rs['data']['sourceList'])
                nums = rs['data']['nums']
                if math.ceil(nums / size) > index_ndi:
                    index_ndi += 1
                else:
                    index_ndi = 0
            else:
                break
        source_list = []
        # 2. 过滤掉分组内占用的源id
        if ipc_source_list:
            for index_c in range(len(ipc_source_list) - 1, -1, -1):
                source = ipc_source_list[index_c]
                source_id = source['sourceId']
                if source_id in ipc_id_list:
                    ipc_source_list.remove(ipc_source_list[index_c])
            source_list.extend(ipc_source_list)
        if ndi_source_list:
            for index_c in range(len(ndi_source_list) - 1, -1, -1):
                source = ndi_source_list[index_c]
                source_id = source['sourceId']
                if source_id in ndi_id_list:
                    ndi_source_list.remove(ndi_source_list[index_c])
            source_list.extend(ndi_source_list)
        rs['data']['sourceList'] = source_list
        return rs

    def get_source_id_list(self, device_id):
        """
        获取所有分组内占用的ipc源的id集合
        :param device_id: 设备Id
        :return: 结果数据
        """
        source_data_list = []
        rs = network_api.network_source_group_list(device_id)
        if rs['status'] == 0 and rs['data']:
            source_data_list = self._get_source_id_list(device_id, rs['data'], source_data_list)
        return source_data_list

    def _get_source_id_list(self, device_id, data, source_data_list):
        """
         递归获取所有分组下的源id 集合数据
         :param device_id: 设备Id
         :return: 结果数据
         """
        if 'groupList' in data and len(data['groupList']) > 0:
            for group in data['groupList']:
                group_id = group['groupId']
                group_node_rs = network_api.network_source_group_detail(device_id, group_id)
                if group_node_rs['status'] == 0 and group_node_rs['data']:
                    for x in group_node_rs['data']['sourceList']:
                        source_data_list.append(x)
                self._get_source_id_list(device_id, group, source_data_list)
        return source_data_list


network_svc = NetworkSvc()