"""
Created on 2021年9月14日
@author: 程声清
bkg服务类
"""
import time

from H_9U.middle import open_bkg_middle
from H_9U.models.sysconst import UploadFileType
from H_9U.models.result import get_result_model, ResInfo
from H_9U.service.common import open_upload_file, file_name_is_support
from H_9U.service.middlewarefilepath import bkg_manager
from H_9U.util.fileopt import remove_file


def bkg_create(device_id, name, file_data, file_name):
    """
    创建BKG
    :param device_id: 设备Id
    :param name:  BKG名称
    :param file_data:  数据
    :param file_name:  文件名称
    :return: BKGId
    """
    # 判断上传的图片类型是否支持
    is_support = file_name_is_support(file_name)
    if not is_support:
        return get_result_model(ResInfo.File_Support_Err)
    # 上传图片
    up_rs = open_upload_file(UploadFileType.BKG, file_data, file_name)
    if not up_rs["bln"]:
        return get_result_model(ResInfo.Upload_File_Fail)
    # 上传成功后：先判断资源是否够用，然后再将图片转成dta文件,最后再在设备上创建BKG
    path_nm = up_rs["pathNm"]
    # 获得图片尺寸，判断资源是否够用
    if not bkg_manager.valid_bkg_file_size(path_nm):
        return get_result_model(ResInfo.BKG_Max_Count_Limit_Error)
    # 发送中间件数据
    data = {
        "deviceId": device_id,
        "name": name,
        "image": {
            "fileName": path_nm,
            "fileLength": 0,
            "hashSum": 0x55FF,
            "width": 0,
            "height": 0,
            "createTime": str(time.time()),
        }}
    rs = open_bkg_middle.write_create_middle(device_id, data)
    # 失败删除源文件
    if rs['status'] != 0:
        remove_file(path_nm)
    return rs


def bkg_delete(device_id, bkg_id_list):
    """
    删除bkg
    :param device_id: 设备Id
    :param bkg_id_list: bkg_id_list Id
    :return:  结果对象
    """
    rs = _screen_used_detail_data(device_id)
    if rs['status'] == 0:
        for bkg_id in bkg_id_list:
            if bkg_id in rs['data']:
                rs = get_result_model(ResInfo.BKG_Used_In_Screen)
            else:
                rs = open_bkg_middle.bkg_detail_data_middle(device_id, bkg_id)
    else:
        rs = get_result_model(ResInfo.BKG_Used_In_Screen)
    return rs


def _screen_used_detail_data(device_id):
    """
    正在使用的屏幕数据
    :param device_id: 设备Id
    :return:  结果对象
    """
    from H_9U.service import open_output_svc
    rs = open_output_svc._get_screen_list(device_id)
    if rs['status'] == 0:
        if rs['data']:
            bkg_list = [x['Bkg']['bkgId']
                        for x in rs['data'] if x['Bkg']['enable'] == 1]
            rs['data'] = bkg_list
    return rs


def bkg_read_detail(device_id, bkg_id):
    """
    读取bkg详情
    :param device_id: 设备id
    :param bkg_id:  bkg_id
    :return: 参考前端接口文档
    """
    return open_bkg_middle.bkg_read_detail_middle(device_id, bkg_id)


def bkg_read_all_list(device_id):
    """
    读取全部bkg详细信息
    :param device_id: 设备Id
    :return: bkg列表
    """
    rs = open_bkg_middle.bkg_read_list_middle(device_id)
    bkg_list = []
    if rs['status'] == 0 and rs['data']:
        for bkg in rs['data']['bkgs']:
            bkg_id = bkg['bkgId']
            bkg_rs = open_bkg_middle.bkg_read_detail_middle(device_id, bkg_id)
            if bkg_rs['status'] == 0 and bkg_rs['data']:
                bkg_list.append(bkg_rs['data'])
        rs = get_result_model()
        rs['data'] = bkg_list
    return rs


def bkg_delete_batch(device_id, params):
    """
    批量删除bkg
    bkg列表与要删除的bkg_id列表取交集
    删除未被屏幕使用的bkg
    :return: 结果数据
    """
    bkg_ids = params.get('bkgIds')
    # # 验证models
    # if model not in [0, 1]:
    #     return get_result_model(ResInfo.Params_Error)
    # # model=1时bkgIds参数不可为空
    # if model == 1:
    #     if not bkg_ids:
    #         return get_result_model(ResInfo.Params_Error)
    rs = _screen_used_detail_data(device_id)
    if rs['status'] != 0:
        return rs
    bkg_used = rs['data']
    rs = open_bkg_middle.bkg_read_list_middle(device_id)
    if rs['status'] == 0:
        bkgs = rs['data']['bkgs']
        if not bkgs:
            return get_result_model()
    else:
        return get_result_model(ResInfo.BKG_Query_Error)
    # 过滤要删除数据
    bkgs = [x['bkgId'] for x in bkgs if x['bkgId'] in bkg_ids]
    rs_data = []
    partial = False
    if bkgs:
        # 循环阐述
        for bkg in bkgs:
            if bkg not in bkg_used:
                del_rs = open_bkg_middle.bkg_detail_data_middle(
                    device_id, bkg)
                status = del_rs['status']
            else:
                status = 1
            rs_data.append(
                {"deviceId": device_id, "bkgId": bkg, "status": status})
            # 是否有不成功删除
            if status != 0:
                partial = True

    if partial:  # 部分成功
        rs = get_result_model(ResInfo.BKG_Batch_Delete_Partial_Success)
        rs['data'] = rs_data
    else:  # 全部成功
        rs = get_result_model()
        rs['data'] = rs_data
    return rs
