"""
Created on 2021年9月17日
@author: 程声清
preset服务类
"""
import time

from H_9U.dao.modelconf import model_conf_dao
from H_9U.middle import open_preset_middle, open_input_middle

from H_9U.models.sysconst import ModelConfKey
from H_9U.models.result import get_result_model, ResInfo


def preset_create(device_id, screen_id, data):
    """
    创建场景
    :param device_id: 设备Id
    :param screen_id: 屏幕号
    :param data: 创建场景参数
    :return: 新增场景Id
    """
    rs = open_preset_middle.preset_create_middle(device_id, screen_id, data)
    # if rs['status'] == 0:
    #     preset_id = rs['data']['id']
    #     detail_rs = open_preset_middle.preset_detail_read_middle(
    #         device_id, screen_id, preset_id)
    #     if detail_rs['status'] == 0:
    #         from H_9U.service import open_screen
    #         open_screen._fill_layers_name(
    #             device_id, detail_rs['data']['layers'])
    #         rs = detail_rs
    return rs


def preset_delete(device_id, screen_id, preset_id, data):
    """
    删除场景
    :param data: 删除场景参数
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :param preset_id: 场景Id
    :return: 结果对象
    """
    return open_preset_middle.preset_write_delete_middle(
        device_id, screen_id, preset_id, data)


def preset_general_write(device_id, screen_id, preset_id, data):
    """
    读取场景基本信息
    :param data: 场景信息参数
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :param preset_id: 场景Id
    :return: 参考中间件协议PresetGeneral部分
    """
    return open_preset_middle.preset_general_write_middle(
        device_id, screen_id, preset_id, data)


def preset_play(device_id, screen_id, preset_id, data):
    """
    场景播放
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :param preset_id: 场景Id
    :param data:播放场景参数
    :return: 结果对象
    """
    rs = open_preset_middle.preset_play_middle(
        device_id, screen_id, preset_id, data)
    if rs['status'] == 0:
        key = str(device_id) + '|' + str(screen_id)
        model_conf_dao.set_value(ModelConfKey.PresetPlay, key, preset_id)
    return rs


def preset_read_detail(device_id, screen_id, preset_id):
    """
    场景详细信息
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :param preset_id: 场景Id
    :return: 参考中间件协议场景详情
    """
    return open_preset_middle.preset_detail_read_middle(
        device_id, screen_id, preset_id)


def preset_delete_all(device_id, screen_id):
    """
    删除屏幕下全部场景
    :param device_id:  设备Id
    :param screen_id:  屏幕Id
    :return: 删除场景列表
    """
    rs = open_preset_middle.preset_list_read_middle(device_id, screen_id)
    if rs['status'] == 0 and rs['data']:
        del_result = []
        success = True
        for p in rs['data']['presets']:
            preset_id = p['presetId']
            params = {
                'deviceId': device_id,
                'screenId': screen_id,
                'presetId': preset_id}
            del_rs = open_preset_middle.preset_delete_middle(
                device_id, screen_id, preset_id, params)
            if del_rs['status'] != 0:
                success = False
            params['status'] = del_rs['status']
            del_result.append(params)
        if success:
            rs = get_result_model()
        else:
            rs = get_result_model(ResInfo.Preset_Batch_Delete_Part_Success)
            rs['data'] = del_result

    else:
        rs = get_result_model(ResInfo.Preset_List_Error)
    return rs


def preset_group_list(device_id, screen_id):
    """
    场景分组下所有场景的详细信息
    :param device_id:  设备Id
    :param screen_id:  屏幕Id
    :return: 参考接口文档groupList
    """
    rs = open_preset_middle.preset_group_list_middle(device_id, screen_id)
    if rs['status'] == 0 and rs['data']:
        group_list = []
        # 循环分组， 读取分组详细信息
        for group in rs['data']['presetGroups']:
            group_id = group['presetGroupId']
            group_name = group['name']
            # 读取分组详细信息
            group_rs = open_preset_middle.preset_group_node_list_middle(
                device_id, screen_id, group_id)
            if group_rs['status'] == 0:
                group_rs['data']['name'] = group_name
                # 循环场景
                preset_list = []
                # 循环分组下场景
                for preset in group_rs['data']['presets']:
                    preset_id = preset['presetId']
                    # 读取场景详细信息
                    detail_rs = open_preset_middle.preset_detail_read_middle(
                        device_id, screen_id, preset_id)
                    if detail_rs['status'] == 0 and detail_rs['data']:
                        # 循环场景下图层
                        detail = detail_rs['data']
                        detail['zorder'] = preset['zorder']
                        # 读取场景下图层信息
                        for layer in detail['layers']:
                            input_id = layer['source']['inputId']
                            crop_id = layer['source']['cropId']
                            name = ''
                            input_rs = open_input_middle.read_detail_middle(
                                device_id, input_id)
                            connect_capacity = None
                            if input_rs['status'] == 0 and input_rs['data']:
                                connect_capacity = input_rs['data']['general']['connectCapacity']
                                name = input_rs['data']['general']['name']
                                # iSignal = input_rs['data']['iSignal']
                                if 0 <= crop_id < 255:
                                    crop = [
                                        x for x in input_rs['data']['crops'] if x['cropId'] == crop_id]
                                    if crop:
                                        name = crop[0]['name']
                            layer['source']['connectCapacity'] = connect_capacity
                            layer['source']['name'] = name

                        preset_list.append(detail)
                    else:
                        pass
                group_rs['data']['presets'] = preset_list
                group_list.append(group_rs['data'])
            else:
                pass
        rs['data']['presetGroups'] = group_list
    return rs


def preset_group_create(device_id, screen_id, params):
    """
    创建场景分组
    :param device_id: 设备Id
    :param screen_id:  屏幕Id
    :param params: 分组信息
    :return:  创建分组Id
    """
    presets = params.get('presets')
    if not presets:
        return get_result_model(ResInfo.Params_Error)
    return open_preset_middle.preset_group_create_middle(
        device_id, screen_id, params)


def preset_group_delete(device_id, screen_id, group_id):
    """
    删除场景分组
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :param group_id: 分组Id
    :return: 结果数据
    """
    params = {
        "presetGroupId": group_id,
        "screenId": screen_id,
        "deviceId": device_id
    }
    return open_preset_middle.preset_group_delete_middle(
        device_id, screen_id, params)


def preset_group_node_list(device_id, screen_id, group_id):
    """
    读取场景分组节点列表
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :param group_id:  分组Id
    :return:  分组节点列表信息
    """
    return open_preset_middle.preset_group_node_list_middle(
        device_id, screen_id, group_id)


def preset_poll(device_id, screen_id, params):
    """
    场景轮询
    :param device_id: 设备Id
    :param screen_id:  屏幕Id
    :param params: 轮询参数
    :return: 结果数据
    """
    enable = params['enable']
    if enable == 1:
        # 关闭原来场景轮循
        rs = open_preset_middle.preset_poll_read_middle(device_id, screen_id)
        if rs['status'] == 0 and rs['data']:
            enable_old = rs['data']['enable']
            if enable_old == 1:
                group_id = rs['data']['presetGroupId']
                open_preset_middle.preset_write_poll_middle(device_id, screen_id, {
                    "screenId": screen_id,
                    "deviceId": device_id,
                    "presetGroupId": group_id,
                    "enable": 0
                })
        # 校验场景分组中是否有数据
        group_id = params['presetGroupId']
        rs = open_preset_middle.preset_group_node_list_middle(
            device_id, screen_id, group_id)
        if rs['status'] != 0 or not rs['data'] or not rs['data'].get(
                'presets', None):
            return get_result_model(ResInfo.Preset_Group_Empty)
    return open_preset_middle.preset_write_poll_middle(
        device_id, screen_id, params)


def preset_read_list(device_id, screen_id):
    """
    读取屏幕下场景
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :return: 场景列表
    """
    return open_preset_middle.preset_list_read_middle(device_id, screen_id)
    # if rs['status'] == 0 and rs['data']:
    #     presets = rs['data']['presets']
    #     # 循环场景
    #     for preset in presets:
    #         from H_9U.service import open_screen
    #         open_screen._fill_layers_name(device_id, preset['layers'])
    # return rs


def preset_poll_read(device_id, screen_id):
    """
    读取场景轮询数据
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :return: 轮询场景组信息
    """
    return open_preset_middle.preset_poll_read_middle(device_id, screen_id)


def preset_play_read(device_id, screen_id):
    """
    读取屏幕播放的场景
    :param device_id:  设备id
    :param screen_id:  屏幕Id
    :return:  场景Id
    """
    return open_preset_middle.preset_play_read_middle(device_id, screen_id)


def preset_group_update(device_id, screen_id, params):
    """
    修改场景分组
    :param device_id: 设备Id
    :param screen_id:  屏幕Id
    :param params: 分组信息
    :return:  结果对象
    """
    presets = params.get('presets')
    if not presets:
        return get_result_model(ResInfo.Params_Error)
    return open_preset_middle.preset_group_update_middle(
        device_id, screen_id, params)


def preset_overwrite(device_id, screen_id, preset_id, params):
    """
    场景覆盖
    :param device_id: 设备Id
    :param screen_id:  屏幕Id
    :param preset_id:  场景Id
    :param params: 信息
    :return:  结果对象
    """
    params["createTime"] = str(time.time())
    params["overWrite"] = 1
    rs = open_preset_middle.preset_create_middle(device_id, screen_id, params)
    # if rs['status'] == 0:
    #     detail_rs = open_preset_middle.preset_detail_read_middle(
    #         device_id, screen_id, preset_id)
    #     if detail_rs['status'] == 0:
    #         # from H_9U.service import open_screen_svc
    #         # open_screen_svc._fill_layers_name(
    #         #     device_id, detail_rs['data']['layers'])
    #         rs = detail_rs
    return rs
