"""
Created on 2021年9月14日
@author: 程声清
screen服务类
"""

from H_9U.middle import open_screen_middle, open_output_middle, open_layer_middle, open_bkg_middle
from H_9U.service.common import upload_file, open_upload_file
from H_9U.util.log import logger
from H_9U.models.sysconst import ConnectCapacity, UploadFileType, ModelId

from H_9U.models.result import get_result_model, ResInfo
from H_9U.util.assembly_data import assembly_data, repeated_judgment, remove_param


def screen_create(device_id, params):
    """
    创建单个Screen. 参数不含screenId
    :param device_id: 设备Id
    :param params: 创建屏幕参数
    :return: 屏幕Id
    """
    rs = screen_support_create(device_id, params)
    if rs['status'] == 0:
        rs = open_screen_middle.screen_create_middle(device_id, params)
        if rs['status'] != 0:
            logger.error("创建屏幕-失败:%i" % rs["status"])
        return rs
    return rs


def screen_delete(device_id, screen_list):
    """
    删除屏幕
    :param device_id: 设备Id
    :param screen_list:  屏幕Id列表
    :return: 结果数据
    """
    rs = get_result_model()
    screen_id_arr = []
    for screen_id in screen_list:
        data = {'deviceId': device_id, 'screenId': screen_id}
        rs = open_screen_middle.screen_delete_middle(
            device_id, screen_id, data)
        if rs["status"] == 0:
            screen_id_arr.append(screen_id)
            logger.debug(
                "删除screenDelete_write-成功,deviceId:%i, screenId:%i" %
                (device_id, screen_id))
        else:
            logger.error(
                "删除screenDelete_write-失败,deviceId:%i, screenId:%i, status:%i" %
                (device_id, screen_id, rs["status"]))
            screen_id_arr.append(screen_id)
    screen_id_list = {'deviceId': device_id, 'screenIdList': screen_id_arr}
    rs['data'].append(screen_id_list)
    return rs


def screen_delete_batch(device_id):
    """
    批量删除屏幕
    :param device_id: 设备Id
    :return: 结果数据
    """
    rs = get_result_model()
    screen_list = screen_read_list(device_id)
    if screen_list['data']:
        screen_arr = []
        for screen_rs in screen_list['data']['screens']:
            screen_arr.append(screen_rs['screenId'])
        for screen_id in screen_arr:
            data = {'deviceId': device_id, 'screenId': screen_id}
            rs = open_screen_middle.screen_delete_middle(
                device_id, screen_id, data)
    return rs


def screen_read_list(device_id):
    """
    读取列表
    :param device_id: 设备id
    :return: 统一结果
    """
    return open_screen_middle.read_list_middle(device_id)


def screen_rename(device_id, screen_id, data):
    """
    设置基本信息
    :param device_id: 设备Id
    :param screen_id:  屏幕Id
    :param data: 数据
    """
    rs = open_screen_middle.screen_rename_middle(device_id, screen_id, data)
    if rs["status"] != 0:
        logger.error("设置重命名-失败! CODE:%i, params:%s" % (rs["status"], data))
    return rs


def screen_read_detail(
        device_id,
        screen_id):
    """
    读取屏幕详细信息
    :param device_id: 设备Id
    :param screen_id: 屏幕id
    :return: 屏幕详细信息
    """
    rs = read_detail(device_id, screen_id)
    if rs['status'] == 0 and rs['data']:
        rs['data']['deviceId'] = device_id
        rs['data']['screenId'] = screen_id
        # 处理屏幕画质等相关信息
        outputs = rs['data']['outputMode']['screenInterfaces']
        x, y = assembly_data(outputs)
        rs['data']['outputMode']['offset'] = {'x': x, 'y': y}
        if outputs:
            # 为每个输出加入slotId和ConnectCapacity信息,
            for output in outputs:
                connect_capacity = ConnectCapacity.Default
                o_id = output['outputId']
                interface_type = -1
                output_name = ''
                if 0 <= o_id < 255:
                    output_rs = open_output_middle.output_original_detail_middle(
                        device_id, o_id)
                    if output_rs['status'] == 0 and rs['data']:
                        connect_capacity = output_rs['data']['connectCapacity']
                        interface_type = output_rs['data']['interfaceType']
                        output_name = output_rs['data']['general']['name']
                output['outputName'] = output_name
                output['interfaceType'] = interface_type
                output['connectCapacity'] = connect_capacity
        # 屏幕图层信息
        layers = _screen_layer_detail_list(
            device_id,
            screen_id)
        rs['data']['screenLayers'] = []
        if layers['status'] == 0 and layers['data']:
            rs['data']['screenLayers'] = layers['data']
        # bkg 信息
        bkg_id = rs['data']['Bkg']['bkgId']
        bkg_url = ''
        if bkg_id >= 0:
            bkg_rs = open_bkg_middle.bkg_read_detail_middle(device_id, bkg_id)
            if bkg_rs['status'] == 0 and bkg_rs['data']:
                bkg_url = bkg_rs['data']['data']['image']['imgUrl']
        rs['data']['Bkg']['imgUrl'] = bkg_url

    return rs


def screen_layer_detail_list(device_id, screen_id):
    """
    屏幕图层列表
    :param device_id: 设备Id
    :param screen_id:  屏幕Id
    :return:  屏幕下所有图层
    """
    return _screen_layer_detail_list(device_id, screen_id)


def _screen_layer_detail_list(
        device_id,
        screen_id):
    """
    屏幕图层列表
    :param device_id: 设备Id
    :param screen_id:  屏幕Id
    :return:  屏幕下所有图层
    """
    rs = open_layer_middle.layer_full_detail_list_middle(device_id, screen_id)
    # if rs['status'] == 0 and rs['data']:
    # rs['data'] = rs['data']['screenLayers']
    # _fill_layers_name(
    #     device_id,
    #     rs['data'],
    #     ipc_mode,
    #     ipc_list,
    #     montage_list,
    #     input_list)
    return rs


# todo: 删除此方法，中间件负责返回数据s
# def _fill_layers_name(
#         device_id,
#         layers,
#         ipc_mode=None,
#         ipc_list=None,
#         montage_list=None,
#         input_list=None):
#     """
#     图层名称填充
#     :param device_id: 设备Id
#     :param layers:  图层列表
#     :param ipc_mode:  ipc_mode
#     :param ipc_list:  ipc列表
#     :param montage_list:  montage_list
#     :param input_list:  输入列表
#     :return:  屏幕下所有图层
#     """
#     if not layers:
#         return
#     if ipc_mode is None:
#
#         mode_rs = open_device_middle.device_ipc_mode_read_middle(device_id)
#         ipc_mode = mode_rs['data']['ipcMode']
#         if ipc_mode == 0:
#             ipc_list = open_input_middle.input_ipc_source_list_middle(device_id)[
#                 'data']
#         else:
#             montage_list = open_input_middle.input_ipc_montage_list_middle(device_id)[
#                 'data']
#     if input_list is None:
#         input_list = open_input_middle.input_read_all_middle(device_id)['data']
#
#     for layer in layers:
#         name = ''
#         connect_capacity = ConnectCapacity.Default
#         crop_id = layer['source']['cropId']
#
#         if layer['source']['sourceType'] == LayerSourceType.IPCSource:
#             ipc_input_id = -1
#             slot_id = layer['source']['slotId']
#             if ipc_mode == 0:
#                 ipc_source_id = layer['source']['inputId']
#                 if ipc_list is not None:
#                     ipc_source = [
#                         x for x in ipc_list['ipcList'] if x['slotId'] == slot_id]
#                     if ipc_source:
#                         ipc_source = [
#                             x for x in ipc_source[0]['ipcSourceList'] if x['ipcSourceId'] == ipc_source_id]
#                         if ipc_source:
#                             ipc_source = ipc_source[0]
#                             ipc_input_id = ipc_source['inputId']
#                             connect_capacity = ipc_source['connectCapacity']
#                             name = ipc_source['name']
#                             if 0 <= crop_id < 255:
#                                 crop = [
#                                     x for x in ipc_source['crops'] if x['cropId'] == crop_id]
#                                 if crop:
#                                     name = crop[0]['name']
#
#             elif ipc_mode == 1:
#                 if montage_list is not None:
#                     montage = [
#                         x for x in montage_list if x['slotId'] == slot_id]
#                     if montage:
#                         montage = montage[0]
#                         ipc_input_id = montage['ipcInputId']
#
#                         connect_capacity = montage['connectCapacity']
#                         name = montage['modeName']
#                         if 0 <= crop_id < 255:
#                             crop = [
#                                 x for x in montage['crops'] if x['cropId'] == crop_id]
#                             if crop:
#                                 name = crop[0]['name']
#             layer['source']['ipcInputId'] = ipc_input_id
#         else:
#             input_id = layer['source']['inputId']
#
#             if input_list is not None:
#                 input_data = [
#                     x for x in input_list if x['inputId'] == input_id]
#                 if input_data:
#                     input_data = input_data[0]
#                     connect_capacity = input_data['general']['connectCapacity']
#                     name = input_data['general']['name']
#                     if 0 <= crop_id < 255:
#                         crop = [x for x in input_data['crops']
#                                 if x['cropId'] == crop_id]
#                         if crop:
#                             name = crop[0]['name']
#
#         layer['source']['name'] = name
#         layer['source']['connectCapacity'] = connect_capacity


def read_detail(device_id, screen_id):
    """
    读取屏幕详细信息
    :param device_id: 设备Id
    :param screen_id: 屏幕id
    :return: 屏幕详细信息
    """
    return open_screen_middle.screen_read_detail_middle(device_id, screen_id)


def ftb(device_id, screen_id, params):
    """
    屏幕设置ftb(ftb与freeze互斥)
    :param device_id:  设备Id
    :param screen_id:  屏幕Id
    :param params: ftb数据
    :return: 结果对象
    """
    type_info = params.get('type')
    freeze_rs = True
    rs = get_result_model()
    # 黑屏关闭freeze
    if type_info == 0:
        rs = open_screen_middle.write_freeze_middle(device_id, screen_id, {
            "deviceId": device_id,
            "screenId": screen_id,
            "enable": 0
        })
        if rs['status'] != 0:
            freeze_rs = False
    if freeze_rs:
        rs = open_screen_middle.write_ftb_middle(device_id, screen_id, params)

    return rs


def screen_bkg_write(device_id, screen_id, bkg_id, enable, params):
    """
    屏幕写bkg
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :param bkg_id: bkg_id
    :param enable
    :param params: 参数
    :return: 结果数据
    """
    rs = open_screen_middle.screen_bkg_write_middle(
        device_id, screen_id, params)
    if rs['status'] == 0:
        if enable == 1:
            _bkg_image_url(device_id, bkg_id)
    return rs


def _bkg_image_url(device_id, bkg_id):
    """
    bkg url数据
    :param device_id: 设备Id
    :param bkg_id: bkgId
    :return: {imageUrl:}
    """
    rs = open_bkg_middle.bkg_read_detail_middle(device_id, bkg_id)
    if rs['status'] == 0 and rs['data']:
        rs['data'] = {
            'imageUrl': rs['data']['data']['image']['imgUrl']
        }
    return rs


def screen_write_freeze(device_id, screen_id, params):
    """
    屏幕设置freeze，(ftb与freeze互斥)
    :param params: 屏幕冻结数据
    :param device_id:  设备Id
    :param screen_id:  屏幕Id
    :return: 结果对象
    """
    enable = params.get('enable')
    ftb_rs = True
    rs = get_result_model()
    if enable == 1:  # 启用freeze，关闭ftb
        rs = open_screen_middle.write_ftb_middle(device_id, screen_id, {
            "deviceId": device_id,
            "screenId": screen_id,
            "type": 1,
            "time": 15
        })
        if rs['status'] != 0:  # ftb成功，freeze
            ftb_rs = False
        if ftb_rs:
            rs = open_screen_middle.write_freeze_middle(
                device_id, screen_id, params)
    return rs


def screen_osd_write(device_id, screen_id, params, has_file):
    """
    屏幕写osd
    :param device_id:  设备Id
    :param screen_id:  屏幕Id
    :param params: osd参数，参考前端接口文档writeOSD
    :param has_file:
    :return: 结果对象
    """
    type_info = params['type']
    if type_info == 1:
        if 'words' in params:
            params.pop('words')
        if has_file:  # 有图片
            # 有图片则上传图片
            up_rs = upload_file(UploadFileType.OSD)
            if not up_rs["bln"]:
                return get_result_model(ResInfo.Upload_File_Fail)
            path_nm = up_rs["pathNm"]
            params['image']['file']['fileName'] = path_nm
            params['image']['file']['hashSum'] = 0
        else:
            # 没有图片文件则删除file节点
            if 'image' in params and 'file' in params['image']:
                params['image'].pop('file')
    else:
        if 'image' in params:
            params.pop('image')

    rs = open_screen_middle.write_osd_middle(device_id, screen_id, params)
    if rs['status'] == 0:
        detail = read_detail(device_id, screen_id)
        if detail['status'] == 0 and detail['data']:
            rs['data'] = {'Osd': detail['data']['Osd']}
    return rs


def screen_write_image_osd(
        device_id,
        screen_id,
        params):
    """
    屏幕写osd
    :param device_id:  设备Id
    :param screen_id:  屏幕Id
    :param params: osd参数，参考前端接口文档writeOSD
    :return: 结果对象
    """
    type_info = params['type']
    file_name = params['image']['fileName']
    file_data = params['image']['file']
    has_file = False
    if file_data:
        has_file = True
    if type_info == 1:
        if 'words' in params:
            params.pop('words')
        if has_file:  # 有图片
            # 有图片则上传图片
            up_rs = open_upload_file(UploadFileType.OSD, file_data, file_name)
            if not up_rs["bln"]:
                return get_result_model(ResInfo.Upload_File_Fail)
            path_nm = up_rs["pathNm"]
            params['image']['fileName'] = path_nm
            params['image']['hashSum'] = 0
        else:
            # 没有图片文件则删除file节点
            if 'image' in params and 'file' in params['image']:
                params['image'].pop('file')
    else:
        if 'image' in params:
            params.pop('image')
    file_rs = {
        'fileLength': params['image']['fileLength'],
        'fileName': params['image']['fileName'],
        'hashSum': params['image']['hashSum'],
        'height': params['height'],
        'width': params['width']}
    file_image = {'file': file_rs}
    file_osd = {
        'image': file_image,
        'enable': params['enable'],
        'isJudge': params['isJudge'],
        'type': params['type'],
        'x': params['x'],
        'y': params['y'],
        'deviceId': params['deviceId'],
        'height': params['height'],
        'width': params['width'],
        'screenId': params['screenId']}
    file_osd['image']['opacity'] = params['image']['opacity']
    rs = open_screen_middle.screen_write_image_osd_middle(
        device_id, screen_id, file_osd)
    return rs


def screen_non_time_detail(device_id, screen_id):
    """
    读取非实时上屏全部数据
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :return: 结果对象
    """
    rs = open_screen_middle.screen_non_time_detail_middle(device_id, screen_id)
    if rs['status'] == 0:
        pass
        # _fill_layers_name(device_id, rs['data']['layers'])
        # if rs['data']['layers']:
        #     for layer in rs['data']['layers']:
        #         lock_rs = open_layer_middle.layer_read_lock_middle(
        #             device_id, screen_id, layer['layerId'], 1)
        #         lock = 0
        #         if lock_rs['status'] == 0:
        #             lock = lock_rs['data']['lock']
        #         layer['lock'] = {"lock": lock}
    return rs


def screen_write_3d(device_id, screen_id, params):
    """
    设置屏幕3D
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :param params: 3D数据
    :return: 结果对象
    """
    rs = screen_support_3d(device_id, screen_id)
    if rs['status'] != 0:
        return rs
    return open_screen_middle.screen_screen_write_3d_middle(
        device_id, screen_id, params)


def screen_write_output_mode(device_id, screen_id, params):
    """
    设置屏幕布局
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :param params: 布局数据，参考前端接口文档
    :return: 结果数据
    """
    # 没有输出口信息，返回参数错误

    interfaces = params.get('screenInterfaces')
    if not interfaces:
        return get_result_model(ResInfo.Params_Error)
    # 请求参数中所有的的输出接口id 集合
    output_id_list = [x['outputId'] for x in interfaces]
    screen_detail_rs = screen_read_detail(device_id, screen_id)
    output_list = open_output_middle.output_read_list_middle(device_id)
    if output_list['status'] == 0 and output_list['data'] and screen_detail_rs['data'] and screen_detail_rs['status']:
        screenInterface_list = screen_detail_rs['data']['outputMode']['screenInterfaces']
        output_id_used_list = [y['outputId'] for y in output_list['data']['outputs'] if y['isUsed'] == 1]
        for x in screenInterface_list:
            if x['outputId'] not in output_id_list and x['outputId'] in output_id_used_list:
                return get_result_model(ResInfo.Output_Is_Used)
    rs = screen_output_mode_support_create(device_id, params)
    if rs['status'] == 0:
        return open_screen_middle.screen_write_output_mode_middle(device_id, screen_id, params)
    return rs

def screen_output_mode_support_create(device_id, params):
    # 1.判断正在使用的输出不能建屏幕
    refresh_rate_list = []
    model_id_list = []
    addr_time_list = []
    front_porch_list = []
    sync_list = []
    sync_polarity_list = []
    total_time_list = []
    count = 0
    rs = get_result_model()
    for output_id in [x['outputId'] for x in params['screenInterfaces']]:
        if output_id == 255:
            continue
        out_put_detail_rs = open_output_middle.output_original_detail_middle(
            device_id, output_id)
        if out_put_detail_rs['status'] == 0 and out_put_detail_rs['data']:
            model_id_list.append(out_put_detail_rs['data']['modelId'])
            addr_time_list.append(
                out_put_detail_rs['data']['timing']['horizontal']['addrTime'])
            front_porch_list.append(
                out_put_detail_rs['data']['timing']['horizontal']['frontPorch'])
            sync_list.append(
                out_put_detail_rs['data']['timing']['horizontal']['sync'])
            sync_polarity_list.append(
                out_put_detail_rs['data']['timing']['horizontal']['syncPolarity'])
            total_time_list.append(
                out_put_detail_rs['data']['timing']['horizontal']['totalTime'])
            # 输出的卡类型 是16网口/20网口二合一卡
            if out_put_detail_rs['data']['modelId'] in ModelId.Two_In_One_Card_List:
                # 获取刷新率
                refresh_rate = out_put_detail_rs['data']['timing']['refreshRate']
                refresh_rate_list.append(refresh_rate)
    addr_time_list_jud = 1
    front_porch_list_jud = 1
    sync_list_jud = 1
    sync_polarity_list_jud = 1
    total_time_list_jud = 1
    if len(addr_time_list) > 0:
        addr_time_list_jud = repeated_judgment(addr_time_list)
    if len(front_porch_list) > 0:
        front_porch_list_jud = repeated_judgment(front_porch_list)
    if len(sync_list) > 0:
        sync_list_jud = repeated_judgment(sync_list)
    if len(sync_polarity_list) > 0:
        sync_polarity_list_jud = repeated_judgment(sync_polarity_list)
    if len(total_time_list) > 0:
        total_time_list_jud = repeated_judgment(total_time_list)
    if count != 0 or addr_time_list_jud != 1 \
            or front_porch_list_jud != 1 \
            or sync_list_jud != 1 \
            or sync_polarity_list_jud != 1 \
            or total_time_list_jud != 1:
        rs = get_result_model(ResInfo.Output_Support_Err)
    # 刷新率相同可混合建屏
    if len(refresh_rate_list) > 0 and repeated_judgment(
            refresh_rate_list) != 1:
        rs = get_result_model(ResInfo.Output_Support_Err)
        print("refresh_rate_list==", refresh_rate_list)
    # 同接口类型同timing的output可创建屏幕
    model_id_list_jud = 1
    if len(model_id_list) > 0:
        model_id_list_jud = repeated_judgment(model_id_list)
    if model_id_list_jud != 1 or addr_time_list_jud != 1 or front_porch_list_jud != 1 or sync_list_jud != 1 \
            or sync_polarity_list_jud != 1 \
            or total_time_list_jud != 1:
        rs = get_result_model(ResInfo.Output_Support_Err)
    return rs


def screen_support_create(device_id, params):
    """
    创建Screen限制业务判断
    :param device_id: 设备Id
    :param params: 创建屏幕参数
    :return:
    """
    # 1.判断正在使用的输出不能建屏幕
    refresh_rate_list = []
    model_id_list = []
    addr_time_list = []
    front_porch_list = []
    sync_list = []
    sync_polarity_list = []
    total_time_list = []
    interface_type_list = []
    count = 0
    rs = get_result_model()
    output_list = open_output_middle.output_read_list_middle(device_id)
    # 判断正在使用的输出不能建屏幕
    if output_list['status'] == 0 and output_list['data']:
        output_id_list = [y['outputId'] for y in output_list['data']['outputs'] if y['isUsed'] == 1]
        for x in params['screenInterfaces']:
            if x['outputId'] in output_id_list:
                return get_result_model(ResInfo.Output_Is_Used)
    # 获取输出的卡类型
    for output_id in [x['outputId'] for x in params['screenInterfaces']]:
        if output_id == 255:
            continue
        out_put_detail_rs = open_output_middle.output_original_detail_middle(
            device_id, output_id)
        if out_put_detail_rs['status'] == 0 and out_put_detail_rs['data']:
            model_id_list.append(out_put_detail_rs['data']['modelId'])
            addr_time_list.append(
                out_put_detail_rs['data']['timing']['horizontal']['addrTime'])
            front_porch_list.append(
                out_put_detail_rs['data']['timing']['horizontal']['frontPorch'])
            sync_list.append(
                out_put_detail_rs['data']['timing']['horizontal']['sync'])
            sync_polarity_list.append(
                out_put_detail_rs['data']['timing']['horizontal']['syncPolarity'])
            total_time_list.append(
                out_put_detail_rs['data']['timing']['horizontal']['totalTime'])
            # 输出的卡类型 是16网口/20网口二合一卡
            if out_put_detail_rs['data']['modelId'] in ModelId.Two_In_One_Card_List:
                # 获取刷新率
                refresh_rate = out_put_detail_rs['data']['timing']['refreshRate']
                refresh_rate_list.append(refresh_rate)
    # HDMI(1.3/1.4)DVI(SL/DL)timing相同可混合建屏(2.3.4.5)
    addr_time_list_jud = 1
    front_porch_list_jud = 1
    sync_list_jud = 1
    sync_polarity_list_jud = 1
    total_time_list_jud = 1
    if len(addr_time_list) > 0:
        addr_time_list_jud = repeated_judgment(addr_time_list)
    if len(front_porch_list) > 0:
        front_porch_list_jud = repeated_judgment(front_porch_list)
    if len(sync_list) > 0:
        sync_list_jud = repeated_judgment(sync_list)
    if len(sync_polarity_list) > 0:
        sync_polarity_list_jud = repeated_judgment(sync_polarity_list)
    if len(total_time_list) > 0:
        total_time_list_jud = repeated_judgment(total_time_list)
    if count != 0 or addr_time_list_jud != 1 \
            or front_porch_list_jud != 1 \
            or sync_list_jud != 1 \
            or sync_polarity_list_jud != 1 \
            or total_time_list_jud != 1:
        rs = get_result_model(ResInfo.Output_Support_Err)
    # 刷新率相同可混合建屏
    if len(refresh_rate_list) > 0 and repeated_judgment(
            refresh_rate_list) != 1:
        rs = get_result_model(ResInfo.Output_Support_Err)
        print("refresh_rate_list==", refresh_rate_list)
    # 同接口类型同timing的output可创建屏幕
    model_id_list_jud = 1
    if len(model_id_list) > 0:
        model_id_list_jud = repeated_judgment(model_id_list)
    if model_id_list_jud != 1 or addr_time_list_jud != 1 or front_porch_list_jud != 1 or sync_list_jud != 1 \
            or sync_polarity_list_jud != 1 \
            or total_time_list_jud != 1:
        rs = get_result_model(ResInfo.Output_Support_Err)
    return rs


def screen_support_3d(device_id, screen_id):
    """
    屏幕可开启3D数据限制
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :return:
    """
    rs = open_screen_middle.read_detail_middle(device_id, screen_id)
    if rs["status"] == 0 and rs['data']:
        if len([x for x in rs['data']['outputMode']['screenInterfaces']
                if x['modelId'] in ModelId.Two_In_One_Card_List]) > 0:
            rs = get_result_model()
        else:
            rs = get_result_model(ResInfo.Screen_Support_Err)
    else:
        return rs
    return rs


def screen_write_gamma(device_id, screen_id, params):
    """
    设置屏幕3D
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :param params: 3D数据
    :return: 结果对象
    """
    return open_screen_middle.screen_write_gamma_middle(
        device_id, screen_id, params)