"""
Created on 2021年11月03日
@author: 程声清
user服务类
"""
from H_9U.middle import open_user_middle
from H_9U.models.result import get_result_model, ResInfo
from H_9U.util.signature_encryption import get_pid, get_secret_key


def user_info_create(data):
    """
    添加第三方对接信息
    :param data:
    :return:
    """
    p_name = data.get('projectName')
    user_rs = open_user_middle.get_user_info_by_name(p_name)
    if user_rs['status'] != 0 or user_rs['data']:
        return get_result_model(ResInfo.Open_Repeat_Err)
    p_id = get_pid()
    data['pId'] = p_id
    secret_key = data['secretKey']
    open_user_rs = open_user_middle.get_user_info(p_id)
    if open_user_rs['status'] != 0 or open_user_rs['data']:
        return get_result_model(ResInfo.Open_Repeat_Err)
    open_info_rs = open_user_middle.get_user_info_by_key(secret_key)
    if open_info_rs['status'] != 0 or open_info_rs['data']:
        return get_result_model(ResInfo.Open_key_Illegal_Err)
    return open_user_middle.add_user(data)


def get_user_info_by_id(o_id):
    """
    根据id获取信息
    :param o_id: o_id
    :return:
    """
    return open_user_middle.get_user_info_by_id(o_id)


def get_open_info_list():
    """
    获取信息列表
    :return:
    """
    return open_user_middle.get_open_info_list()


def find_open_info_by_name(project_name):
    """
    根据projectName 模糊查询
    :param project_name: project_name
    :return:
    """
    return open_user_middle.find_open_info_by_name(project_name)


def find_open_info_secret_key():
    """
    随机获取秘钥
    :return:
    """
    rs = get_result_model()
    rs['data'] = get_secret_key()
    return rs


def update_open_info(data):
    """
    修改第三方信息
    :param data: data
    :return: 结果对象
    """
    o_id = data.get('id', 0)
    if o_id <= 0:
        return get_result_model(ResInfo.Params_Error)
    status = data.get('status', 0)
    if status > 1 or status < 0:
        return get_result_model(ResInfo.Params_Error)
    is_encrypt = data.get('isEncrypt', 0)
    if is_encrypt > 1 or is_encrypt < 0:
        return get_result_model(ResInfo.Params_Error)
    if data.get('projectName') == "" or data.get('secretKey') == "":
        return get_result_model(ResInfo.Params_Error)
    info_params = dict()
    info_params['pId'] = data.get('pId')
    info_params['projectName'] = data.get('projectName')
    info_params['secretKey'] = data.get('secretKey')
    info_params['isEncrypt'] = data.get('isEncrypt')
    info_params['status'] = data.get('status')
    return open_user_middle.update_user_info_by_id(o_id, info_params)


def delete_open_info(o_id):
    """
    删除与第三方信息
    :param o_id: o_id
    :return: 结果对象
    """
    return open_user_middle.delete_open_info(o_id)
