"""
Created on 2019年6月28日
@author: 刘益宗
output服务类
"""
from H_9U.service.common import get_connect_capacity
from H_9U.util.log import logger
from H_9U.models.result import get_result_model, ResInfo
from H_9U.models.sysconst import ModelId, ConnectCapacity, Output12GSDIConst
from H_9U.mao.output_mao import output_api
from copy import deepcopy


class OutputSvc:

    def read_list(self, device_id):
        """
        读取输出列表
        :param device_id: 设备Id
        :return: 列表，只包含id和Name
        """
        return output_api.read_list(device_id)

    def write_general(self, device_id, output_id, params):
        """
        设置基本信息
        :param params: json参数，见文档
        :return: 结果数据对象
        """
        rs = output_api.write_general(device_id, output_id, params)

        if rs["status"] != 0:
            logger.error("设置General-失败! CODE:%i, params:%s" % (rs["status"], params))
        return rs

    def write_test_pattern(self, device_id, output_id, params):
        """
        设置测试画面.
        :param params: JSON对象参数
        :return: json 数据
        """
        rs = output_api.write_test_pattern(device_id, output_id, params)

        if rs["status"] == 0:
            logger.debug("设置测试画面-成功! CODE:%i, params:%s" % (rs["status"], params))
        else:
            logger.error("设置测试画面-失败! CODE:%i, params:%s" % (rs["status"], params))

        return rs

    def write_timing(self, device_id, output_list, params):
        """
        设置Timing.
        :param params: 设置Timing.
        :return: 结果对象
        """
        try:
            data = []

            # 循环output列表
            partial = False
            for output_id in output_list:
                timeing = deepcopy(params)
                timeing['outputId'] = output_id
                rs = output_api.write_timing(device_id, output_id, timeing)
                success = 1
                if rs["status"] != 0:
                    logger.debug("设置Timing-失败! CODE:%i, params:%s" % (rs["status"], output_id))
                    success = 0
                    partial = True
                data.append({
                    'outputId': output_id,
                    'success': success
                })
            if partial:  # 部分成功
                rs = get_result_model(ResInfo.Output_Write_Timing_List_Error)
            else:  # 全部成功
                rs = get_result_model()
            rs['data'] = data
        except Exception as e:
            logger.error(e)
            rs = get_result_model(ResInfo.Output_Write_Timing_List_Error)
        return rs

    def write_timing_original(self, device_id, output_id, data):
        return output_api.write_timing_original(device_id, output_id, data)

    def write_image_quality(self, device_id, output_id, params):
        """
        设置画质
        :param device_id: 设备Id
        :param output_id:  输出Id
        :return:  结果对象
        """
        rs = output_api.write_image_quality(device_id, output_id, params)

        if rs["status"] == 0:
            logger.debug("设置画质-成功! CODE:%i, params:%s" % (rs["status"], params))
        else:
            logger.error("设置画质-失败! CODE:%i, params:%s" % (rs["status"], params))

        return rs

    def write_gamma(self, device_id, output_id, params):
        """
        设置gamma
        :param params: json对象
        :return: 结果对象
        """
        rs = output_api.write_gamma(device_id, output_id, params)

        if rs["status"] == 0:
            logger.debug("设置Gamma-成功! CODE:%i, params:%s" % (rs["status"], params))
        else:
            logger.error("设置Gamma-失败! CODE:%i, params:%s" % (rs["status"], params))

        return rs

    def output_read_detail(self, device_id, output_id):
        """
        读取详细信息
        :param device_id: 设备号
        :param output_id: 输入号
        :return: 结果对象
        """
        detail_rs = output_api.read_detail(device_id, output_id)
        if detail_rs["status"] == 0 and detail_rs['data']:
            detail_rs['data']['connectCapacity'] = get_connect_capacity(detail_rs['data']['interfaceType'])
            if detail_rs['data']['modelId'] in ModelId.Two_In_One_Card_List:
                detail_rs['data']['connectCapacity'] = ConnectCapacity.K4
        return detail_rs

    def build_output_data(self, device_id, output_item):
        """
        读取详细信息
        :param device_id: 设备号
        :param output_id: 输入号
        :return: 结果对象
        """
        return output_api._build_detail_data(device_id, output_item)

    def read_fixed_position(self, device_id):
        """
        读取输出定位
        :param device_id: 设备Id
        :return: 结果数据
        """
        output_id = 255  # 255表示全部输出
        rs = output_api.read_fixed_position(device_id, output_id)
        if rs["status"] == 0:
            if rs['data']:
                # 每次设置全部，结果全部一样，只读第一个
                enable = rs['data']['enable']
            else:
                enable = 0
            rs['data'] = {'deviceId': device_id, 'enable': enable}
        else:
            logger.error("output_fixed_position_read-失败:%i" % rs["status"])
        return rs

    def write_fixed_position(self, device_id, params):
        """
        设置输出定位
        :param device_id: 设备Id
        :param params: 输出定位参数
        :return: 结果对象
        """
        output_id = 255
        params['outputId'] = output_id
        return output_api.write_fixed_position(device_id, output_id, params)

    def output_edid_export(self, device_id, output_id):
        """
        读取edid
        :param device_id: 设备Id
        :param output_id: 输出id
        :return: edid文件地址
        """
        return output_api.read_edid(device_id, output_id)

    def output_write_payload(self, device_id, output_id_list, data):
        return output_api.write_payload(device_id, output_id_list, data)

    def output_write_4k_timing(self, device_id, output_id_list, data):
        return output_api.output_write_4k_timing(device_id, output_id_list, data)

    def output_write_sdi_timing(self, device_id, output_id_list, params):
        width =  params['horizontal']['addrTime']
        height =  params['vertical']['addrTime']
        refreshRate = params['refreshRate']
        params['width'] = width
        params['height'] = height
        params['refreshRate'] = refreshRate
        params['timing'] = {
            'horizontal': params['horizontal'],
            'vertical':params['vertical'],
            'refreshRate':params['refreshRate']
        }
        if width >= Output12GSDIConst.LimitWidth and \
                        height >= Output12GSDIConst.LimitHeight and \
                        refreshRate > Output12GSDIConst.LimitRefresh:
            rs = output_api.output_write_4k_timing(device_id, output_id_list, params)
        else:
            rs = self.write_timing(device_id, output_id_list, params)
        return rs


output_svc = OutputSvc()
