"""
Created on 2022年3月18日
@author: 程声清
role 服务
"""
from H_9U.models.cachekey import CacheKey, CacheDuration
from H_9U.models.sysconst import RoleMaxCountValue
from H_9U.models.result import get_result_model, ResInfo
from H_9U.dao.role import roledao
from H_9U.util.cache import cacher


class RoleApi:

    def _add(self, data):
        """
        添加角色
        :param data: 角色数据
        :return: 结果对象
        """
        rs = roledao.get_all_role()
        if rs['status'] == 0:
            if len(rs['data']) > RoleMaxCountValue.Role_Max_Count:
                return get_result_model(ResInfo.Role_Max_Count)
        role_name = data['rolename']
        rs = roledao.get_by_rolename(role_name)
        if rs['status'] == 0 and rs['data'] and rs['data']['name'] == role_name:
            return get_result_model(ResInfo.Role_Name_Exist)
        sort = data.get('sort', '')
        active = data.get('active', 1)
        parent_id = data.get('parentId')
        func_ids = data.get('funcId')
        input_ids = data.get('inputId')
        output_ids = data.get('outputId')
        screen_ids = data.get('screenId')
        mvr_ids = data.get('mvrId')
        if len(func_ids) == 0:
            func_ids = [15]
        return roledao.insert(
            role_name,
            sort,
            3,
            parent_id,
            active,
            func_ids,
            input_ids,
            output_ids,
            screen_ids,
            mvr_ids)

    def _delete(self, role_id):
        """
        删除角色
        :param role_id: 角色数据
        :return: 结果对象
        """
        rs = roledao.get_by_id(role_id)
        if rs['status'] != 0 or not rs['data']:
            return rs
        # 超级管理员不准删除
        if rs['data']['role_type'] == 1 or rs['data']['role_type'] == 2:
            return get_result_model(ResInfo.Role_No_Delete)
        # 被删除当前角色的上级Id
        parent_id = rs['data']['parent_id']
        # 获取以当前角色Id为父ID的所有角色
        des_parent = roledao.get_by_parent_id(role_id)
        if des_parent['status'] == 0 and des_parent['data']:
            for des_parent_message in des_parent['data']:
                # 将所有以要删除的当前角色的Id作为父Id的下级角色的父Id 调整为要删除的当前角色的父Id
                update_rs = roledao.update_role(parent_id, des_parent_message['id'])
                if update_rs['status'] != 0:
                    return get_result_model(ResInfo.Role_Update_Err)
        # 查看当前角色是否绑定了用户
        role_user_us = roledao.get_user_by_role_id(role_id)
        if role_user_us['status'] != 0:
            return get_result_model(ResInfo.Role_No_Delete)
        user_ids = []
        for role_user in role_user_us['data']:
            user_id = role_user['userId']
            user_ids.append(user_id)
        delete_rs = roledao.delete(role_id, user_ids)
        if delete_rs['status'] != 0:
            return get_result_model(ResInfo.Role_No_Delete)
        return rs

    def _update(self, params):
        """
        更新角色
        :param params: 角色数据
        :return: 结果对象
        """
        role_id = params.get('id', 0)
        if role_id <= 0:
            return get_result_model(ResInfo.Params_Error)
        role_params = dict()
        role_params['sort'] = params.get('sort', '')
        func_ids = params.get('funcId')
        input_ids = params.get('inputId')
        output_ids = params.get('outputId')
        screen_ids = params.get('screenId')
        mvr_ids = params.get('mvrId')
        role_name = params.get('rolename')
        if role_name == "":
            return get_result_model(ResInfo.Params_Error)
        role_mess = roledao.get_role_by_role_name(role_id, role_name)
        if role_mess['status'] == 0 and role_mess['data']:
            return get_result_model(ResInfo.Role_Name_Exist)
        role_params['name'] = role_name
        if 'active' in params:
            role_params['active'] = params.get('active')
        if len(func_ids) <= 0:
            func_ids = [4, 15]
        return roledao.update(
            role_id,
            role_params,
            func_ids,
            input_ids,
            output_ids,
            screen_ids,
            mvr_ids)

    def _all_role(self, user):
        """
        获取全部角色
        :param user: 登录用户
        :return: 结果对象
        """
        if user['superadmin'] == 1:
            role_rs = roledao.get_all_role()
            if role_rs['status'] != 0 or not role_rs['data']:
                return role_rs
            for role in role_rs['data']:
                role_id = role['id']
                role_user_rs = roledao.get_user_by_role_id(role_id)
                if role_user_rs['status'] != 0:
                    return role_rs
                if role_user_rs['data']:
                    role['is_quote'] = 1
                else:
                    role['is_quote'] = 0
            return role_rs
        user_id = user['id']
        rs = roledao.get_role_by_user_id(user_id)
        if rs['status'] != 0 or not rs['data']:
            return rs
            # 获取当前用户拥有的角色
        role_id = rs['data']['roleId']
        rs = self._get_role_message(role_id)
        return rs

    def _get_role_detail(self, role_id):
        """
        获取角色详情
        :param role_id: 角色Id
        :return:
        """
        func_id = []
        input_id = []
        output_id = []
        screen_id = []
        mvr_id = []
        menu_rs = self._get_menu_all(role_id)
        if menu_rs['status'] == 0 and menu_rs['data']:
            for menu in menu_rs['data']:
                func_id.append(menu['id'])
        data_rs = self._get_menu_data_all(role_id)
        if data_rs['status'] == 0 and data_rs['data']:
            for data_message in data_rs['data']:
                for func_mess in data_message['funcs']:
                    if data_message['type'] == 1:
                        input_id.append(func_mess['id'])
                    if data_message['type'] == 2:
                        output_id.append(func_mess['id'])
                    if data_message['type'] == 3:
                        screen_id.append(func_mess['id'])
                    if data_message['type'] == 4:
                        mvr_id.append(func_mess['id'])
        role_rs = roledao.get_by_id(role_id)
        if role_rs['status'] == 0 and role_rs['data']:
            des_rs = roledao.get_by_id(role_rs['data']['parent_id'])
            name = ""
            if des_rs['status'] == 0 and des_rs['data']:
                name = des_rs['data']['name']
            role_rs['data']['parentName'] = name
            role_rs['data']['funcId'] = func_id
            role_rs['data']['inputId'] = input_id
            role_rs['data']['outputId'] = output_id
            role_rs['data']['screenId'] = screen_id
            role_rs['data']['mvrId'] = mvr_id
        return role_rs

    def _get_menu_all(self, role_id):
        """
        根据角色Id 获取菜单列表
        :param role_id: 角色Id
        :return: 角色菜单列表
        :param
        """
        rs = roledao.get_by_id(role_id)
        if rs['status'] != 0 or not rs['data']:
            return rs
        if rs['data']['role_type'] == 1:
            return roledao.get_funcs()
        fn_rs = roledao.get_func_by_role_id(role_id)
        rs_menu = []
        rs = get_result_model()
        if fn_rs['status'] == 0:
            if fn_rs['data']:
                for fn_rs_message in fn_rs['data']:
                    menu_id = fn_rs_message['menuId']
                    rs = roledao.get_func_by_menu_id(menu_id)
                    if rs['data']:
                        rs_menu.append(rs['data'])
            rs['data'] = rs_menu
        return rs

    def _get_menu_data_all(self, role_id):
        """
        根据角色Id 获取菜单-数据列表
        :param role_id: 角色Id
        :return: 角色详情
        """

        # 如果是超级管理员角色则授予全部权限
        rs = roledao.get_by_id(role_id)
        if rs['status'] != 0 or not rs['data']:
            return rs
        if rs['data']['role_type'] == 1:
            return self._get_data_all()
        # 查询当前角色拥有的输入列表数据
        input_data_rs = self._get_input_by_role_id(role_id)
        input_id_array = [x['inputId'] for x in input_data_rs['data'] if input_data_rs['status'] == 0 and input_data_rs['data']]
        # 查询当前角色拥有的输出列表数据
        output_data_rs = self._get_output_by_role_id(role_id)
        output_id_array = [x['outputId'] for x in output_data_rs['data'] if output_data_rs['status'] == 0 and output_data_rs['data']]
        # 查询当前角色拥有的屏幕列表数据
        screen_data_rs = self._get_screen_by_role_id(role_id)
        screen_id_array = [x['screenId'] for x in screen_data_rs['data'] if screen_data_rs['status'] == 0 and screen_data_rs['data']]
        # 查询当前角色拥有的预监列表数据
        mvr_data_rs = self._get_mvr_by_role_id(role_id)
        mvr_id_array = [x['mvrId'] for x in mvr_data_rs['data'] if mvr_data_rs['status'] == 0 and mvr_data_rs['data']]
        # 获取所有输入的数据，染后将该角色所有的挑出来返回即可
        role_all_data_rs = self._get_data_all()
        result_input_data = []
        if role_all_data_rs['status'] != 0 or not role_all_data_rs['data']:
            return rs
        for input_messages in role_all_data_rs['data']:
            if input_messages['funcs']:
                funcs = input_messages['funcs']
                for index in range(len(funcs) - 1, -1, -1):
                    func_mess = funcs[index]
                    data_id = func_mess['id']
                    if input_messages['type'] == 1 and data_id not in input_id_array:
                        input_messages['funcs'].remove(func_mess)
                    if input_messages['type'] == 2 and data_id not in output_id_array:
                        input_messages['funcs'].remove(func_mess)
                    if input_messages['type'] == 3 and data_id not in screen_id_array:
                        input_messages['funcs'].remove(func_mess)
                    if input_messages['type'] == 4 and data_id not in mvr_id_array:
                        input_messages['funcs'].remove(func_mess)
            result_input_data.append(input_messages)
            rs['data'] = result_input_data
        return rs

    def _get_role_by_id(self, role_id):
        """
        根据角色id获取角色信息
        :param
        :return:
        """
        return roledao.get_by_id(role_id)

    def _get_role_by_user_id(self, user_id):
        """
        根据角色id获取角色信息
        :param
        :return:
        """
        return roledao.get_role_by_user_id(user_id)

    def _get_role_message(self, role_id):
        """
        获取当前角色以及子角色列表
        :param role_id: 角色Id
        :return:
        """
        rs = self._get_role_by_id(role_id)
        role_list = []
        id_roles = []
        role_list.append(rs['data'])
        if rs['status'] == 0 and rs['data']:
            role_ids = rs['data']['id']
            id_roles.append(role_ids)
            length = len(rs['data'])
            while length:
                for ids in id_roles:
                    rs = roledao.get_by_parent_id(ids)
                    length = len(rs['data'])
                    if rs['status'] == 0 and rs['data']:
                        for rs_one in rs['data']:
                            role_ids = rs_one['id']
                            id_roles.append(role_ids)
                            role_list.append(rs_one)
        role_message_list = []
        self.__build_role_info_data(role_list, role_message_list)
        rs['data'] = role_message_list
        return rs

    def __build_role_info_data(self, role_list, role_message_list):
        for roles in role_list:
            role_list_rs = self._get_role_by_id(roles['id'])
            if role_list_rs['status'] == 0 and role_list_rs['data']:
                role_message_list.append(role_list_rs['data'])
            for role_message_ in role_message_list:
                role_id = role_message_['id']
                role_user_rs = roledao.get_user_by_role_id(role_id)
                if role_user_rs['status'] == 0:
                    if role_user_rs['data']:
                        role_message_['is_quote'] = 1
                    else:
                        role_message_['is_quote'] = 0

    def _get_data_all(self):
        """
        根据角色Id 获取菜单-数据列表
        :return: 角色详情
        """
        rs = get_result_model()
        device_id = 0
        input_id_list = []
        output_id_list = []
        mvr_id_list = []
        screen_list = []
        func_list = []
        self.__build_input_and_output_data(device_id, func_list, input_id_list, mvr_id_list, output_id_list)
        self.__build_screen_data(device_id, func_list, mvr_id_list, screen_list)
        rs['data'] = func_list
        return rs

    def __build_screen_data(self, device_id, func_list, mvr_id_list, screen_list):
        from H_9U.service.screen import screen_svc
        screen_rs = screen_svc.read_list(device_id)
        if screen_rs['status'] == 0 and screen_rs['data']:
            screens_list = screen_rs['data']['screens']
            for screens in screens_list:
                screen_message = {
                    "parent_id": 3,
                    "id": screens['screenId'],
                    "name": screens['name'],
                    "createTime": screens['createTime'],
                }
                screen_list.append(screen_message)
            screen_data_message = {
                "name": "屏幕",
                "code": 3,
                "active": 1,
                "type": 3,
                "funcs": screen_list
            }
            func_list.append(screen_data_message)
            mvr_data_message = {
                "name": "预监",
                "code": 4,
                "active": 1,
                "type": 4,
                "funcs": mvr_id_list
            }
            func_list.append(mvr_data_message)

    def __build_input_and_output_data(self, device_id, func_list, input_id_list, mvr_id_list, output_id_list):
        from H_9U.service.device import device_svc
        device_rs = device_svc.device_detail_read(device_id)
        if device_rs['status'] == 0 and device_rs['data']:
            slot_list = device_rs['data']['slotList']
            for slot_message in slot_list:
                card_type = slot_message['cardType']
                # 输入卡
                if card_type == 1:
                    slot_id = slot_message['slotId'] + 1
                    input_class_mess = {
                        "parent_id": 1,
                        "name": "input_" + str(slot_id),
                        "id": slot_message['slotId']
                    }
                    input_id_list.append(input_class_mess)
                if card_type == 2 or card_type == 3:
                    slot_id = slot_message['slotId'] + 1
                    output_class_mess = {
                        "parent_id": 1,
                        "name": "output_" + str(slot_id),
                        "id": slot_message['slotId']
                    }
                    output_id_list.append(output_class_mess)
                if card_type == 4:
                    slot_id = slot_message['slotId'] + 1
                    mvr_class_mess = {
                        "parent_id": 1,
                        "name": "mvr_" + str(slot_id),
                        "id": slot_message['slotId']
                    }
                    mvr_id_list.append(mvr_class_mess)
            input_data_message = {
                "name": "输入",
                "code": 1,
                "active": 1,
                "type": 1,
                "funcs": input_id_list
            }
            func_list.append(input_data_message)
            output_data_message = {
                "name": "输出",
                "code": 2,
                "active": 1,
                "type": 2,
                "funcs": output_id_list
            }
            func_list.append(output_data_message)

    def _get_menu_by_role_id(self, role_id):
        """
        根据角色Id 获取input-数据列表
        :return: 角色详情
        """
        return roledao.get_menu_by_role_id(role_id)

    def _get_input_by_role_id(self, role_id):
        """
        根据角色Id 获取input-数据列表
        :return: 角色详情
        """
        return roledao.get_input_by_role_id(role_id)

    def _get_screen_by_role_id(self, role_id):
        """
        根据角色Id 获取screen-数据列表
        :return: 角色详情
        """
        return roledao.get_screen_by_role_id(role_id)

    def _get_output_by_role_id(self, role_id):
        """
        根据角色Id 获取output-数据列表
        :return: 角色详情
        """
        return roledao.get_output_by_role_id(role_id)

    def _get_mvr_by_role_id(self, role_id):
        """
        根据角色Id 获取mvr-数据列表
        :return: 角色详情
        """
        return roledao.get_mvr_by_role_id(role_id)

    def _get_role_id_by_role_type(self, role_type):
        """
        根据角色类型 获取角色数据
        :return: 角色详情
        """
        return roledao.get_role_id_by_role_type(role_type)

    def _get_all_data_by_role_id(self, role_type):
        """
        根据角色类型 获取角色数据
        :return: 角色详情
        """
        return roledao.get_all_data_by_role_id(role_type)

    def _get_user_list_by_role_id(self, role_id):
        rs = roledao.get_user_by_role_id(role_id)
        if rs['status'] == 0:
            data = [x['userId'] for x in (rs['data'] if rs['data'] else [])]
            rs['data'] = data
        return rs


class RoleSvc(RoleApi):

    def add(self, data):
        """
        添加角色
        :param data: 角色数据
        :return: 结果对象
        """
        return self._add(data)

    def delete(self, role_id):
        """
        删除角色
        :param role_id: 角色id
        :return: 结果对象
        """
        rs = self._delete(role_id)
        if rs['status'] == 0:
            cacher.RoleCache.clear()
            cacher.UserCache.clear()
        return rs

    def update(self, params):
        """
        更新角色
        :param params: 角色params
        :return: 结果对象
        """
        rs = self._update(params)
        if rs['status'] == 0:
            cacher.RoleCache.clear()
            cacher.UserCache.clear()
        return rs

    def all_role(self, user):
        """
        获取所有角色
        :param user: 用户数据
        :return: 结果对象
        """
        return self._all_role(user)

    def get_role_detail(self, role_id):
        """
        获取角色详情
        :param role_id: role_id
        :return: 结果对象
        """
        key = CacheKey.role_detail(role_id)
        return cacher.RoleCache.try_get_value(key, CacheDuration.Default, self._get_role_detail, role_id)

    def get_menu_all(self, role_id):
        """
        获取全部角色列表的菜单数据
        :param role_id: role_id
        :return: 用户列表
        """

        key = CacheKey.role_menu_func(role_id)
        return cacher.RoleCache.try_get_value(key, CacheDuration.Default, self._get_menu_all, role_id)

    def get_menu_data_all(self, role_id):
        """
        获取角色Id 对应的菜单-数据
        :param role_id: role_id
        :return: 角色列表
        """
        key = CacheKey.role_data_func(role_id)
        return cacher.RoleCache.try_get_value(key, CacheDuration.Default, self._get_menu_data_all, role_id)

    def get_role_by_id(self, role_id):
        """
        获取当前用户的角色信息
        :param role_id: role_id
        :return: 角色详情
        """
        return self._get_role_by_id(role_id)

    def get_role_by_user_id(self, user_id):
        """
        获取当前用户的角色信息
        :param role_id: role_id
        :return: 角色详情
        """
        return self._get_role_by_user_id(user_id)

    def get_role_message(self, role_id):
        """
        获取当前角色以及子角色列表
        :param role_id: 角色Id
        :return:
        """
        return self._get_role_message(role_id)

    # def get_data_all(self):
    #     """
    #     根据角色Id 获取菜单-数据列表
    #     :return: 角色详情
    #     """
    #     return self._get_data_all()

    def get_menu_by_role_id(self, role_id):
        """
        根据角色Id 获取menu-数据列表
        :return: 角色详情
        """
        key = CacheKey.role_menu_detail(role_id)
        return cacher.RoleCache.try_get_value(key, CacheDuration.Default, self._get_menu_by_role_id, role_id)

    def get_input_by_role_id(self, role_id):
        """
        根据角色Id 获取input-数据列表
        :return: 角色详情
        """
        key = CacheKey.role_input_detail(role_id)
        return cacher.RoleCache.try_get_value(key, CacheDuration.Default, self._get_input_by_role_id, role_id)

    def get_screen_by_role_id(self, role_id):
        """
        根据角色Id 获取screen-数据列表
        :return: 角色详情
        """
        key = CacheKey.role_screen_detail(role_id)
        return cacher.RoleCache.try_get_value(key, CacheDuration.Default, self._get_screen_by_role_id, role_id)

    def get_output_by_role_id(self, role_id):
        """
        根据角色Id 获取output-数据列表
        :return: 角色详情
        """
        key = CacheKey.role_output_detail(role_id)
        return cacher.RoleCache.try_get_value(key, CacheDuration.Default, self._get_output_by_role_id, role_id)

    def get_mvr_by_role_id(self, role_id):
        """
        根据角色Id 获取mvr-数据列表
        :return: 角色详情
        """
        return self._get_mvr_by_role_id(role_id)

    def get_role_id_by_role_type(self, role_type):
        """
        根据角色类型 获取角色数据
        :return: 角色详情
        """
        return self._get_role_id_by_role_type(role_type)

    def get_user_list_by_role_id(self, role_id):
        return self._get_user_list_by_role_id(role_id)

    def get_all_data_by_role_id(self, role_id):
        return self._get_all_data_by_role_id(role_id)

rolesvc = RoleSvc()
