
// 视频回显类.
function VideoModule(frameW = 1920, frameH = 1080, decoder = 0, frameFormat = 1, printLog = false) { //1920*1080
  var self = this; // self指向实例本身
  this.id = ""; // 每个VideoModule对象的ID
  this._frame_w = frameW; // 视频流帧尺寸-宽度,单位：像素
  this._frame_h = frameH; // 视频流帧尺寸-高度,单位：像素
  this.printLog = printLog; // 是否输出调试日志
  this._decoder = decoder; // 0:h264;1:h265
  this._frameFormat = frameFormat; // 0:jpg, 1:rgb
  this._canvasList = []; // 存储所有注册的画布

  this._img = document.createElement("img");
  this._img.Idle = true;
  this._img.Valid = false;

  this._num_w = 1;
  this._num_h = 1;
  this._videoIP = null;
  this._videoPort = 8081;
  this.wsUrl = null; // webSocket的URL
  this.ws = null; // webSocket实例
  this.wsFirstInit = false; // 是否进行了首次初始化工作[true-是、false-否]

  this.serviceStatus = false; // 记录服务是否进入启动状态[true-是、false-否]
  this.wsDataNum = 0; // websocket接收的数据包数

  this.dynamicCutWs = null;//动态切割websocket实例
  this._dynamicCutParam = null;//动态切割获取的数据
  this._dynamicCutPort = 7999;
  // this._inputPositon = [];
  this.dynamicCusWsUrl = null;
  this.dynamicCutWsFirstInit = false;

  this.MVRMODE = {
    "fixed": {
      "width": 1920,
      "height": 2160
    },
    "unfixed": {
      "width": 1920,
      "height": 1080
    }
  };

  // 开启服务.
  // 参数：
  //   ip-WebSocekt服务的IP;
  //   port-WebSocket服务的端口;
  //   numRow-大图的行数,最小值：1;
  //   numCol-大图的列数,最小值：1;
  //   wsUrl-webSocket地址(如果有了该参数ip、port两个参数可以为空);
  // 备注：
  //   1.如果ip、port地址变化了可以重新调用此方法，但调用之前要先调用closeService();
  this.openService = function(ip, port, numRow, numCol, wsUrl = null, isDynamicCut = false) {
    self.id = new Date().getTime();
    self._num_w = numCol;
    self._num_h = numRow;
    self.wsUrl = wsUrl;

    if(wsUrl!=null) {
      self.dynamicCusWsUrl = wsUrl.slice(0, wsUrl.lastIndexOf(':')) + ':7999/configVideo';
    }
    // 为了尽可能保证成功率:如果ip为空或还回地址则改用document.domain获取的地址
    if (!ip || ip == 'undefined' || ip == "0.0.0.0" || ip.indexOf('127.') == 0) {
      self._videoIP = document.domain;
    } else {
      self._videoIP = ip;
    }

    if (!port || port == 'undefined') {
      self._videoPort = 8081;
    } else {
      self._videoPort = port;
    }

    self.__initWebSocket(self._videoIP, self._videoPort); // 初始化WebSocket
    if(isDynamicCut) {
      self.__initDynamicCutWebSocket(self._videoIP, self._dynamicCutPort);
    }
    self.__initDecodeWorker(); // 初始化'后台解码线程/DecodeWorker'
    self.serviceStatus = true; // 记录服务是否进入启动状态
  };

  // 关闭服务.
  this.closeService = function() {
    self.serviceStatus = false;
    self.__closeWebSocket();
    self.__closeDecoderWorker();
    self.__closeDynamicCutWs();
    // console.log('关闭服务');
  };

  // 注册画布并指定所用视频信号的索引.
  // 参数：
  //   canvas-画布,用来显示切割后视频的画布;
  //   videoIndex-视频信号索引;
  //   recutter-二次切割参数 {
  //     cutRow, 切割行数
  //     cutCol, 切割列数
  //     mode = 1，是否切割，0：直接返回；1：切割
  //     cutIndex, 切割后，从哪个位置获取数据
  //   }
  this.registerCanvasSimple = function(canvas, videoIndex, status = false, cropperInfo = {}, flipType = 0, recutter = null) {
    if (!canvas) {
      return false;
    }
    var index = self.getCanvasIndex(canvas);
    if (index !== -1) { // 修改截取信息 导致的变化
      this.unRegisterCanvas(canvas);
    }
    self._canvasList.push({
      'canvas': canvas,
      'x_pos': videoIndex % this._num_w, // 列号
      'y_pos': Math.floor(videoIndex / this._num_w), //行号
      'x_num_blocks': 1, //
      'y_num_blocks': 1,
      'input_id': videoIndex,
      'recutter': recutter,
      status,
      flipType,
      cropperInfo: cropperInfo
    });
  };

  // 删除指定的画布.
  this.unRegisterCanvas = function(canvas) {
    if (!canvas) {
      // console.error(canvas);
      self._canvasList = self._canvasList.filter(el => document.getElementById(el.canvas.id));
    }
    var toDelIndex = self.getCanvasIndex(canvas);
    // console.log("删除第几个-----",toDelIndex,",长度-----------",self._canvasList.length,"要删除的画布-----",canvas)
    if (toDelIndex !== -1) {
      self._canvasList.splice(toDelIndex, 1);
    }
    // console.log("删完长度------------------------", self._canvasList, self._canvasList.length);
  };

  // 从'画布集合'中找到指定canvas的索引.
  // 参数：
  //   canvas-指定的画布;
  // 返回值：索引值[-1:表示未找到]
  this.getCanvasIndex = function(canvas) {
    // for (var i = 0; i < this._canvasList.length; i++) {
    //   if (this._canvasList[i].canvas === canvas) {
    //     console.log(this._canvasList[i].canvas, canvas)
    //     return i;
    //   }
    // }
    // return -1;
    if (this._canvasList.length) {
      return this._canvasList.findIndex(el => el.canvas == canvas);
    } else {
      return -1;
    }
  };

  // 清空所有注册过的画布.
  this.clearCanvas = function() {
    self._canvasList = [];
  };

  // 设置视频帧尺寸.
  // 参数：
  //   w-宽度,单位：像素;
  //   h-高度,单位：像素;
  this.setFrameSize = function(w, h) {
    // console.log('宽高=================',w,h);
    self._frame_w = w;
    self._frame_h = h;
    self._canvasBuffer.width = self._frame_w;
    self._canvasBuffer.height = self._frame_h;
    self._canvasImgDataBuffer = self._canvasBuffer.getContext("2d").getImageData(0, 0, self._canvasBuffer.width, self._canvasBuffer.height);
  };

  this.setImgSize = function(w, h) {
    self._num_w = w;
    self._num_h = h;
  };
  // ==========================webSocket接收流媒体服务端自动推送的H.264裸流数据==========start=========
  // 裸流数据经过简单处理后交给worker进行解码

  // 初始化-接收视频流的WebSocket.
  this.__initWebSocket = function(webSocketIP, webSocketPort) {
    if (self.wsUrl == null) {
      self.wsUrl = 'ws://' + webSocketIP + ':' + webSocketPort;
    }
    //  self.wsUrl = 'ws://192.168.10.86:8081';
    self.__closeWebSocket(); // 开启之前先关闭
    self.ws = new WebSocket(self.wsUrl);
    self.ws.onopen = this.ws_onopen;
    self.ws.onerror = this.ws_onerror;
    self.ws.onclose = this.ws_onclose;
    self.ws.onmessage = this.ws_onmessage; // webSocket收到数据后会自动回调此函数

    self.wsFirstInit = true;
  };

  // 关闭-接收视频流的WebSocket.
  this.__closeWebSocket = function() {
    if (self.ws != null) {
      self.ws.close();
      self.ws.onopen = null;
      self.ws.onerror = null;
      self.ws.onclose = null;
      self.ws.onmessage = null;
      self.ws = null;
    }
  };

  this.ws_onopen = function() {
    self.ws.binaryType = 'arraybuffer';
    if (self.printLog) {
      console.log("wsUrl:", self.wsUrl, ", ws_onopen!");
    }
  };

  this.ws_onerror = function() {
    if (self.printLog) {
      console.log("wsUrl:", self.wsUrl, ", ws_onerror!");
    }
  };

  this.ws_onclose = function() {
    if (self.printLog) {
      console.log("wsUrl:", self.wsUrl, ", ws_onclose!");
    }
  };

  // webSocket收到数据后会自动回调此函数.收到数据后将数据置入wsReader中
  this.ws_onmessage = function(evt) {
    //改变数据接收方式，把二进制数据直接送去解码
    var buffer = new Uint8Array(evt.data);
    try {
      if (self._canvasList.length) {
        if (buffer.byteLength) {
          var data = {type:1, h264Buff:buffer, seq: ++self.wsDataNum}; // self.wsDataNum当前已经处理的视频数据数量
          self.decodeWorker.postMessage(data, [data.h264Buff.buffer]);
        }
      }
    } catch (e) {
      throw '解码任务溢出';
    }
    evt = null;
    buffer = null;
  };
  // 周期检查WebSocket是否需要初始化,若需要则进行初始化.
  // 仅当：做过首次初始化、且当前websocket处于关闭状态，才会进行初始化
  this.wsIntervalFun = function() {
    if (self.ws != null && self.wsFirstInit && self.serviceStatus && self.ws.readyState == self.ws.CLOSED) {
      self.__initWebSocket(self._videoIP, self._videoPort);
    }
    if (self.dynamicCutWs != null && self.dynamicCutWsFirstInit && self.serviceStatus && self.dynamicCutWs.readyState == self.dynamicCutWs.CLOSED) {
      self.__initDynamicCutWebSocket(self._videoIP, self._videoPort);
    }
  };
  this.wsIntervalId = window.setInterval(this.wsIntervalFun, 5000); // 断线重链,每5秒检查一次

  // ==========================webSocket接收流媒体服务端自动推送的H.264裸流数据==========end===========
  // ==========================webSocket动态切割视频===================================start=========
  // 初始化-动态切割视频socket.
  this.__initDynamicCutWebSocket = function(webSocketIP, webSocketPort) {
    try {
      if (self.dynamicCusWsUrl == null) {
        self.dynamicCusWsUrl = 'ws://' + webSocketIP + ':' + webSocketPort + '/configVideo';
      }
      //  self.wsUrl = 'ws://192.168.10.86:8081';
      self.__closeDynamicCutWs(); // 开启之前先关闭
      self.dynamicCutWs = new WebSocket(self.dynamicCusWsUrl);
      self.dynamicCutWs.onopen = this.dynamicCutWs_open;
      self.dynamicCutWs.onerror = this.dynamicCutWs_onerror;
      self.dynamicCutWs.onclose = this.dynamicCutWs_onclose;
      self.dynamicCutWs.onmessage = this.dynamicCutWs_onmessage; // webSocket收到数据后会自动回调此函数

      self.dynamicCutWsFirstInit = true;
    } catch(e) {
      console.log(e);
    }
  };

  this.dynamicCutWs_open = function() {
    if (self.printLog) {
      console.log("wsUrl:", self.wsUrl, ", dynamicws_onopen!");
    }
    self.dynamicCutWs.send(JSON.stringify({"topic": "query_cfg"})); //socket连接成功后，发送请求获取动态切割参数
  };


  this.dynamicCutWs_onerror = function() {
    if (self.printLog) {
      console.log("wsUrl:", self.wsUrl, ", dynamicws_onerror!");
    }
  };

  this.dynamicCutWs_onclose = function() {
    if (self.printLog) {
      console.log("wsUrl:", self.wsUrl, ", dynamicws_onclose!");
    }
  };

  // webSocket收到数据后会自动回调此函数.收到数据后将数据置入wsReader中
  this.dynamicCutWs_onmessage = function(evt) {
    //改变数据接收方式，把二进制数据直接送去解码
    try {
      self._dynamicCutParam = JSON.parse(evt.data);
      console.log('收到参数=============',self._dynamicCutParam);
      var mvrMode =  self._dynamicCutParam['mvr_mode'];
      self.setFrameSize(self.MVRMODE[`${mvrMode}`]['width'], self.MVRMODE[`${mvrMode}`]['height']);
      self.setImgSize(self._dynamicCutParam['layout']['cols'], self._dynamicCutParam['layout']['rows']);
      self.__initDecodeWorker();
    } catch (e) {
      throw '重启worker失败！';
    }
    evt = null;
  };
  // 关闭-动态切割的WebSocket.
  this.__closeDynamicCutWs = function() {
    if (self.dynamicCutWs != null) {
      self.dynamicCutWs.close();
      self.dynamicCutWs.onopen = null;
      self.dynamicCutWs.onerror = null;
      self.dynamicCutWs.onclose = null;
      self.dynamicCutWs.onmessage = null;
      self.dynamicCutWs = null;
      self._dynamicCutParam = null;
    }
  };

  //下发动态切割参数
  this.sendDynamicCutData = function(data) {
    try{
      // console.log('下发参数=====', data, self.dynamicCutWs);
      if(self.dynamicCutWs!=null && self.dynamicCutWs.readyState == self.dynamicCutWs.OPEN) {
        self.dynamicCutWs.send(JSON.stringify(data));
      }
    } catch(e) {
      throw '下发动态切割参数失败！';
    }
  };
  // ==========================webSocket动态切割视频====================================end===========
  // ==========================worker解码数据===================================start=========
  // 并将解码后的数据置入img标签

  this.decodeWorker = null;

  // 初始化decodeWorker
  this.__initDecodeWorker = function() {
    self.__closeDecoderWorker(); // 开启之前先关闭

    self.decodeWorker = new Worker("/video/decode_worker.js");
    self.decodeWorker.onmessage = el => self.decodeWorker_onmessage(el, this.addImg);
    self.decodeWorker.onerror = function(event) {
      console.error(event);
    };
    // console.log('worker收到的分辨率===========',self._frame_w,self._frame_h);
    self.decodeWorker.postMessage({ type: 3, width: self._frame_w, height: self._frame_h, decoder : self._decoder, frameFormat : self._frameFormat });
  };

  // 关闭decodeWorker
  this.__closeDecoderWorker = function() {
    if (self.decodeWorker != null) {
      self.decodeWorker.terminate();
      self.decodeWorker.onmessage = null;
      self.decodeWorker.onerror = null;
      self.decodeWorker = null;
      // console.log("............ decodeWorker.close()");
    }
  };

  // worker处理完1帧数据后回调此函数(worker内只做了解码)
  this.decodeWorker_onmessage = function(event, callback) {
    if (event.data.type == 2) {
      var imgData = event.data.frame.slice(4, event.data.frame.length); // 4字节是图片内容外自定义的数据(长度)

      if (self._frameFormat == 0) {
        var url = URL.createObjectURL(new Blob([imgData])); // 将解码返回的二进制数据转化成URL
        callback(url);
      } else {
        self.__drawCanvasOptimize5rgb(imgData);
      }

    } else if (event.data.type == 3) { // 发给server端
      if (self.ws != null && self.serviceStatus && self.ws.readyState == self.ws.OPEN) {
        if (self.printLog) {
          console.log('ws.send:', JSON.stringify({ pendingH264pkg: (self.wsDataNum - event.data.seq) }));
        }
        self.ws.send(JSON.stringify({ pendingH264pkg: (self.wsDataNum - event.data.seq) })); //数据堆积的数量发给server端
      }
    } else {
      event = null;
    }
  };

  // 加载 图片
  this.addImg = function(result) {
      if (self._img.Idle == true) {
        self._img.src = result; // 图片加载完毕后会调用_img.onload事件
        self._img.Idle = false;
      } else { //丢帧
        window.URL.revokeObjectURL(result);
      }
  };
  // ==========================worker解码数据===================================end===========

  // createImageBitmap  不支持 safari ie
  // onload事件在图片加载完成后立即执行
  this._img.onload = function() {
    this.Idle = true; // this指的是_img
    this.Valid = true; // this指的是_img

    // 判断img尺寸是否与_frame_w相同,以免截取越界
    if (this.width >= self._frame_w) {
      self.__drawCanvasOptimize4img();
    } else {
      window.URL.revokeObjectURL(this._img.src);
    }
  };
  this._img.onerror = function() {
    window.URL.revokeObjectURL(this._img.src);
    // console.log("图片加载出错")
  };

  this.__drawCanvasOptimize4img = function() {
    var pad = 1; // 剔除边缘2像素
    var x_p_b = self._frame_w / self._num_w;
    var y_p_b = self._frame_h / self._num_h;
    self._canvasList = self._canvasList.filter(canvas => canvas != null && canvas != 'undefined' && canvas != undefined);
    if (self._img.Valid != true || self._canvasList.length === 0) {
      window.URL.revokeObjectURL(self._img.src);
      return;
    }
    for (var i = 0; i < self._canvasList.length; i++) {
      var canvas = self._canvasList[i].canvas;
      var x = self._canvasList[i].x_pos * x_p_b;
      var y = self._canvasList[i].y_pos * y_p_b;
      var w = self._canvasList[i].x_num_blocks * x_p_b;
      var h = self._canvasList[i].y_num_blocks * y_p_b;

      //动态改变视频分辨率
      if(self._dynamicCutParam!=null && self._dynamicCutParam['pos']!=null && self._dynamicCutParam['mvr_mode']!=null && self._dynamicCutParam['mvr_mode']== 'unfixed') {
        var findCancas = self._dynamicCutParam['pos'].filter((p) => p.inputId == self._canvasList[i].input_id);
        // console.log('查找input===========',findCancas);
        if(findCancas!=null && findCancas.length > 0) {
          x = findCancas[0].colNo * x_p_b;
          y = findCancas[0].rowNo * y_p_b;
        }
      }
      //如果是IPC源，进行二次切割
      if(self._canvasList[i]['recutter'] && self._canvasList[i]['recutter'].mode && self._canvasList[i]['recutter'].mode === 1) {
        // console.log('二次切割前', 'input====',self._canvasList[i].input_id, 'x的位置====',x,'y的位置====',y,'宽=====',w,'高=====',h,'二次切割======',self._canvasList[i].recutter,'inputId====',self._canvasList[i].input_id);
        // console.log('ipc', 'input====',self._canvasList[i].input_id)
        let cutRow = self._canvasList[i].recutter.cutRow;
        let cutCol = self._canvasList[i].recutter.cutCol;
        let cutIndex = self._canvasList[i].recutter.cutIndex % (cutRow * cutCol);
        let _rowNum = Math.floor(cutIndex / cutCol);
        let _colNum = Math.floor(cutIndex % cutCol);
        w = w/cutCol;
        h = h/cutRow;
        x = x + w * _colNum;
        y = y + h * _rowNum;
        // console.log('二次切割后','x的位置====',x,'y的位置====',y,'宽=====',w,'高=====',h,'二次切割======',self._canvasList[i].recutter,'inputId====',self._canvasList[i].input_id);
      }
      // 视频截取
      if (self._canvasList[i].status) {
        if(self._canvasList[i]['recutter'] && self._canvasList[i]['recutter'].mode!='undefined' && self._canvasList[i]['recutter'].mode!=undefined && self._canvasList[i]['recutter'].mode === 1) {
            let cutRow = self._canvasList[i].recutter.cutRow;
            let cutCol = self._canvasList[i].recutter.cutCol;
            x = x + pad + Math.round(x_p_b / cutCol * (Number(self._canvasList[i].cropperInfo.x)));
            y = y + pad + Math.round(y_p_b / cutRow * (Number(self._canvasList[i].cropperInfo.y)));
            w = Math.round(w * Number(self._canvasList[i].cropperInfo.w)) - 2 * pad;
            h = Math.round(h * Number(self._canvasList[i].cropperInfo.h)) - 2 * pad;
          } else {
            x = x + pad + Math.round(x_p_b * (Number(self._canvasList[i].cropperInfo.x)));
            y = y + pad + Math.round(y_p_b * (Number(self._canvasList[i].cropperInfo.y)));
            w = Math.round(w * Number(self._canvasList[i].cropperInfo.w)) - 2 * pad;
            h = Math.round(h * Number(self._canvasList[i].cropperInfo.h)) - 2 * pad;
          }
      } else {
        x = x + pad;
        y = y + pad;
        w = w - 2 * pad;
        h = h - 2 * pad;
      }

      if (canvas != null && canvas != 'undefined' && canvas != undefined) {
        try {
          var canvasCtx = canvas.getContext('2d', { alpha: false });
          // var canvasCtx = canvas.getContext("2d");
          canvasCtx.clearRect(0, 0, canvas.width, canvas.height);
          canvasCtx.drawImage(self._img, x, y, w, h, 0, 0, canvas.width, canvas.height);
          canvasCtx = null;
        } catch (err) {
          self._img.Valid = false;
        }
        // self.img.Dispose();
      }
      canvas = null;
    }

    window.URL.revokeObjectURL(this._img.src);
  };

  this._canvasBuffer = document.createElement("canvas");
  this._canvasBuffer.width = this._frame_w;
  this._canvasBuffer.height = this._frame_h;
  this._canvasImgDataBuffer = this._canvasBuffer.getContext("2d").getImageData(0, 0, this._canvasBuffer.width, this._canvasBuffer.height);

  this.__drawCanvasOptimize5rgb = function(rgbData) {
    var pad = 1; // 剔除边缘2像素
    var x_p_b = self._frame_w / self._num_w; //小图宽
    var y_p_b = self._frame_h / self._num_h; //小图高
    var imageData = new ImageData(new Uint8ClampedArray(rgbData), self._canvasBuffer.width, self._canvasBuffer.height);
    self._canvasBuffer.getContext("2d").putImageData(imageData, 0, 0);

    for (var i = 0; i < self._canvasList.length; i++) {
      if (self._canvasList[i].input_id == 0xff || self._canvasList[i].input_id === -1)  {continue;} //inputId == '0xff'时，不切割
      var canvas = self._canvasList[i].canvas;
      var x = self._canvasList[i].x_pos * x_p_b;
      var y = self._canvasList[i].y_pos * y_p_b;
      var w = self._canvasList[i].x_num_blocks * x_p_b;
      var h = self._canvasList[i].y_num_blocks * y_p_b;
      //动态切割
      if(self._dynamicCutParam!=null && self._dynamicCutParam['pos']!=null && self._dynamicCutParam['mvr_mode']!=null && self._dynamicCutParam['mvr_mode']== 'unfixed') {
        var findCancas = self._dynamicCutParam['pos'].filter((p) => p.inputId == self._canvasList[i].input_id);
        // console.log('查找input===========',findCancas,self._dynamicCutParam['pos'],self._canvasList[i].input_id);
        if(findCancas!=null && findCancas.length > 0) {
          x = findCancas[0].colNo * x_p_b;
          y = findCancas[0].rowNo * y_p_b;
        }else {
          continue; //在socket返回的位置信息中找不到inputId,就跳过不画
        }
      }
      //如果是IPC源，进行二次切割
      if(self._canvasList[i]['recutter'] && self._canvasList[i]['recutter'].mode && self._canvasList[i]['recutter'].mode === 1) {
        // console.log('二次切割前', 'input====',self._canvasList[i].input_id, 'x的位置====',x,'y的位置====',y,'宽=====',w,'高=====',h,'二次切割======',self._canvasList[i].recutter,'inputId====',self._canvasList[i].input_id);
        // console.log('ipc', 'input====',self._canvasList[i].input_id)
        let cutRow = self._canvasList[i].recutter.cutRow;
        let cutCol = self._canvasList[i].recutter.cutCol;
        let cutIndex = self._canvasList[i].recutter.cutIndex % (cutRow * cutCol);
        let _rowNum = Math.floor(cutIndex / cutCol);
        let _colNum = Math.floor(cutIndex % cutCol);
        w = w/cutCol;
        h = h/cutRow;
        x = x + w * _colNum;
        y = y + h * _rowNum;
        // console.log('二次切割后','x的位置====',x,'y的位置====',y,'宽=====',w,'高=====',h,'二次切割======',self._canvasList[i].recutter,'inputId====',self._canvasList[i].input_id);
      }
      // console.log('截取前===',self._canvasList[i]['status'],self._canvasList[i].input_id);
      // 视频截取
      if (self._canvasList[i].status) {
        // console.log('截取前111===',self._canvasList[i]['recutter']);
        if(self._canvasList[i]['recutter'] && self._canvasList[i]['recutter'].mode!='undefined' && self._canvasList[i]['recutter'].mode!=undefined && self._canvasList[i]['recutter'].mode === 1) {
          // console.log('截取前111===','x的位置====',x,'y的位置====',y,'宽=====',w,'高=====',h,'二次切割======',Number(self._canvasList[i].cropperInfo.x),pad,x_p_b,y_p_b);
          let cutRow = self._canvasList[i].recutter.cutRow;
          let cutCol = self._canvasList[i].recutter.cutCol;
          x = x + pad + Math.round(x_p_b / cutCol * (Number(self._canvasList[i].cropperInfo.x)));
          y = y + pad + Math.round(y_p_b / cutRow * (Number(self._canvasList[i].cropperInfo.y)));
          w = Math.round(w * Number(self._canvasList[i].cropperInfo.w)) - 2 * pad;
          h = Math.round(h * Number(self._canvasList[i].cropperInfo.h)) - 2 * pad;
        // console.log('截取后=============','x的位置====',x,'y的位置====',y,'宽=====',w,'高=====',h,'二次切割======',self._canvasList[i].cropperInfo);
        } else {
          // console.log('截取前222===','x的位置====',x,'y的位置====',y,'宽=====',w,'高=====',h,'二次切割======',Number(self._canvasList[i].cropperInfo.x),pad,x_p_b,y_p_b);
          x = x + pad + Math.round(x_p_b * (Number(self._canvasList[i].cropperInfo.x)));
          y = y + pad + Math.round(y_p_b * (Number(self._canvasList[i].cropperInfo.y)));
          w = Math.round(w * Number(self._canvasList[i].cropperInfo.w)) - 2 * pad;
          h = Math.round(h * Number(self._canvasList[i].cropperInfo.h)) - 2 * pad;
          // console.log('截取后222===','x的位置====',x,'y的位置====',y,'宽=====',w,'高=====',h,'二次切割======',Number(self._canvasList[i].cropperInfo.x),pad,x_p_b,y_p_b);
        }

      } else {
          x = x + pad;
          y = y + pad;
          w = w - 2 * pad;
          h = h - 2 * pad;
          // console.log('截取后1','x的位置====',x,'y的位置====',y,'宽=====',w,'高=====',h,'二次切割======',self._canvasList[i].cropperInfo);
      }
      if (canvas != null && canvas != 'undefined' && canvas != undefined) {
        try {
          // var canvasCtx = canvas.getContext('2d', { alpha: false });
          var canvasCtx = canvas.getContext("2d");
          // canvasCtx.clearRect(0, 0, canvas.width, canvas.height);
          canvasCtx.drawImage(self._canvasBuffer, x, y, w, h, 0, 0, canvas.width, canvas.height);
          canvasCtx = null;
        } catch (err) {
          self._img.Valid = false;
        }
      }
      canvas = null;
    }
  };

}
