"""
Created on 2019年6月28日
@author: 刘益宗
common方法
"""
import base64
import hashlib
import json
import socket
import os
import platform
from werkzeug.security import generate_password_hash, check_password_hash


from H_9U.models.sysconst import Encrypt, SafeConfig, DeviceType

from H_9U.util.log import logger
from Crypto.Cipher import AES
from Crypto.Random import get_random_bytes
from Crypto.Util.Padding import pad, unpad

from H_9U.models.sysconst import PackagePwdConst


def compare_elements(array_a, array_b):
    """
    比较两个数组元素是否完全一致
    :param array_a:
    :param array_b:
    :return:
    """
    common_value = set(array_a) & set(array_b)
    array_c = len(common_value)
    if array_c == len(array_a) == len(array_b):
        return True
    else:
        return False

def is_contain(array_a, array_b):
    """
    比较一个数组元素是否完全包含另外数组中所有元素
    :param array_a:
    :param array_b:
    :return:
    """
    array_d = [False for array_c in array_b if array_c not in array_a]
    if array_d:
        return False
    else:
        return True

def md5(src):
    """
    字符串生成MD5
    :param src:
    :return:
    """
    m2 = hashlib.md5()
    m2.update(src.encode('utf-8'))
    rs = m2.hexdigest()
    return str(rs)


def format_token(character_string):
    """
    字符串替换
    :param src:
    :return:
    """
    str_value = character_string
    if "*" in character_string:
        str_value = character_string.replace("*","=")
    if "#" in str_value:
        str_value = str_value.replace("#","/")
    return str_value



def get_local_ip():
    """
    Returns the actual ip of the local machine.
    This code figures out what source address would be used if some traffic
    were to be sent out to some well known address on the Internet. In this
    case, a Google DNS server is used, but the specific address does not
    matter much.  No traffic is actually sent.
    """
    try:
        sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
        sock.connect(('8.8.8.8', 80))
        (addr, port) = sock.getsockname()
        sock.close()
        return addr
    except socket.error:
        return "127.0.0.1"


def get_ip_ifconfig():
    ip = '127.0.0.1'
    try:
        if platform.system().lower() == 'linux':
            out = os.popen('ifconfig').read()
            out = out[out.index('eth1'): out.index('lo')]
            out = out[out.index('inet'): out.index('netmask')]
            ip = out.split(' ')[1].strip()
    except:
        ip = '127.0.0.1'
    return ip


def valid_json(req_str):
    """
    校验json是否合法
    :param req_str:
    :return: 成功返回json，失败返回None
    """
    if req_str:
        try:
            return json.loads(req_str)
        except Exception as e:
            return None


def valid_params(data, *keys):
    """
    从data中取出所有key对应的值
    :param data: dict
    :param keys: 键
    :return: 是否返回None，一个key时返回单个value，多个key时返回（value1，value2,...）
    """
    if data and keys:
        try:
            # 单个key,直接获取
            if len(keys) == 1:
                rs = _get_value_by_key(data, keys[0])
            else:
                # 多个key，循环获取
                values = []
                for key in keys:
                    v = _get_value_by_key(data, key)
                    if v is not None:
                        values.append(v)
                    else:
                        values = None
                        break
                rs = tuple(values) if values else None
            # 获取成功，校验参数
            if rs is not None:
                if not valid_dict_value(data):
                    rs = None
            return rs
        except Exception as e:
            print(e)

def get_params(data, *keys):
    """
    从data中取出所有key对应的值
    :param data: dict
    :param keys: 键
    :return: 是否返回None，一个key时返回单个value，多个key时返回（value1，value2,...）
    """
    if data and keys:
        try:
            # 单个key,直接获取
            if len(keys) == 1:
                rs = _get_value_by_key(data, keys[0])
            else:
                # 多个key，循环获取
                values = []
                for key in keys:
                    v = _get_value_by_key(data, key)
                    if v is not None:
                        values.append(v)
                    else:
                        values = None
                        break
                rs = tuple(values) if values else None
            return rs
        except Exception as e:
            print(e)


def _get_value_by_key(data, key):
    """
    根据key获取字典值
    :param data: 字典数据
    :param key: key a/b/b
    :return:  数据值
    """
    keys = []
    if '/' in key:
        keys = key.split('/')
    else:
        keys.append(key)

    for k in keys:
        if k in data:
            data = data[k]
        else:
            data = None
            break
    return data


def valid_dict_value(data):
    """
    校验字典数据
    :param data: 字典数据
    :return: 成功返回True,失败返回False
    """
    is_valid = True
    for k, v in data.items():
        if isinstance(v, dict):  # value  dict
            is_valid = valid_dict_value(v)
        elif isinstance(v, list):  # value list
            is_valid = _valid_list_value(v)
        else:  # value 单个值
            is_valid = _valid_single_value(k, v)
        # 校验失败则推出循环
        if is_valid is False:
            break
    return is_valid


def _valid_list_value(data):
    """
    校验List value
    :param data: list value
    :return:  成功返回True,失败返回False
    """
    is_valid = True
    if data:
        for item in data:
            if isinstance(item, dict):  # item dict
                is_valid = valid_dict_value(item)
            elif isinstance(item, list):  # item list
                is_valid = _valid_list_value(item)

    return is_valid


def _valid_single_value(key, value):
    """
    校验 key value
    :param key: key
    :param value: value
    :return:  成功返回True,失败返回False
    """
    is_valid = True
    # 如果key在校验字典中则校验
    if key in _Valid_Dict:
        func = _Valid_Dict[key]['func']
        args = _Valid_Dict[key].get('args', ())
        kwargs = _Valid_Dict[key].get('kwargs', {})
        is_valid = func(value, *args, **kwargs)

    return is_valid


def valid_num_value(value, begin, end, allow_zero=True):
    """
    校验数字Value
    :param value: value
    :param begin:  开始
    :param end: 结束
    :param allow_zero: 允许为0
    :return: 成功返回True,失败返回False
    """
    is_valid = False
    if value != 0:
        if begin <= value <= end:
            is_valid = True
    elif allow_zero:
        is_valid = True

    return is_valid


def valid_int_value(value, begin, end, allow_zero=True):
    """
    校验int值
    :param value: value
    :param begin: 开始
    :param end: 结束
    :param allow_zero: 允许为0
    :return: 成功True，失败False
    """
    # 校验类型
    if not isinstance(value, int):
        return False

    return valid_num_value(value, begin, end, allow_zero)


def valid_str_value(value, min_len, max_len, allow_none=False):
    """
    校验str值
    :param value: value
    :param min_len: 最小长度
    :param max_len: 最大长度
    :param allow_none: 是否允许None
    :return: 成功True，失败False
    """
    is_valid = False
    if value is not None:
        str_len = len(value.encode())
        if min_len <= str_len <= max_len:
            is_valid = True
    elif allow_none:
        is_valid = True

    return is_valid


# 数据校验配置
_Valid_Dict = {
    'inputId': {
        'func': valid_int_value,
        'args': (0, 255)
    },
    'languageMode': {
        'func': valid_int_value,
        'args': (0, 1)
    },
    'enable': {
        'func': valid_int_value,
        'args': (0, 1)
    },
    'effectEnable': {
        'func': valid_int_value,
        'args': (0, 1)
    },
    'name': {
        'func': valid_str_value,
        'args': (0, 300)
    },
    'screenId': {
        'func': valid_int_value,
        'args': (0, 255)
    },
    'deviceId': {
        'func': valid_int_value,
        'args': (0, 10)
    },
    'presetId': {
        'func': valid_int_value,
        'args': (0, 1999)
    },
    'outputId': {
        'func': valid_int_value,
        'args': (0, 255)
    },
    'bkgId': {
        'func': valid_int_value,
        'args': (0, 1024)
    },
    'nomarkMode': {
        'func': valid_int_value,
        'args': (0, 1)
    },
    'cropId': {
        'func': valid_int_value,
        'args': (0, 255)
    },
    'layerId': {
        'func': valid_int_value,
        'args': (0, 255)
    },
    'windowId': {
        'func': valid_int_value,
        'args': (0, 255)
    },
    'mvrId': {
        'func': valid_int_value,
        'args': (0, 0)
    }
}

def check_ip(ip_addr):
    ip_str = ip_addr.strip().split('.')
    if len(ip_str) != 4:
        return False
    for i in range(4):
        try:
            ip_str[i]=int(ip_str[i])
        except:
            return False
        if ip_str[i] <= 255 and ip_str[i] >= 0:
            pass
        else:
            return False
        i+=1
    else:
        return True

def str_hash_code(sn):
    """
    单向哈希算法
    """
    total = 0
    if sn:
        hash_map = {}
        for ch in sn:
            if ord(ch) in hash_map:
                hash_map[ord(ch)] += 1
            else:
                hash_map[ord(ch)] = 1
        for k, v in hash_map.items():
            total += k*v
        total *= len(hash_map)
    return str(total * len(sn))


def encrypt_password(password):
    """
    加密并截取密码
    """
    # 密码加密后的按$分为三部分：加密算法、盐值、加密后密码
    # pbkdf2:sha256:100000$HRCbbKbXFpXdq8QM$46e1b6b68a52b055bfbde3c6f7fcb73ec297144fc5702484c777e3bf735f9745
    encrypt_pwd = generate_password_hash(password, Encrypt.Method, Encrypt.Salt_Len)
    # 截取盐值和加密后的密码并拼接
    _, salt, hash_val = encrypt_pwd.split('$')
    return salt + hash_val


def check_password(pwd, encrypted_pwd):
    """
    校验密码
    """
    salt = encrypted_pwd[:Encrypt.Salt_Len]
    hash_val = encrypted_pwd[Encrypt.Salt_Len:]
    pwhash = '$'.join([Encrypt.Method, salt, hash_val])
    return check_password_hash(pwhash, pwd)

def device_safe_config_read(config_path):
    """
    读取设备系统配置文件
    :param config_path:  config_path
    :return:  is_safe
    """
    from H_9U.util.cache import cacher
    from H_9U.models.cachekey import CacheKey
    device_id = 0
    is_safe = SafeConfig.IsNotSafe
    try:
        with open(config_path, 'r', encoding='utf-8') as fp:
            safe_config_dict = json.loads(fp.read())
            is_safe = safe_config_dict['isSafe']
    except Exception as e:
        logger.error("读取文件异常：" + str(e))
    key = CacheKey.device_is_safe(device_id)
    cacher.DeviceCache.set(key, is_safe)
    return is_safe

def password_verifier(param1, param2, is_safe=0):
    """
    密码校验
    :param1 param1:  当前登陆用户密码
    :param2 param2:  用户二次验证框中输入的密码
    :return:
    """
    flag = True
    if is_safe == SafeConfig.IsNotSafe:
        if param1 != md5(param2):
            flag = False
    if is_safe == SafeConfig.IsSafe:
        if not check_password_hash(param1, param2):
            flag = False
    return flag


def aes_gcm_encrypt(plaintext, secret_key):
    # 生成随机的12字节IV
    iv = get_random_bytes(PackagePwdConst.GCM_IV_Length)
    # 创建AES-GCM加密器
    cipher = AES.new(secret_key, AES.MODE_GCM, nonce=iv)
    # 加密明文
    ciphertext, tag = cipher.encrypt_and_digest(pad(plaintext, AES.block_size))
    # 返回加密结果和IV
    ciphertext = iv + ciphertext + tag
    return base64.b64encode(ciphertext).decode('utf-8')


def aes_gcm_decrypt(ciphertext, secret_key):
    ciphertext = base64.b64decode(ciphertext.encode('utf-8'))
    # 从密文中提取IV和tag
    iv = ciphertext[:PackagePwdConst.GCM_IV_Length]
    tag = ciphertext[-PackagePwdConst.GCM_Tag_Length:]
    ciphertext = ciphertext[PackagePwdConst.GCM_IV_Length:-PackagePwdConst.GCM_Tag_Length]
    # 创建AES-GCM解密器
    cipher = AES.new(secret_key, AES.MODE_GCM, nonce=iv)
    # 解密密文
    plaintext = cipher.decrypt_and_verify(ciphertext, tag)
    # 返回明文
    return unpad(plaintext, AES.block_size)



def get_main_model_id():
    from H_9U.mao.device_mao import device_api
    device_rs = device_api.read_detail(device_id=0)
    flag = False
    if device_rs['status'] == 0 and device_rs['data']:
        main_model_id = device_rs['data']['modelId']
        if main_model_id in DeviceType.P_Main_All:
             flag = True
        else:
            flag = False
    return flag


def cheng():
    password = "password12345"
    password1 = generate_password_hash(password, method="pbkdf2:sha256:10000", salt_length=16)
    print("password1 ===", password1)
    flag = check_password_hash(password1, password)
    print("flag ===", flag)







if __name__ == '__main__':
    # str2 = "gAN9cQAoWAIAAABpZHEBSwlYAwAAAGtleXECWCAAAAA5YTYwMTM3ZTMxZWVlYzI0YjU3N2JhN2MwMmY1ZDllZnEDWAQAAAB0aW1lcQRHQdiR#zMOZQR1Lg**"
    # str1 = string_substitution(str2)
    # print(str1)
    cheng()
    # print(valid_dict_value(
    #     {
    #         'deviceId': 10,
    #         'layers': [
    #             {
    #                 'layerId': 1000,
    #                 'name': '啊手动阀手动'
    #             }
    #         ]
    #     }
    # ))


