"""
Created on 2019年6月28日
@author: 第三方
对文件的常用操作
"""

import os
from H_9U.util.log import logger


# 字节bytes转化kb\m\g
def format_size(bts):
    try:
        bts = float(bts)
        kb = bts / 1024
    except:
        print("传入的字节格式不对")
        return "Error"

    if kb >= 1024:
        M = kb / 1024
        if M >= 1024:
            G = M / 1024
            return "%fG" % (G)
        else:
            return "%fM" % (M)
    else:
        return "%fKB" % (kb)


# 获取文件大小
# 返回2个值[格式化后文本、数字型/字节]
def get_doc_size(path):
    try:
        size = os.path.getsize(path)
        return format_size(size),size
    except Exception as err:
        print(err)

# 获取文件夹大小
def get_file_size(path):
    sumsize = 0
    try:
        filename = os.walk(path)
        for root, dirs, files in filename:
            for fle in files:
                size = os.path.getsize(path + fle)
                sumsize += size
        return format_size(sumsize)
    except Exception as err:
        print(err)


def remove_file(path_name):
    """
    删除文件
    :param path_name: 文件路径
    :return: None
    """
    if os.path.exists(path_name):
        try:
            os.remove(path_name)
        except Exception as e:
            logger.debug("欲删除的文件异常!%s" % path_name + str(e))
    else:
        logger.debug("欲删除的文件不存在!pathName:%s" % path_name)


def rename_file(path_name, new_name):
    """
    修改文件名称.
    :param path_name: 文件路径+文件名称(绝对路径);
    :param new_name: 名称，不包括扩展名(如：.jpg);
    :return: True-成功;False-失败.
    """
    if path_name is None or new_name is None:
        logger.error("修改文件名称-失败：pathName、newName不可为空!");
        return False;
    
    # 从pathName获得路径部分
    path = os.path.dirname(path_name);
    
    # 从pathName获得名称部分,含义扩展名，如：bkg1.jpg
    file_name = os.path.basename(path_name);
    ext_name = file_name.split('.')[1]; # 扩展名，如：.jpg

    if file_name != new_name:
        try:
            os.rename(path_name, path + "/" + new_name + "." + ext_name);
            return True;
        except FileExistsError:
            logger.info("同名文件已经存在!");
            return False;
        except IOError:
            logger.info("文件不存在!");
            return False;
    else:
        logger.info("文件名称一样,无需再改!");
    
    return False


def list_all_file(path):
    """
    列出目录下所有文件
    :param path: 目标路径
    :return: 数组list
    """
    if os.path.isdir(path) and os.path.exists(path):
        contents = os.listdir(path)
        files = []
        for f in contents:
            if os.path.isfile(os.path.join(path, f)):
                files.append(f)
        return files


def getdirsize(dir):
    size = 0
    for root, dirs, files in os.walk(dir):
        print(files)
        size += sum([os.path.getsize(os.path.join(root, name)) for name in files])
    return size


