
import threading
import time

class HidoTimer(threading.Thread):
    def __init__(self, interval, function, args=None, kwargs=None):
        threading.Thread.__init__(self)
        self.interval = interval
        self.function = function
        self.args = args if args is not None else []
        self.kwargs = kwargs if kwargs is not None else {}

    def wait(self):
        time.sleep(self.interval)

    def run(self):
        self.wait()
        self.function(*self.args, **self.kwargs)


