from flask import g
from H_9U.models.sysconst import DataType, UserRoleType
from H_9U.service.user import usersvc
from H_9U.service.role import rolesvc
from H_9U.models.result import get_result_model, ResInfo
from H_9U.util.common import is_contain


def valid_function_permission(code, data_type, data_id):
    """
    校验权限
    :param code: code
    :param data_type: data_type
    :param data_id: data_id
    :return: 结果数据
    """
    user = g.user
    role_id = user['roleId']
    # 如果是超级管理员角色则授予全部权限
    rs = rolesvc.get_role_by_id(role_id)
    if rs['status'] == 0 and rs['data']:
        if rs['data']['role_type'] == UserRoleType.Admin_Role:
            return get_result_model()
    # 获取当前用户拥有的菜单权限 code值列表
    code_list = get_menu_code_list(role_id)
    print("code_list = ", code_list)
    if len(code_list) == 0:
        return get_result_model(ResInfo.Role_Jurisdiction_Code)
    # 如果有功能权限的菜单,则继续
    if code not in code_list:
        return get_result_model(ResInfo.Role_Jurisdiction_Code)
    # 在判断该数据是否拥有
    permission_data_id_list = get_data_id_list(data_type, role_id)
    if len(permission_data_id_list) == 0:
        return get_result_model(ResInfo.Role_Jurisdiction_Code)
    data_id_list = []
    if data_type == DataType.Input_Type:
        from H_9U.api.input import get_slot_by_input_id
        data_id_list = get_slot_by_input_id(data_id)
    if data_type == DataType.Output_Type:
        from H_9U.api.output import get_slot_by_output_id
        data_id_list = get_slot_by_output_id(data_id)
    if data_type == DataType.Screen_Type:
        data_id_list = data_id
    # 判断 该用户拥有的权限集合 是否包含传递的数据id集合,如果包含,则返回true ,否则返回无权限
    contain = is_contain(permission_data_id_list, data_id_list)
    if contain:
        return get_result_model()
    return get_result_model(ResInfo.Role_Jurisdiction_Code)


def get_menu_code_list(role_id):
    """
    获取所有菜单权限的code值列表
    :param role_id: role_id
    :return: 结果数据
    """
    user_rs = usersvc.get_with_func(role_id)
    code_list = []
    if user_rs['status'] == 0:
        funcs = user_rs['data']
        code_list = [x['code'] for x in funcs]
    return code_list


def get_data_id_list(data_type, role_id):
    """
    获取所有数据权限的id值列表
    :param data_type: data_type
    :param role_id: role_id
    :return: 结果数据
    """
    permission_data_id_list = []
    if data_type == DataType.Input_Type:
        input_data_rs = rolesvc.get_input_by_role_id(role_id)
        permission_data_id_list = [x['inputId'] for x in input_data_rs['data']
                                   if input_data_rs['status'] == 0 and input_data_rs['data']]
    if data_type == DataType.Output_Type:
        output_data_rs = rolesvc.get_output_by_role_id(role_id)
        permission_data_id_list = [x['outputId'] for x in output_data_rs['data']
                                   if output_data_rs['status'] == 0 and output_data_rs['data']]
    if data_type == DataType.Screen_Type:
        screen_data_rs = rolesvc.get_screen_by_role_id(role_id)
        permission_data_id_list = [x['screenId'] for x in screen_data_rs['data']
                                   if screen_data_rs['status'] == 0 and screen_data_rs['data']]
    if data_type == DataType.Mvr_Type:
        mvr_data_rs = rolesvc.get_mvr_by_role_id(role_id)
        permission_data_id_list = [x['mvrId'] for x in mvr_data_rs['data']
                                   if mvr_data_rs['status'] == 0 and mvr_data_rs['data']]

    return permission_data_id_list


def valid_permission_role_user(code, data_type, id_list):
    """
    校验角色用户权限
    :param code: code
    :param data_type: data_type
    :param id_list: id_list
    :return: 结果数据
    """
    user = g.user
    role_id = user['roleId']
    # 如果是超级管理员角色则授予全部权限
    rs = rolesvc.get_role_by_id(role_id)
    if rs['status'] == 0 and rs['data']:
        if rs['data']['role_type'] == UserRoleType.Admin_Role:
            return get_result_model()
    # 获取当前用户拥有的菜单权限 code值列表
    code_list = get_menu_code_list(role_id)
    if len(code_list) == 0:
        return get_result_model(ResInfo.Role_Jurisdiction_Code)
    # 如果有功能权限的菜单,则继续
    if code not in code_list:
        return get_result_model(ResInfo.Role_Jurisdiction_Code)
    permission_id_list = get_role_user_id_list(data_type, role_id)
    if len(permission_id_list) == 0:
        return get_result_model(ResInfo.Role_Jurisdiction_Code)
    # 判断 该用户拥有的权限集合 是否包含传递的数据id集合,如果包含,则返回true ,否则返回无权限
    contain = is_contain(permission_id_list, id_list)
    if contain:
        return get_result_model()
    return get_result_model(ResInfo.Role_Jurisdiction_Code)


def get_code_list(code, role_id):
    """
    校验该角色拥有的功能权限
    :param code: code
    :param role_id: role_id
    :return: 结果数据
    """
    rs = rolesvc.get_role_by_id(role_id)
    if rs['status'] != 0 or not rs['data']:
        return get_result_model(ResInfo.Role_Jurisdiction_Code)
    if rs['data']['role_type'] == UserRoleType.Admin_Role:
        return get_result_model()
    code_list = get_menu_code_list(role_id)
    if len(code_list) == 0:
        return get_result_model(ResInfo.Role_Jurisdiction_Code)
    # 如果有功能权限的菜单,则继续
    if code not in code_list:
        return get_result_model(ResInfo.Role_Jurisdiction_Code)
    return get_result_model()


def get_role_user_id_list(data_type, role_id):
    """
    校验角色or用户权限
    :param data_type: data_type 6. user 7. role
    :param role_id: role_id
    :return: 结果数据
    """
    permission_id_list = []
    if data_type == DataType.User_Type:
        # 获取当前角色拥有的用户id集合
        user_rs = usersvc.get_user_by_role_id(role_id)
        if user_rs['status'] == 0 and user_rs['data']:
            permission_id_list = [x['id'] for x in user_rs['data']]
    if data_type == DataType.Role_Type:
        # 获取当前角色拥有的角色id集合
        role_rs = rolesvc.get_role_message(role_id)
        if role_rs['status'] == 0 and role_rs['data']:
            permission_id_list = [x['id'] for x in role_rs['data']]

    return permission_id_list
