"""
Created on 2022年3月24日
@author: 程声清
公用方法，正则校验
"""
import re


def regular_check_phone(phone):
    """
    校验手机号是否合法
    :param phone: 手机号
    :return:
    """
    res = re.match(r"^\d[\s\d-]{3,20}$", phone)
    if not res:
        return False
    else:
        return True


def regular_check_email(user_email):
    """
     校验邮箱是否合法
    :param user_email: 邮箱号
    :return:
    """
    res = re.match(
        r'^[0-9a-zA-Z_-]{1,19}@[0-9a-zA-Z_-]{1,13}\.[a-zA-Z]{1,8}$',
        user_email)
    if not res:
        return False
    else:
        return True

def regular_check_username(user_name):
    """
     校验用户名称是否合法
    :param user_email: 邮箱号
    :return:
    """
    res = re.match( r'^[\dA-Za-z0-9]{4,15}$', user_name)
    if not res:
        return False
    else:
        return True

def regular_check_rolename(role_name):
    """
     校验角色名称是否合法
    :param user_email: 邮箱号
    :return:
    """
    res = re.match( r'^[~@#$%^&*!,.{}`?_<>'";/|\\[\]-]|[！￥…（）—｛｝【】‘’“”；：。，、？];'", role_name)
    if not res:
        return False
    else:
        return True

def regular_check_password(password):
    """
     校验用户密码是否合法
    :param user_email: 邮箱号
    :return:
    """
    res = re.match( r'^[\dA-Za-z0-9]{5,20}$', password)
    if not res:
        return False
    else:
        return True


def regular_check_first_subnetMask(subnetMask):
    """
     校验子网掩码第一位是否合法
    :param user_email: 邮箱号
    :return:
    """
    res = re.match( r'^(254|252|248|240|224|192|128|0)\.0\.0\.0$', subnetMask)
    if not res:
        return False
    else:
        return True

def regular_check_two_subnetMask(subnetMask):
    """
     校验子网掩码第二位是否合法
    :param user_email: 邮箱号
    :return:
    """
    res = re.match( r'^255\.(254|252|248|240|224|192|128|0)\.0\.0$', subnetMask)
    if not res:
        return False
    else:
        return True

def regular_check_three_subnetMask(subnetMask):
    """
     校验子网掩码第三位是否合法
    :param user_email: 邮箱号
    :return:
    """
    res = re.match( r'^255\.255\.(254|252|248|240|224|192|128|0)\.0$', subnetMask)
    if not res:
        return False
    else:
        return True

def regular_check_four_subnetMask(subnetMask):
    """
     校验子网掩码第四位是否合法
    :param user_email: 邮箱号
    :return:
    """
    res = re.match( r'^255\.255\.255\.(254|252|248|240|224|192|128|0)$', subnetMask)
    if not res:
        return False
    else:
        return True


def regular_check_ipc_source_ip(source_ip):
    """
     校验子网掩码第四位是否合法
    :param user_email: 邮箱号
    :return:
    """
    res = re.match( r'^(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)$', source_ip)
    if not res:
        return False
    else:
        return True

def regular_check_ipc_source_port(source_port):
    """
     校验子网掩码第四位是否合法
    :param user_email: 邮箱号
    :return:
    """
    res = re.match( r'^([1-9]\d{0,3}|[1-5]\d{4}|6[0-4]\d{3}|65[0-4]\d{2}|655[0-2]\d|6553[0-5])$', source_port)
    if not res:
        return False
    else:
        return True

def regular_check_ipc_rtsp_addr(rtsp_addr):
    """
     校验子网掩码第四位是否合法
    :param user_email: 邮箱号
    :return:
    """
    res = re.match( r'^rtsp:\/\/([\w.]+\/?)\S*', rtsp_addr)
    if not res:
        return False
    else:
        return True


def regular_check_first_place_ip(ip):
    """
     校验ip首位是否合法
    :param user_email: 邮箱号
    :return:
    """
    res = re.match( r'^(2[0-4]\d|25[0-5]|[01]?\d\d?)$', ip)
    if not res:
        return False
    else:
        return True

def regular_check_last_three_place_ip(ip):
    """
     校验ip后三位是否合法
    :param user_email: 邮箱号
    :return:
    """
    res = re.match( r'^(2[0-1]\d|22[0-3]|[01]?\d\d?)$', ip)
    if not res:
        return False
    else:
        return True


if __name__ == '__main__':
    # text1 = "123"
    email = "chengsq@novastar.acccccccc"
    if regular_check_email(email):
        print("pass")
    else:
        print("fail")
    # if regular_check_phone(text1):
    #     print("pass")
    # else:
    #     print("fail")
