"""
@Project ：h_series 
@File    ：verification_code.py
@IDE     ：PyCharm 
@Author  ：程声清
@Date    ：2023/5/4 14:41 
"""

import random
import string
from PIL import Image, ImageDraw, ImageFont, ImageFilter
import base64
from io import BytesIO


def get_text(number):
    """
    随机生成字符串
    :param number: int
    :return:
    """
    source = string.digits + string.ascii_uppercase
    return ''.join(random.sample(source, number))


def draw_line(draw, size, color, num):
    """
    画干扰线
    :param draw:
    :param size: 图片大小,(width, height)
    :param linecolor: 干扰线颜色
    :param num: 干扰线的数量
    :return:
    """
    for i in range(num):
        begin = (random.randint(0, size[0] / 4), random.randint(0, size[1] / 2))
        end = (random.randint(size[0] / 2, size[0]), random.randint(0, size[1]))
        draw.line([begin, end], fill=color, width=2)


def draw_image(size, number, fontcolor='#0000FF', groundcolor='#FFFFFF'):
    """
    生成图片
    :param size: 大小,(width, height)
    :param number: 文字数量
    :param groundcolor: 背景色
    :return:
    """
    from H_9U.util.code2 import create_verification
    return create_verification()


if __name__ == '__main__':
    size = (110, 50)

    print(draw_image(size, 4))

