#!/bin/sh

if [ -f /usr/Hseries/bin/log.sh ]; then
	. /usr/Hseries/bin/log.sh
else 
	log_info()
	{
		echo "$@" >> /usr/Hseries/bin/Middleware/log/shell.log
	}
	log_debug()
	{
		echo "$@" >> /usr/Hseries/bin/Middleware/log/shell.log
	}
	log_error()
	{
		echo "$@" >> /usr/Hseries/bin/Middleware/log/shell.log
	}
fi

if [ -f /usr/Hseries/bin/setmode.sh ]; then
	. /usr/Hseries/bin/setmode.sh
else 
	setmode()
	{
		echo "setmode do nothing" >> /usr/Hseries/bin/Middleware/log/shell.log
	}
fi

log_info "run Hseries-run.sh"

resize2fs /dev/mmcblk0p7

ulimit -c unlimited
ulimit -d unlimited

#if [ -d "/usr/Hseries/bin/Middleware/coreDump" ]; then
#	cd /usr/Hseries/bin/Middleware && rm coreDump -rf
#fi

sleep 5
export DISPLAY=":0.0" && /usr/bin/xset dpms 0 0 0
export DISPLAY=":0.0" && /usr/bin/xset s off
export DISPLAY=":0.0" && /usr/bin/xset -dpms

log_info "xset config dpms"
log_info "$(/usr/bin/xset -q 2>&1)"

echo off > /sys/class/drm/card0-HDMI-A-1/status

if [ `fc-list | grep NotoSansHans-Regular.otf | wc -l` = "0" ];then
    /usr/bin/fc-cache
    log_info "/usr/bin/fc-cache"
fi

start_Middleware()
{
	#run MasterProcess
	device_type=`cat /proc/chassis_info/model_id`

	if [ ! -d "/usr/Hseries/bin/Middleware/data" ]; then
		mkdir /usr/Hseries/bin/Middleware/data
    fi

	if [ $device_type = "2" ]; then
		#reset crosspoint chip
		echo "14" "1" > /sys/devices/platform/multi_iocfg.0/multi_iocfg/reset
		#aux UART
		echo 12 > /sys/devices/platform/uart_com.0/uart_com/uart_chl_sel
		sleep 1

		if [ -f "/usr/Hseries/bin/Middleware/alita_series" ]; then
			cd /usr/Hseries/bin/Middleware && ./MasterProcess_Alita_5U &
			log_info "run MasterProcess_Alita_5U"
		else
			cd /usr/Hseries/bin/Middleware && ./MasterProcess_H5 &
			log_info "run MasterProcess_H5"
		fi
	elif [ $device_type = "3" ]; then
		#reset crosspoint chip
		echo "21" "1" > /sys/devices/platform/multi_iocfg.0/multi_iocfg/reset
		#aux UART
		echo 22 > /sys/devices/platform/uart_com.0/uart_com/uart_chl_sel
		sleep 1

		cd /usr/Hseries/bin/Middleware && ./MasterProcess_H9_10X5 &
	    log_info "run MasterProcess_H9_10X5"
	elif [ $device_type = "4" ]; then
		#reset crosspoint chip
		echo "21" "1" > /sys/devices/platform/multi_iocfg.0/multi_iocfg/reset
		#aux UART
		echo 22 > /sys/devices/platform/uart_com.0/uart_com/uart_chl_sel
		sleep 1

		if [ -f "/usr/Hseries/bin/Middleware/alita_series" ]; then
			cd /usr/Hseries/bin/Middleware && ./MasterProcess_Alita_2U &
	    	log_info "run MasterProcess_Alita_2U"
		else
			cd /usr/Hseries/bin/Middleware && ./MasterProcess_H2 &
	    	log_info "run MasterProcess_H2"
		fi
	elif [ $device_type = "5" ]; then
		#reset crosspoint chip  GPIO6_C0
		echo 1200 > /sys/class/gpio/export
		echo out > /sys/class/gpio/gpio1200/direction
		echo 0 > /sys/class/gpio/gpio1200/value
		sleep 0.5
		echo 1 > /sys/class/gpio/gpio1200/value
		#open mos   GPIO6_C3
		echo 1203 > /sys/class/gpio/export
		echo out > /sys/class/gpio/gpio1203/direction
		echo 0 > /sys/class/gpio/gpio1203/value
		
		#open 245 OE   GPIO6_A3
		echo 1187 > /sys/class/gpio/export
		echo out > /sys/class/gpio/gpio1187/direction
		echo 0 > /sys/class/gpio/gpio1187/value
		
		#GPIO0_B3 POWER1_Present
		echo 1011 > /sys/class/gpio/export
		echo in > /sys/class/gpio/gpio1011/direction
		#GPIO0_B4 POWER2_Present
		echo 1012 > /sys/class/gpio/export
		echo in > /sys/class/gpio/gpio1012/direction
		#GPIO0_A1 POWER3_Present
		echo 1001 > /sys/class/gpio/export
		echo in > /sys/class/gpio/gpio1001/direction
		#GPIO0_C1 POWER4_Present
		echo 1017 > /sys/class/gpio/export
		echo in > /sys/class/gpio/gpio1017/direction

        #aux UART
        echo 1 > /sys/devices/platform/uart_com.0/uart_com/uart_chl_sel
        sleep 1

		if [ -f "/usr/Hseries/bin/Middleware/alita_series" ]; then
			cd /usr/Hseries/bin/Middleware && ./MasterProcess_Alita_15U &
			log_info "run MasterProcess_Alita_15U"
		else
			cd /usr/Hseries/bin/Middleware && ./MasterProcess_H15 &
			log_info "run MasterProcess_H15"
		fi

	elif [ $device_type = "6" ]; then
		#reset crosspoint chip  GPIO6_C0
		echo 1200 > /sys/class/gpio/export
		echo out > /sys/class/gpio/gpio1200/direction
		echo 0 > /sys/class/gpio/gpio1200/value
		sleep 0.5
		echo 1 > /sys/class/gpio/gpio1200/value
		#open mos   GPIO6_C3
		echo 1203 > /sys/class/gpio/export
		echo out > /sys/class/gpio/gpio1203/direction
		echo 0 > /sys/class/gpio/gpio1203/value
		
		#open 245 OE   GPIO6_A3
		echo 1187 > /sys/class/gpio/export
		echo out > /sys/class/gpio/gpio1187/direction
		echo 0 > /sys/class/gpio/gpio1187/value
		
		#GPIO0_B3 POWER1_Present
		echo 1011 > /sys/class/gpio/export
		echo in > /sys/class/gpio/gpio1011/direction
		#GPIO0_B4 POWER2_Present
		echo 1012 > /sys/class/gpio/export
		echo in > /sys/class/gpio/gpio1012/direction
		#GPIO0_A1 POWER3_Present
		echo 1001 > /sys/class/gpio/export
		echo in > /sys/class/gpio/gpio1001/direction
		#GPIO0_C1 POWER4_Present
		echo 1017 > /sys/class/gpio/export
		echo in > /sys/class/gpio/gpio1017/direction
		
        #aux UART
        echo 1 > /sys/devices/platform/uart_com.0/uart_com/uart_chl_sel
        sleep 1
		cd /usr/Hseries/bin/Middleware && ./MasterProcess_H15_Pro &
		log_info "run MasterProcess_H15_Pro"
	elif [ $device_type = "7" ]; then
		#BackBoard RST GPIO7_A4_d
		echo 1220 > /sys/class/gpio/export
		echo out > /sys/class/gpio/gpio1220/direction
		echo 1 > /sys/class/gpio/gpio1220/value

		#CP1 SWITCH EN GPIO2_A6_d
		echo 1062 > /sys/class/gpio/export
		echo out > /sys/class/gpio/gpio1062/direction
		echo 0 > /sys/class/gpio/gpio1062/value

		#CP2 SWITCH EN GPIO7_A3_d
		echo 1219 > /sys/class/gpio/export
		echo out > /sys/class/gpio/gpio1219/direction
		echo 0 > /sys/class/gpio/gpio1219/value

		#reset crosspoint chip  GPIO6_C0
		echo 1200 > /sys/class/gpio/export
		echo out > /sys/class/gpio/gpio1200/direction
		echo 0 > /sys/class/gpio/gpio1200/value
		sleep 0.5
		echo 1 > /sys/class/gpio/gpio1200/value

		#reset crosspoint chip2  GPIO2_A5_d
		echo 1061 > /sys/class/gpio/export
		echo out > /sys/class/gpio/gpio1061/direction
		echo 1 > /sys/class/gpio/gpio1061/value
		sleep 0.5
		echo 0 > /sys/class/gpio/gpio1061/value
		sleep 0.5
		echo 1 > /sys/class/gpio/gpio1061/value

		#open mos   GPIO6_C3
		echo 1203 > /sys/class/gpio/export
		echo out > /sys/class/gpio/gpio1203/direction
		echo 0 > /sys/class/gpio/gpio1203/value
		
		#open 245 OE   GPIO6_A3
		echo 1187 > /sys/class/gpio/export
		echo out > /sys/class/gpio/gpio1187/direction
		echo 0 > /sys/class/gpio/gpio1187/value

		#open 245 OE1   GPIO0_A3
		echo 1003 > /sys/class/gpio/export
		echo out > /sys/class/gpio/gpio1003/direction
		echo 0 > /sys/class/gpio/gpio1003/value
		
		#GPIO0_B3 POWER1_Present
		echo 1011 > /sys/class/gpio/export
		echo in > /sys/class/gpio/gpio1011/direction
		#GPIO0_B4 POWER2_Present
		echo 1012 > /sys/class/gpio/export
		echo in > /sys/class/gpio/gpio1012/direction
		#GPIO0_A1 POWER3_Present
		echo 1001 > /sys/class/gpio/export
		echo in > /sys/class/gpio/gpio1001/direction
		#GPIO0_C1 POWER4_Present
		echo 1017 > /sys/class/gpio/export
		echo in > /sys/class/gpio/gpio1017/direction
		
        #aux UART
        echo 1 > /sys/devices/platform/uart_com.0/uart_com/uart_chl_sel
        sleep 1
		
		if [ -f "/usr/Hseries/bin/Middleware/alita_series" ]; then
			cd /usr/Hseries/bin/Middleware && ./MasterProcess_Alita_20U &
			log_info "run MasterProcess_Alita_20U"
		else
			cd /usr/Hseries/bin/Middleware && ./MasterProcess_H20U &
			log_info "run MasterProcess_H20"
		fi
	else
		#reset crosspoint chip
		echo "21" "1" > /sys/devices/platform/multi_iocfg.0/multi_iocfg/reset
		#aux UART
		echo 22 > /sys/devices/platform/uart_com.0/uart_com/uart_chl_sel
		sleep 1

		if [ -f "/usr/Hseries/bin/Middleware/alita_series" ]; then
			cd /usr/Hseries/bin/Middleware && ./MasterProcess_Alita_9U &
			log_info "run MasterProcess_Alita_9U"
		else
			cd /usr/Hseries/bin/Middleware && ./MasterProcess_H9 &
	    	log_info "run MasterProcess_H9"
		fi
	fi
}
start_GUI()
{
	device_type=`cat /proc/chassis_info/model_id`
	log_info "start GUI, device type=${device_type}"
	if [ $device_type = "7" ]; then
		cd /usr/Hseries/bin/GUI && ./H9U_GUI h9&
	elif [ $device_type = "4" ]; then
		cd /usr/Hseries/bin/GUI && ./H9U_GUI_OTHER h2 -platform linuxfb:fb=/dev/fb1&
	else
		cd /usr/Hseries/bin/GUI && ./H9U_GUI_OTHER h9&
	fi
}

if [  -f /usr/Hseries/tmp/Data_CtrlCard/CtrlCardExec.sh ]; then
	echo 'start exec fw upgrade ...'
	. /usr/Hseries/tmp/Data_CtrlCard/CtrlCardExec.sh
	rm /usr/Hseries/tmp -rf
fi

if [ ! -d "/usr/Hseries/bin/Middleware/custom/" ];then
	mkdir /usr/Hseries/bin/Middleware/custom/
else
	echo "custom directory exist"
fi

if [ ! -d "/usr/Hseries/bin/Middleware/data/" ];then
	mkdir /usr/Hseries/bin/Middleware/data/
else
	echo "data directory exis"
fi

ifconfig eth1 up
route add -net 235.235.235.236 netmask 255.255.255.255 dev eth1

#aux UART
#echo 22 > /sys/devices/platform/uart_com.0/uart_com/uart_chl_sel

#aux IO it
echo 1248 > /sys/class/gpio/export

#lcd backlight
#echo 255 > /sys/class/backlight/backlight/brightness

#sleep 1
# cd /usr/f8/bin/ && ./f8plus-daemon.sh &
#sleep 1
#cd /usr/Hseries/bin/Middleware && ./MasterProcess &
start_Middleware
#sleep 1
setmode
start_GUI

cd /usr/Hseries/bin && sh Hseries-daemon.sh &

cd /usr/Hseries/bin/web/H_9U && gunicorn -b '0.0.0.0:8000' --worker-class eventlet --daemon -w 1 --timeout 1200 manage:app

if [ -f /usr/Hseries/bin/GUI/gui-run-status.sh ];then
    /usr/Hseries/bin/GUI/gui-run-status.sh &
fi

killall NetworkManager

#sleep 2
#chromium --kiosk  --window-position=1280,0 --no-sandbox 127.0.0.1 &
