#!/bin/sh
### BEGIN INIT INFO
# Provides:          init-task
# Required-Start:    
# Required-Stop:
# Default-Start:     5
# Default-Stop:
# Short-Description:  
### END INIT INFO

echo 0 > /sys/class/backlight/backlight/brightness

if [ -f /usr/Hseries/bin/log.sh ]; then
	. /usr/Hseries/bin/log.sh
else 
	log_info()
	{
		echo "$@" >> /usr/Hseries/bin/Middleware/log/shell.log
	}
	log_debug()
	{
		echo "$@" >> /usr/Hseries/bin/Middleware/log/shell.log
	}
	log_error()
	{
		echo "$@" >> /usr/Hseries/bin/Middleware/log/shell.log
	}
fi

if [ -f /usr/Hseries/bin/setmode.sh ]; then
	. /usr/Hseries/bin/setmode.sh
else 
	setmode()
	{
		echo "setmode do nothing" >> /usr/Hseries/bin/Middleware/log/shell.log
	}
fi

NOVA_DRIVER_PATH=/usr/nova/driver_nova
export LD_LIBRARY_PATH="/usr/lib/arm-linux-gnueabihf:/lib/arm-linux-gnueabihf:/usr/nova/lib:/usr/Hseries/lib/cJSON/lib:/usr/Hseries/lib/python3.6/lib"
export PATH="/bin:/sbin:/usr/bin:/usr/sbin:/usr/nova/bin:/usr/nova/sbin:/usr/Hseries/lib/python3.6/bin"
export QT_QPA_FONTDIR="/usr/share/fonts"
export QT_QPA_PLATFORM="xcb"
export QT_QPA_PLATFORM_PLUGIN_PATH="/usr/lib/arm-linux-gnueabihf/qt5/plugins/platforms"
#export SDL_FBDEV='/dev/fb4'
export SDL_NOMOUSE="1"
#unset QT_QPA_GENERIC_PLUGINS
unset LD_PRELOAD
export DISPLAY=":0.0"
export HOME="/root"

export QT_PLUGIN_PATH="/usr/lib/arm-linux-gnueabihf/qt5/plugins"
export XAUTHORITY="/home/linaro/.Xauthority"

DATE=$(/bin/date "+%Y-%m-%d %H:%M:%S")

log_info "init-task.sh $1"

if [ $1 != "start" ]; then
	log_info "init-task don't run"
	exit 0
fi

if [ -f /mnt/sda1/init-debug.sh ]; then 
	/mnt/sda1/init-debug.sh
	exit 0
fi

xorg_verify()
{
	log_info "xorg_verify"
	if [ -f "/etc/rc5.d/S05automode" ]; then
		log_info "rm -rf /etc/rc5.d/S05automode"
		rm -rf /etc/rc5.d/S05automode
	fi
	
	if [ -f "/etc/init.d/automode" ]; then
		log_info "rm -rf /etc/init.d/automode"
		rm -rf /etc/init.d/automode
	fi
	
	#disable lightdm service
	result=$(systemctl is-enabled lightdm)
	log_info "lightdm service status=${result}"
	if [ ${result} = "enabled" ]; then
		log_info "disable lightdm service"
		systemctl stop lightdm
		systemctl disable lightdm
	fi
	
	if [ -f "/etc/rc5.d/S02init-task.sh" ]; then
		log_info "mv /etc/rc5.d/S02init-task.sh /etc/rc5.d/S99init-task.sh"
		mv /etc/rc5.d/S02init-task.sh /etc/rc5.d/S99init-task.sh
	fi
}

check_fpga_load()
{
    cnt_min=1
    cnt_max=10
    while [ $cnt_min -lt $cnt_max ];
    do
        fpgacfg0=$(/bin/cat /proc/fpga_cfg0/cfg_result)
        fpgacfg1=$(/bin/cat /proc/fpga_cfg1/cfg_result)
        if [ $fpgacfg0 = "0" ] && [ $fpgacfg1 = "0" ]; then
                echo "fpga config ok!"
				/usr/nova/sbin/fpga_load a /usr/nova/etc/fpga/C3fpgaTop.bin
				sleep 4
                break
        fi
        sleep 1
        cnt_min=`expr $cnt_min + 1`
    done
    if [ $cnt_min -eq $cnt_max ]; then
        echo "fpga config error!"
    fi

}

start_wifi()
{
    wifi_enable=`/usr/nova/bin/sysconfig get wifi_enable`
    if [ $wifi_enable -eq 1 ]; then
       if [ ! -f /etc/wpa_supplicant.conf ];then
           echo "ctrl_interface=/var/run/wpa_supplicant" >/etc/wpa_supplicant.conf
           echo "update_config=1" >>/etc/wpa_supplicant.conf
       fi
       killall -9 /sbin/wpa_supplicant >/dev/null 2>&1
       /sbin/wpa_supplicant -D nl80211 -i wlan0 -c /etc/wpa_supplicant.conf -B
    fi
}

start_ap()
{
    ap_enable=`/usr/nova/bin/sysconfig get ap_enable`
    ap_essid=`/usr/nova/bin/sysconfig get ap_ssid`
    ap_pass=`/usr/nova/bin/sysconfig get ap_pass`
    ap_name=`/sbin/iwconfig 2> /dev/null |grep wlx|cut -c 1-15`
    if [ $ap_enable -eq 1 ]; then
        killall -9 create_ap
        echo "/usr/bin/create_ap --daemon $ap_name eth0 $ap_essid $ap_pass"
        /usr/bin/create_ap --daemon $ap_name eth0 $ap_essid $ap_pass --no-virt
    fi
}

check_eth()
{
	eth=$1
	#ethstate=`ifconfig $eth`
	ethstate=`ifconfig $eth|grep 'inet'|grep -v 'inet6' | awk '{print $2}'`
	echo $ethstate
	if [ ! $ethstate ];then
		if [ ! -f "/usr/Hseries/bin/record_eth1_error" ];then
			echo "The first check eth1 fail,system reboot" >> /usr/Hseries/bin/daemon.log
			touch /usr/Hseries/bin/record_eth1_error
			sync
			echo "check eth1 fail,system reboot"
			sleep 1
			reboot -f
		else
			echo "The second check eth1 fail,system run" >> /usr/Hseries/bin/daemon.log
			rm -f /usr/Hseries/bin/record_eth1_error
			echo "check eth1 fail,system run..."
		fi
	else
		if [ -f "/usr/Hseries/bin/record_eth1_error" ];then
			rm -f /usr/Hseries/bin/record_eth1_error
			sync
		fi
		echo "Check eth1 sucess,system run..."
	fi
}

set_local_ip()
{
	log_info "set_local_ip $1"
#   mode=$(grep "iface eth0" /etc/network/interfaces | awk '{print $4}' )
	eth=$1
	ethmode=0
	ipaddr=
	netmask=
	gateway=
	ethmode=`/usr/nova/bin/sysconfig get ethmode_$eth`
	if [ $ethmode -eq 1 ];then   #dhcp
		killall -9 dhclient
		ip addr flush dev $eth
		dhclient -i $eth
		ipaddr=`ifconfig $eth|grep "inet"|grep -v "inet6" | awk '{print $2}'`
		netmask=`ifconfig $eth|grep "inet"|grep -v "inet6" | awk '{print $4}'`
		if [ ! $ipaddr ];then
			ipaddr=192.168.0.10
		fi
		if [ ! $netmask ];then
			netmask=255.255.255.0
		fi
		/usr/nova/bin/sysconfig set ipaddr_$eth $ipaddr
		/usr/nova/bin/sysconfig set  netmask_$eth $netmask
		ifconfig $eth $ipaddr netmask $netmask
		gateway=${ipaddr%.*}'.1'
		/usr/nova/bin/sysconfig set  gateway_$eth $gateway
	else	
	#if [ $ethmode -eq 0 ];then   #static 
		ipaddr=`/usr/nova/bin/sysconfig get ipaddr_$eth`
		netmask=`/usr/nova/bin/sysconfig get netmask_$eth`
		gateway=`/usr/nova/bin/sysconfig get gateway_$eth`
		ifconfig $eth up
		if [ "$ipaddr" = '(null)' ];then
			ipaddr=192.168.0.10
		fi
		if [ "$netmask" = '(null)' ];then
			netmask=255.255.255.0
		fi
		if [ "$gateway" = '(null)' ];then
			gateway=192.168.0.1
		fi
		ifconfig $eth $ipaddr netmask $netmask
		route del default gw $gateway
		route add default gw $gateway
	fi

}

set_local_mac()
{
	log_info "set_local_mac $1"
	eth=$1
	mac=`/usr/nova/bin/sysconfig get ctrlcard_mac`
	if [ -n "$mac" ] && [ -n "$eth" ];then
		ifconfig $eth down
		ifconfig $eth hw ether $mac
		ifconfig $eth up
	fi
}

set_hwclock()
{
	log_info "set_hwclock"
	if [ -e /dev/rtc1 ];then
		ln -sf /dev/rtc1 /dev/rtc
	fi
	log_info "set_hwclock sleep 2"
	sleep 2
	
	log_info "/sbin/hwclock --hctosys"
	
	/sbin/hwclock --hctosys

	time=`date +%Y-%m-%d`
	if [[ "$time" > "2036-01-01" ]]; then
		date -s "2000-1-1 00:00:00"
		/sbin/hwclock -w
		log_info "recovery hwclock to 2000-1-1 00:00:00"
	fi
}

start_rtsp_launch()
{
	sh /usr/local/bin/hdmiin_enable.sh 
	# 1920x1080
	/usr/nova/bin/rtsp_launch_1920x1080_start &
	/usr/nova/bin/rtsp_launch_1920x1080_relay &
}

check_fwversion()
{
	#������fpga_a�汾
	version_pgm=`/usr/nova/bin/fpga v a |grep Version |cut -c 18-`
	if [ $version_pgm ]; then
	        /usr/nova/bin/sysconfig set pgm_version $version_pgm
	fi

	#������fpga_b�汾
	version_pvw=`/usr/nova/bin/fpga v b |grep Version |cut -c 18-`
	if [ $version_pvw ]; then
	        /usr/nova/bin/sysconfig set pvw_version $version_pvw
	fi

	##������mcu�汾
	version_mcu=`/usr/nova/bin/stm32 -v|grep "stm32"|awk '{print $5 $4}'|tr -d "ver:"|tr -d ",full"`
	if [ $version_mcu ]; then
	       /usr/nova/bin/sysconfig set mcu_version $version_mcu
	fi
	
	#���뿨fpga�汾
	version_incard_fpga=`/usr/nova/bin/slot vp |grep Compiled |cut -c 15-`
	if [ $version_incard_fpga ]; then
		/usr/nova/bin/sysconfig set incard_fpga_version $version_incard_fpga
	fi
}

start_uhdtask()
{
    #use xrandr add scerrn mode
    #/etc/init.d/xrandr-screen.sh

    echo on >/sys/class/drm/card0-HDMI-A-1/status 
	
    /usr/nova/sbin/tmd -d &
    /usr/nova/bin/imd_down -d -l &
    /usr/nova/bin/imd_up -d -l &
    /usr/nova/bin/imdu -d -l &    
    /usr/nova/bin/upgd &
    #/usr/nova/bin/watchdog &
    echo on >/sys/class/drm/card0-HDMI-A-1/status
    #mpv --vo=drm --drm-connector=HDMI-A-1 /usr/nova/icons/test.mp4  --drm-mode=0  --fullscreen --no-audio --loop &
    #/usr/bin/mpv --hwdec=rkmpp --vo=gpu --gpu-api=opengl --no-audio --gpu-context=drm --drm-connector=HDMI-A-1 --drm-mode=1 /usr/local/test.mp4 -v &
    sleep 1
    if [ ! -f /usr/nova/etc/sysconf/uhdpara ]; then
        dd if=/dev/zero of=/usr/nova/etc/sysconf/uhdpara bs=1G count=4
    fi
    /usr/nova/bin/videod &
    /usr/nova/bin/senderd &

    /bin/cp /home/linaro/.Xauthority /root/ -rf    
    export  DISPLAY=":0.0" && /home/novastar/Desktop/vsp/bin/vspd &
    #/usr/nova/bin/watchdog &
    sleep 3
    insmod ${NOVA_DRIVER_PATH}/nova-uhd-fbtft.ko gpios=reset:1071,dc:1061 rotate=90
    /usr/nova/bin/lsd -platform linuxfb:fb=/dev/fb1 &

    export  DISPLAY=":0.0" && /usr/bin/xset dpms 0 0 0
    export  DISPLAY=":0.0" && /usr/bin/xset s off
    export  DISPLAY=":0.0" && /usr/bin/xset -dpms
}

xorg_check_ready()
{
	cnt_min=1
    cnt_max=3
	while [ $cnt_min -lt $cnt_max ];
    do
		val=`ps -ef|grep org|awk '{print $8}'|sed -n '1p'`
		if [ $val != "/usr/lib/xorg/Xorg" ]
		then
			/usr/lib/xorg/Xorg :0 -seat seat0 -auth /var/run/lightdm/root/:0 -nolisten tcp vt7 -novtswitch &
			export  DISPLAY=":0.0" && /usr/bin/pcmanfm --desktop --profile LXDE &
			sleep 1
		else
			echo "xorg start OK!"
            break
		fi
        cnt_min=`expr $cnt_min + 1`
    done
    if [ $cnt_min -eq $cnt_max ]; then
        echo "xorg start failed!"
    fi
}

start_c3task()
{
	echo on > /sys/class/drm/card0-HDMI-A-1/status

	sleep 1
	export  DISPLAY=":0.0" && /usr/bin/xset dpms 0 0 0
	export  DISPLAY=":0.0" && /usr/bin/xset s off
	export  DISPLAY=":0.0" && /usr/bin/xset -dpms

	xrandr --newmode "3840x1080_60.00"  346.00  3840 4088 4496 5152  1080 1083 1093 1120 -hsync +vsync
	xrandr --addmode HDMI-1 3840x1080_60.00
	xrandr --output HDMI-1 --mode 3840x1080_60.00
	xrandr --output HDMI-1 --right-of LVDS-1

	xinput map-to-output 6 LVDS-1
	xinput map-to-output 7 LVDS-1
	xinput map-to-output 8 HDMI-1
	xinput map-to-output 9 HDMI-1

	#TC358743 hpd
	echo 1251 > /sys/class/gpio/export
	echo out > /sys/class/gpio/gpio1251/direction
	echo 1 > /sys/class/gpio/gpio1251/value

	sleep 3

	chmod +x /usr/c3/etc/triton/run_triton.sh
	/usr/c3/etc/triton/run_triton.sh
	/usr/bin/openbox.bak &
	sleep 15
	/usr/local/bin/prop_chg -D display-subsystem -w 85:DPMS:3
	/usr/local/bin/prop_chg -D display-subsystem -w 85:DPMS:0
#       killall -2 gst-launch-1.0

#       /usr/bin/openbox.bak &
#       /usr/bin/startxfce4 &
#       /usr/bin/xfwm4 --daemon &
#       /usr/bin/onboard &

	route
}

start_f8task()
{
	#gst-launch-1.0 filesrc location=/root/img-1920X1080.jpg ! jpegdec ! imagefreeze ! videoconvert ! ximagesink &
	#gst-launch-1.0 playbin uri=file:///opt/niliu.mp4 &
	#sleep 5
	echo on > /sys/class/drm/card0-HDMI-A-1/status
	sleep 1
	xrandr --output HDMI-1 --mode 1920x1080
	xrandr --output HDMI-1 --right-of LVDS-1

 	xinput map-to-output `xinput | awk ' $3=="Goodix" {print substr($6,4)} '` LVDS-1
	
	/usr/bin/openbox.bak &


	echo 1192 > /sys/class/gpio/export
	echo out > /sys/class/gpio/gpio1192/direction
	echo 1 > /sys/class/gpio/gpio1192/value

	echo 1011 > /sys/class/gpio/export
	echo out > /sys/class/gpio/gpio1011/direction
	echo 1 > /sys/class/gpio/gpio1011/value

	echo 1219 > /sys/class/gpio/export
	echo out > /sys/class/gpio/gpio1219/direction
	echo 1 > /sys/class/gpio/gpio1219/value
	
	echo 1013 > /sys/class/gpio/export
	echo out > /sys/class/gpio/gpio1013/direction
	echo 1 > /sys/class/gpio/gpio1013/value
	
	#media-ctl -d /dev/media0 --set-v4l2 '"rockchip-sy-mipi-dphy":0[fmt:UYVY8_1X16/1920x1080]'
  #media-ctl -d /dev/media0 --set-v4l2 '"rkisp1-isp-subdev":0[fmt:UYVY8_1X16/1920x1080]'
  #media-ctl -d /dev/media0 --set-v4l2 '"rkisp1-isp-subdev":0[fmt:UYVY8_1X16/1920x1080]' --set-v4l2 '"rkisp1-isp-subdev":0[crop:(0,0)/1920x1080]'
  #media-ctl -d /dev/media0 --set-v4l2 '"rockchip-sy-mipi-dphy":1[fmt:UYVY8_1X16/1920x1080]'
  #media-ctl -d /dev/media0 --set-v4l2 '"rkisp1-isp-subdev":2[fmt:UYVY8_1X16/1920x1080]'
  #media-ctl -d /dev/media0 --set-v4l2 '"rkisp1-isp-subdev":2[fmt:UYVY8_1X16/1920x1080]' --set-v4l2 '"rkisp1-isp-subdev":2[crop:(0,0)/1920x1080]'
	#xinput map-to-output 6 LVDS-1

	sh /usr/f8/bin/f8plus-run.sh &

	route
}

start_Hseries_task()
{

	log_info "start_Hseries_task start"

  #reset crosspoint chip
  #echo "21" "1" > /sys/devices/platform/multi_iocfg.0/multi_iocfg/reset
  
  #disable syslog.service
  if [ -f  /lib/systemd/system/rsyslog.service ]; then
      mv /lib/systemd/system/rsyslog.service /lib/systemd/system/rsyslog.service.bak
  fi
  if [ -f  /usr/sbin/rsyslogd ]; then
      mv /usr/sbin/rsyslogd /usr/sbin/rsyslogd.bak
  fi
  #Removed /etc/systemd/system/syslog.service.
  #Removed /etc/systemd/system/multi-user.target.wants/rsyslog.service.
  
  #echo 1200 > /sys/class/gpio/export
  #echo out > /sys/class/gpio/gpio1200/direction
  #echo 0 > /sys/class/gpio/gpio1200/value
  #sleep 0.5
  #echo 1 > /sys/class/gpio/gpio1200/value
  
  #up cp spi dirver vol
  memory w 0xff770204 0xff00ff55 4  
  touch /tmp/step1
  #sh /usr/Hseries/bin/Hseries-run.sh &
  log_info "start_Hseries_task powerprocess start"
  cd /usr/Hseries/bin && ./powerprocess &
  route
  
  log_info "start_Hseries_task end"
}

# 删除500M以上大文件	
remove_largefiles()
{
       size=500M
       for path in /*
       do
               file_nums=`find $path -mount -type f -size +$size 2>/dev/null |wc -l`
               if [ $file_nums -gt 0 ];then
                       find $path -mount -type f -size +$size 2>/dev/null |xargs -n 1 rm  >> /usr/Hseries/bin/Middleware/log/first_boot_flag
                       echo "[s95]Wring : has large file than 500M in system; will clean them!!!" >> /usr/Hseries/bin/Middleware/log/first_boot_flag
               fi
       done
}
remove_largefiles

xorg_verify

echo 7 4 1 7 > /proc/sys/kernel/printk

rm /var/log/btmp

set_hwclock
#setmode
check_eth eth1
ifconfig eth1 up
set_local_mac eth1
set_local_ip eth1
start_Hseries_task



# NOTE: exit command really terminate the login-shell, we need to disable it.
#   Otherwise login session is made endless loop by /bin/init.
# exit 0
