"""
Created on 2022年3月18日
@author: 程声清
角色模块数据库访问
返回值统一为 {data:JSON结构体, msg:"", status:0}
"""

from sqlite3 import IntegrityError

from H_9U.util.sqlitepool import pool, sqllock
from H_9U.models.result import get_result_model, ResInfo
from H_9U.util.log import logger

class RoleDao:
    def __init__(self, conn_pool):
        self.pool = conn_pool

    def get_by_id(self, role_id):
        """
        根据角色Id获取角色
        :param role_id: 角色Id
        :return: 角色信息
        """
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                cursor.execute("select id, name, parent_id, sort, active, role_type from role where id=:id",
                               {"id": role_id})
                row = cursor.fetchone()
                if row:
                    rs['data'] = {
                        'id': row[0],
                        'name': row[1],
                        'parent_id': row[2],
                        'sort': row[3],
                        'active': row[4],
                        'role_type': row[5]
                    }
        except Exception as e:
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs

    def get_by_rolename(self, name):
        """
        根据角色名访问用户
        :param name: 角色名
        :return: 角色数据
        """
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()

            sql = "select id, name, parent_id, sort, active, role_type  from role where  name=:name", {"name":name}
            with conn:
                cursor = conn.cursor()
                cursor.execute(sql)
                row = cursor.fetchone()
                if row:
                    rs['data'] = {
                        'id': row[0],
                        'name': row[1],
                        'parent_id': row[2],
                        'sort': row[3],
                        'active': row[4],
                        'role_type': row[5]
                    }
        except Exception as e:
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs

    def insert(self, name, sort, role_type, parentId, active, funcIds, inputIds, outputIds, screenIds, mvrIds):
        """
        添加角色
        :param username: 用户名
        :param password: 密码
        :param tel: 电话
        :param email: 邮箱
        :return: 标准对象
        """
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                cursor.execute(
                    "insert into role(name, parent_id, sort, active, role_type) values(?,?,?,?,?)",
                    (name, parentId,sort, active, role_type))
                cursor.execute('select last_insert_rowid() newid;')
                rows = cursor.fetchone()
                role_id = rows[0]
                cursor.execute("update role set sort =:new_role_id where id =:role_id",
                               {"new_role_id": role_id, "role_id": role_id})
                if funcIds:
                    sql = "insert into role_data(input_id, output_id, screen_id, menu_id, mvr_id, data_type,role_id) values "
                    for f in funcIds:
                        sql += "({},{},{},{},{},{},{}),".format(0, 0, 0, f, 0, 1, role_id)
                    sql = sql[:-1]
                    cursor.execute(sql)
                if inputIds:
                    sql_input = "insert into role_data(input_id, output_id, screen_id, menu_id, mvr_id, data_type, role_id) values "
                    for f in inputIds:
                        sql_input += "({},{},{},{},{},{},{}),".format(f, 0, 0, 0, 0, 2, role_id)
                    sql_input = sql_input[:-1]
                    cursor.execute(sql_input)
                if outputIds:
                    sql_output = "insert into role_data(input_id, output_id, screen_id, menu_id, mvr_id, data_type, role_id) values "
                    for f in outputIds:
                        sql_output += "({},{},{},{},{},{},{}),".format(0, f, 0, 0, 0, 3, role_id)
                    sql_output = sql_output[:-1]
                    cursor.execute(sql_output)
                if screenIds:
                    sql_screen = "insert into role_data(input_id, output_id, screen_id, menu_id, mvr_id, data_type, role_id) values "
                    for f in screenIds:
                        sql_screen += "({},{},{},{},{},{},{}),".format(0, 0, f, 0, 0, 4, role_id)
                    sql_screen = sql_screen[:-1]
                    cursor.execute(sql_screen)
                if mvrIds:
                    sql_screen = "insert into role_data(input_id, output_id, screen_id, menu_id, mvr_id, data_type, role_id) values "
                    for f in mvrIds:
                        sql_screen += "({},{},{},{},{},{},{}),".format(0, 0, 0, 0, f, 5, role_id)
                    sql_screen = sql_screen[:-1]
                    cursor.execute(sql_screen)
                conn.commit()
                rs['data']['id'] = role_id
        except IntegrityError:
            rs = get_result_model(ResInfo.User_Name_Exist)
        except Exception as e:
            logger.exception(e)
            rs = get_result_model(ResInfo.User_Add_Faild)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs

    def delete(self, role_id, user_ids):
        """
        删除角色
        :param role_id: 角色id
        :return: 结果对象
        """
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                cursor.execute("delete from role where id =:id", {"id": role_id})
                if user_ids:
                    for user_id in user_ids:
                        cursor.execute("update user_role set role_id =:default_role where user_id =:user_id",
                               {"default_role": 2, "user_id": user_id})
                cursor.execute("delete from role_data where role_id =:role_id", {"role_id": role_id})
                conn.commit()
        except Exception as e:
            logger.exception(e)
            rs = get_result_model(ResInfo.User_Delete_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs

    def update(self, role_id, role_params, funcs, inputIds, outputIds, screenIds, mvrIds):
        """
        更新角色
        :param role_id: 角色Id
        :param active: 是否启动
        :return: 标准返回
        """
        try:
            conditions = []
            for key in role_params:
                conditions.append('{}=:{}'.format(key, key))
            sql = "update role set " + ', '.join(conditions) + " where id=:id"
            role_params['id'] = role_id
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                cursor.execute(sql, role_params)
                if funcs is not None:
                    cursor.execute("delete from role_data where role_id=:role_id and data_type=:data_type", {"role_id": role_id, "data_type": 1})
                    if funcs:
                        sql = "insert into role_data(input_id, output_id, screen_id, menu_id, mvr_id, data_type, role_id) values "
                        for f in funcs:
                            sql += "({},{},{},{},{},{},{}),".format(0, 0, 0, f, 0, 1, role_id)
                        sql = sql[:-1]
                        cursor.execute(sql)
                if inputIds is not None:
                    cursor.execute("delete from role_data where role_id=:role_id and data_type=:data_type", {"role_id": role_id, "data_type": 2})
                    if inputIds:
                        sql = "insert into role_data(input_id, output_id, screen_id, menu_id, mvr_id, data_type, role_id) values "
                        for f in inputIds:
                            sql += "({},{},{},{},{},{},{}),".format(f, 0, 0, 0, 0, 2, role_id)
                        sql = sql[:-1]
                        cursor.execute(sql)
                if outputIds is not None:
                    cursor.execute("delete from role_data where role_id=:role_id and data_type=:data_type",
                                   {"role_id": role_id, "data_type": 3})
                    if outputIds:
                        sql = "insert into role_data(input_id, output_id, screen_id, menu_id, mvr_id, data_type, role_id) values "
                        for f in outputIds:
                            sql += "({},{},{},{},{},{},{}),".format(0, f, 0, 0, 0, 3, role_id)
                        sql = sql[:-1]
                        cursor.execute(sql)
                if screenIds is not None:
                    cursor.execute("delete from role_data where role_id=:role_id and data_type=:data_type",
                                   {"role_id": role_id, "data_type": 4})
                    if screenIds:
                        sql = "insert into role_data(input_id, output_id, screen_id, menu_id, mvr_id, data_type, role_id) values "
                        for f in screenIds:
                            sql += "({},{},{},{},{},{},{}),".format(0, 0, f, 0, 0, 4, role_id)
                        sql = sql[:-1]
                        cursor.execute(sql)
                if mvrIds is not None:
                    cursor.execute("delete from role_data where role_id=:role_id and data_type=:data_type",
                                   {"role_id": role_id, "data_type": 5})
                    if mvrIds:
                        sql = "insert into role_data(input_id, output_id, screen_id, menu_id, mvr_id, data_type, role_id) values "
                        for f in mvrIds:
                            sql += "({},{},{},{},{},{},{}),".format(0, 0, 0, 0, f, 5, role_id)
                        sql = sql[:-1]
                        cursor.execute(sql)
                conn.commit()
        except Exception as e:
            logger.exception(e)
        finally:
            if sqllock.locked():
                sqllock.release()
        return get_result_model()

    def update_role(self, parent_id, role_id):
        """
        更新角色的父Id
        :param role_id: 角色Id
        :param active: 是否启动
        :return: 标准返回
        """
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                cursor.execute("update role set parent_id=:parent_id where id=:role_id", {"parent_id":parent_id,"role_id":role_id})
                conn.commit()
        except Exception as e:
            logger.exception(e)
        finally:
            if sqllock.locked():
                sqllock.release()
        return get_result_model()

    def get_all_role(self):
        """
        查看全部角色
        :return:
        """
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                cursor.execute("select id, name,parent_id, sort, active,role_type from role order by sort desc ")
                rows = cursor.fetchall()
                role_list = []
                if rows:
                    for row in rows:
                        role_list.append({
                            'id': row[0],
                            'name': row[1],
                            'parent_id': row[2],
                            'sort': row[3],
                            'active': row[4],
                            'role_type': row[5],
                        })
                rs['data'] = role_list
        except Exception as e:
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs

    def get_role_by_user_id(self, user_id):
        """
        根据用户id获取角色
        :return:
        """
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                cursor.execute("select id, user_id, role_id  from user_role where  user_id=:user_id", {"user_id": str(user_id)})
                row = cursor.fetchone()
                if row:
                    rs['data'] = {
                        'id': row[0],
                        'userId': row[1],
                        'roleId': row[2]
                        }
                # rs['data'] = role_list
        except Exception as e:
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs

    def get_by_parent_id(self, role_id):
        """
        根据角色Id获取角色
        :param role_id: 角色Id
        :return: 角色信息
        """
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                cursor.execute("select id, name, parent_id, sort, active, role_type from role where parent_id=:rid",
                               {"rid": role_id})
                role_list = []
                rows = cursor.fetchall()
                if rows:
                    for  row in rows:
                        role_list.append({
                        'id': row[0],
                        'name': row[1],
                        'parent_id': row[2],
                        'sort': row[3],
                        'active': row[4],
                        'role_type': row[5]
                    })
                    rs['data'] = role_list
        except Exception as e:
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs

    def get_func_by_role_id(self, role_id):
        """
        根据角色id获取菜单
        :return:
        """
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                cursor.execute("select id, input_id, output_id, screen_id, menu_id, mvr_id, data_type, role_id from  role_data where role_id =:role_id and data_type=:data_type", {"role_id":role_id, "data_type":1})
                rows_list = cursor.fetchall()
                menu_id_list = []
                if rows_list:
                    for row in rows_list:
                        menu_id_list.append({
                            'menuId': row[4]})
                rs['data'] = menu_id_list
        except Exception as e:
                rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs

    def get_data_by_role_id(self, menu_type):
        """
        根据角色id获取菜单-数据
        :return:
        """
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                cursor.execute("select id, code, name, active, [type], parent_id from  data where [type]=:menuType and active =1 ", {"menuType":menu_type})
                row = cursor.fetchone()
                if row:
                    rs['data'] = {
                        'id': row[0],
                        'code': row[1],
                        'name': row[2],
                        'active': row[3],
                        'type': row[4],
                        'parent_id': row[5]
                    }

        except Exception as e:
                rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs

    def get_func_by_menu_id(self, menu_id):
        """
        根据角色id获取菜单
        :return:
        """
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                cursor.execute("select id, name, level,parent_id,sort,active,endPoint,code,[type]  from menu  where  id=:menu_id and active = 1", {"menu_id":menu_id})
                row = cursor.fetchone()
                if row:
                    rs['data']={
                            'id': row[0],
                            'name': row[1],
                            'level': row[2],
                            'parent_id': row[3],
                            'sort': row[4],
                            'active': row[5],
                            'endPoint': row[6],
                            'code': row[7],
                            'type': row[8]
                            }
        except Exception as e:
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs

    def get_funcs(self):
        """
        根据角色id获取菜单
        :return:
        """
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            sql = "select id, name, level,parent_id,sort,active,endPoint,code,[type]  from menu where active = 1 order by sort asc "
            with conn:
                cursor = conn.cursor()
                cursor.execute(sql)
                rows = cursor.fetchall()
                # menu_id = []
                # if rowss:
                #     for rows in rowss:
                #         menu_id.append(rows)
                # rows = cursor.fetchall()
                menu_list = []
                if rows:
                    for row in rows:
                        menu_list.append({
                            'id': row[0],
                            'name': row[1],
                            'level': row[2],
                            'parent_id': row[3],
                            'sort': row[4],
                            'active': row[5],
                            'endPoint': row[6],
                            'code': row[7],
                            'type': row[8]
                        })
                rs['data'] = menu_list
        except Exception as e:
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs

    def get_menu_by_role_id(self, role_id):
        """
        根据角色Id获取角色
        :param role_id: 角色Id
        :return: 角色信息
        """
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                # cursor.execute("select id, role_id, menu_id from  role_menu where role_id =:role_id", {"role_id": role_id})
                cursor.execute(
                    "select id, input_id, output_id, screen_id, menu_id, mvr_id, data_type, role_id from  role_data where role_id =:role_id and data_type=:data_type",
                    {"role_id": role_id, "data_type": 1})
                functions = []
                rows = cursor.fetchall()
                if rows:
                    for  row in rows:
                        functions.append( {
                            'id': row[0],
                            'roleId': row[7],
                            'funcId': row[4]
                    })
                    rs['data'] = functions
        except Exception as e:
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs


    def get_input_by_role_id(self, role_id):
        """
        根据角色Id获取输入列表
        :param role_id: 角色Id
        :return: 角色信息
        """
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                cursor.execute(
                    "select id, input_id, output_id, screen_id, menu_id, mvr_id, data_type, role_id from  role_data where role_id =:role_id and data_type=:data_type",
                    {"role_id": role_id, "data_type": 2})
                functions = []
                rows = cursor.fetchall()
                if rows:
                    for  row in rows:
                        functions.append( {
                            'id': row[0],
                            'roleId': row[7],
                            'inputId': row[1]
                    })
                    rs['data'] = functions
        except Exception as e:
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs

    def get_output_by_role_id(self, role_id):
        """
        根据角色Id获取输入列表
        :param role_id: 角色Id
        :return: 角色信息
        """
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                cursor.execute(
                    "select id, input_id, output_id, screen_id, menu_id, mvr_id, data_type, role_id from  role_data where role_id =:role_id and data_type=:data_type",
                    {"role_id": role_id, "data_type": 3})
                functions = []
                rows = cursor.fetchall()
                if rows:
                    for  row in rows:
                        functions.append( {
                            'id': row[0],
                            'roleId': row[7],
                            'outputId': row[2]
                    })
                    rs['data'] = functions
        except Exception as e:
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs

    def get_screen_by_role_id(self, role_id):
        """
        根据角色Id获取输入列表
        :param role_id: 角色Id
        :return: 角色信息
        """
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                cursor.execute(
                    "select id, input_id, output_id, screen_id, menu_id, mvr_id, data_type, role_id from  role_data where role_id =:role_id and data_type=:data_type",
                    {"role_id": role_id, "data_type": 4})
                functions = []
                rows = cursor.fetchall()
                if rows:
                    for row in rows:
                        functions.append({
                            'id': row[0],
                            'roleId': row[7],
                            'screenId': row[3]
                        })
                    rs['data'] = functions
        except Exception as e:
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs

    def get_mvr_by_role_id(self, role_id):
        """
        根据角色Id获取预监列表
        :param role_id: 角色Id
        :return: 角色信息
        """
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                cursor.execute(
                    "select id, input_id, output_id, screen_id, menu_id, mvr_id, data_type, role_id from  role_data where role_id =:role_id and data_type=:data_type",
                    {"role_id": role_id, "data_type": 5})
                functions = []
                rows = cursor.fetchall()
                if rows:
                    for row in rows:
                        functions.append({
                            'id': row[0],
                            'roleId': row[7],
                            'mvrId': row[5]
                        })
                    rs['data'] = functions
        except Exception as e:
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs

    # get_role_id_by_role_type(role_type)
    def get_role_id_by_role_type(self, role_type):
        """
        根据角色类型获取角色信息
        :param role_id: 角色Id
        :return: 角色信息
        """
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                cursor.execute("select id, name, parent_id, sort, active, role_type from role where role_type=:role_type",
                               {"role_type": role_type})
                row = cursor.fetchone()
                if row:
                    rs['data'] = {
                        'id': row[0],
                        'name': row[1],
                        'parent_id': row[2],
                        'sort': row[3],
                        'active': row[4],
                        'role_type': row[5]
                    }
        except Exception as e:
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs

    def get_user_by_role_id(self, role_id):
        """
        根据角色Id获取用户
        :param role_id: 用户Id
        :return: 角色信息
        """
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                cursor.execute("select id, user_id, role_id from  user_role where role_id =:role_id", {"role_id": role_id})
                users = []
                rows = cursor.fetchall()
                if rows:
                    for  row in rows:
                        users.append( {
                            'id': row[0],
                            'userId': row[1],
                            'roleId': row[2]
                    })
                    rs['data'] = users
        except Exception as e:
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs

    def get_role_by_role_name(self, role_id, role_name):
        """
        根据角色类型获取角色信息
        :param role_id: 角色Id
        :return: 角色信息
        """
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                cursor.execute("select id, name, parent_id, sort, active, role_type from role where name=:role_name and id !=:role_id",
                               {"role_name":role_name,"role_id": role_id})
                roles = []
                rows = cursor.fetchall()
                if rows:
                    for row in rows:
                        roles.append( {
                        'id': row[0],
                        'name': row[1],
                        'parent_id': row[2],
                        'sort': row[3],
                        'active': row[4],
                        'role_type': row[5]
                    }
                    )
                    rs['data'] = roles
        except Exception as e:
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs

    def get_all_data_by_role_id(self, role_id):
        """
        根据角色Id获取全部数据
        :param role_id: 角色Id
        :return: 角色信息
        """
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                cursor.execute(
                    "select id, input_id, output_id, screen_id, menu_id, mvr_id, data_type, role_id from  role_data where role_id =:role_id ",
                    {"role_id": role_id})
                functions = []
                rows = cursor.fetchall()
                if rows:
                    for row in rows:
                        functions.append({
                            'id': row[0],
                            'inputId': row[1],
                            'outputId': row[2],
                            'screenId': row[3],
                            'menuId': row[4],
                            'mvrId': row[5],
                            'dataType': row[6]
                        })
                    rs['data'] = functions
        except Exception as e:
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs


roledao = RoleDao(pool)