from H_9U.mao.impl import device, input
from H_9U.util.cache import cacher
from H_9U.models.cachekey import CacheKey, CacheDuration
from H_9U.models.sysconst import FunctionType, CardCategory
from H_9U.models.sysconst import CardType, ModelId
from H_9U.models.result import get_result_model


class DeviceApi:

    def read_detail(self, device_id):
        """
        读取设备详情并加入缓存
        :param device_id: 设备id
        :return: 结果数据
        """
        key = CacheKey.device_detail(device_id)
        rs = cacher.DeviceCache.try_get_value(key, CacheDuration.Default, device.device_detail_read, device_id)
        return rs

    def read_detail_without_cache(self, device_id):
        return device.device_detail_read(device_id)

    def read_general(self, device_id):
        """
        读取设备基本信息
        :param device_id: 设备Id
        :return: 结果信息
        """
        return device.device_general_read(device_id)

    def write_general(self, device_id, data):
        """
        设置设备基本信息
        清除设备详情缓存
        :param device_id: 设备id
        :param data: 基本信息
        :return: 结果对象
        """
        rs = device.device_general_write(device_id, data)
        if rs['status'] == 0:
            cacher.DeviceCache.delete(CacheKey.device_detail(device_id))
        return rs

    def read_slot(self, device_id, slot_id):
        """
        读取槽位信息并加入缓存
        :param device_id: 设备Id
        :param slot_id: 槽位Id
        :return: 槽位信息
        """
        return device.device_slot_read(device_id, slot_id)

    def write_slot(self, device_id, slot_id, data):
        """
        设置槽位信息
        移除槽位信息缓存
        :param device_id: 设备Id
        :param slot_id: slot id
        :param data: 槽位信息
        :return:  结果对象
        """
        # # 根据slotId 获取对应的卡
        # rs = device.device_slot_read(device_id, slot_id)
        # if rs['status'] != 0 or not rs['data']:
        #     return rs
        # model_id = rs['data']['modelId']
        # # 判断卡类别
        # if model_id == ModelId.H_1xST2110_I:
        #     if "inputs" in data:
        #     # 调用设置timing
        #         input_id = data['inputs'][0]['id']
        #         timing = {
        #             "horizontal":
        #                 {
        #                     "addrTime": data['inputs'][0]['resolution']['width'],
        #                     "frontPorch":0,
        #                     "sync":0,
        #                     "syncPolarity":0,
        #                     "totalTime":0
        #                 },
        #             "vertical":{
        #                 "addrTime": data['inputs'][0]['resolution']['height'],
        #                 "frontPorch": 0,
        #                 "sync": 0,
        #                 "syncPolarity": 0,
        #                 "totalTime": 0
        #             },
        #             "refreshRate": data['inputs'][0]['resolution']['refresh'],
        #             "inputId": input_id,
        #             "deviceId":device_id
        #         }
        #         rs = input.input_timing_write(device_id, input_id, timing)
        #         if rs['status'] != 0:
        #             return rs
        #         cacher.InputCache.clear()
        #         general_data = {
        #             "inputId": input_id,
        #             "deviceId":device_id,
        #             "name": data['inputs'][0]['name'],
        #             "colorDepth": data['inputs'][0]['colorDepth'],
        #             "colorSpace":  data['inputs'][0]['colorSpace'],
        #             "sampleRate": data['inputs'][0]['sampleRate'],
        #             "cscMode": data['inputs'][0]['cscMode'],
        #             "HDCPEncryted": 0,
        #             "connectCapacity": 0,
        #             "audioSrc": 0,
        #         }
        #         rs = input.input_general_write(device_id, input_id, general_data)
        #         if rs['status'] != 0:
        #             return rs
        #         cacher.InputCache.clear()
        rs = device.device_slot_write(device_id, slot_id, data)
        if rs['status'] == 0:
            key = CacheKey.device_slot(device_id, slot_id)
            cacher.DeviceCache.delete(key)
            cacher.OutputCache.clear()
        return rs

    def read_interface(self, device_id, slot_id, interface_id):
        """
        读取接口信息
        :param device_id: 设备Id
        :param slot_id: 槽位Id
        :param interface_id:  接口Id
        :return: 接口信息
        """
        return device.device_interface_read(device_id, slot_id, interface_id)

    def read_power(self, device_id, power_id):
        """
        读取电源信息
        :param device_id: 设备Id
        :param power_id: 电源Id
        :return: 电源信息
        """
        return device.device_power_read(device_id, power_id)

    def read_genlock(self, device_id, genlock_id):
        """
        读取genlock信息
        :param device_id: 设备Id
        :param genlock_id:  genlock Id
        :return:  结果信息
        """
        return device.device_genlock_read(device_id, genlock_id)

    def write_genlock(self, device_id, genlock_id, data):
        """
        设备genlock信息
        清除设备详情缓存
        :param device_id: 设备Id
        :param genlock_id: genlock id
        :param data: 数据信息
        :return: 结果对象
        """
        rs = device.device_genlock_write(device_id, genlock_id, data)
        if rs['status'] == 0:
            key = CacheKey.device_detail(device_id)
            cacher.DeviceCache.delete(key)
        return rs

    def write_slot_function(self, device_id, slot_id, data):
        """
        设置slot function
        :param device_id: 设备Id
        :param slot_id: slot id
        :param data:  数据对象
        :return: 结果对象
        """
        rs = device.device_slot_function_write(device_id, slot_id, data)
        if rs['status'] == 0:
            cacher.clear_all()
        return rs

    def read_slot_function(self, device_id, slot_id):
        """
        读取slot function
        :param device_id: 设备Id
        :param slot_id:  slot id
        :return:  结果对象
        """
        return device.device_slot_read(device_id, slot_id)

    def read_ip(self, device_id):
        """
        读取ip信息和DNS
        :param device_id: 设备Id
        :return: ip信息
        """
        return device.device_ip_read(device_id)

    def write_ip(self, device_id, data):
        """
        设置设备Ip和DNS
        :param device_id: 设备Id
        :param data: ip信息
        :return: 结果对象
        """
        return device.device_ip_write(device_id, data)

    def read_com(self, device_id):
        """
        读取com信息
        :param device_id: 设备Id
        :return: com 信息
        """
        return device.device_com_read(device_id)

    def write_com(self, device_id, data):
        """
        设置com 信息
        :param device_id: 设备id
        :param data: com信息
        :return: 结果对象
        """
        return device.device_com_write(device_id, data)

    def write_save(self, device_id, data):
        """
        保存设备信息
        :param device_id: 设备Id
        :param data:
        :return: 结果对象
        """
        return device.device_save_write(device_id, data)

    def write_shutdown(self, device_id, data):
        """
        设备关机
        :param device_id: 设备Id
        :param data: 数据信息
        :return: 结果对象
        """
        return device.device_shutdown_write(device_id, data)

    def write_restore_factory(self, device_id, data):
        """
        工厂复位
        :param device_id: 设备Id
        :param data: 复位信息
        :return: 结果对象
        """
        return device.device_restore_factory_write(device_id, data)

    def read_firware_version(self, device_id):
        """
        读取版本信息并加入缓存
        :param device_id: 设备id
        :return: 版本信息
        """
        return device.device_firware_version_read(device_id)

    def write_upgrade(self, device_id, data):
        """
        固件升级
        :param device_id: 设备id
        :param data: 升级信息
        :return: 结果对象
        """
        return device.device_upgrade_write(device_id, data)

    def read_upgrade_sts(self, device_id):
        """
        读取升级状态
        :param device_id: 设备Id
        :return: 结果数据
        """
        return device.device_upgrade_sts_read(device_id)

    def write_self_check(self, device_id, data):
        """
        设备自检
        :param device_id: 设备Id
        :param data:
        :return: 结果对象
        """
        return device.device_self_check(device_id, data)

    def read_self_check_status(self, device_id):
        """
        设备自检
        :param device_id: 设备Id
        :param data:
        :return: 结果对象
        """
        return device.device_self_check_status(device_id)

    def write_device_settings(self, device_id, data):
        """
        设置设备配置信息
        :param device_id: 设备id
        :param data: 文件路径
        :return: 结果对象
        """
        return device.device_guide_data_write(device_id, data)

    def read_nomark_mode(self, device_id):
        """
        读取设中性模式
        :param device_id: 设备Id
        :return: 结果对象
        """
        return device.device_nomark_mode_read(device_id)

    def write_nomark_mode(self, device_id, data):
        """
        设置中性模式
        :param device_id:  设备Id
        :param data: 中性模式
        :return: 结果对象
        """
        return device.device_nomark_mode_write(device_id, data)

    def write_effective_time(self, device_id, data):
        """
        设备授权时间
        :param device_id: 设备Id
        :param data: 授权时间对象
        :return: 结果对象
        """
        rs = device.device_effective_time_write(device_id, data)
        if rs['status'] == 0:
            cacher.clear_all()
        return rs

    def write_local_time(self, device_id, data):
        """
        设备授权时间
        :param device_id: 设备Id
        :param data: 授权时间对象
        :return: 结果对象
        """
        return device.device_local_time_write(device_id, data)

    def read_effective_time(self, device_id):
        """
        读取授权时间
        :param device_id: 设备Id
        :return: 结果对象
        """
        return device.device_effective_time_read(device_id)

    def read_local_time(self, device_id):
        """
        读取时间
        :param device_id: 设备Id
        :return: 结果对象
        """
        return device.device_local_time_read(device_id)

    def device_hdr_support(self, device_id):
        """
        读取授权时间
        :param device_id: 设备Id
        :return: 结果对象
        """
        key = CacheKey.device_hdr_support(device_id)
        rs = cacher.DeviceCache.try_get_value(key, CacheDuration.Long, device.device_hdr_support_read, device_id)
        return rs

    def read_device_language(self, device_id):
        """
        读取语言模式
        :param device_id: 设备Id
        :return: 结果对象
        """
        return device.device_language_read(device_id)

    def write_device_language(self, device_id, data):
        """
        设置语言模式
        :param device_id: 设备Id
        :param data: 语言模式
        :return: 结果
        """
        return device.device_language_write(device_id, data)

    def read_ipc_mode(self, device_id):
        """
        设置语言模式
        :param device_id: 设备Id
        :param data: 语言模式
        :return: 结果
        """
        rs = get_result_model()
        rs['data'] = {
            'deviceId': device_id,
            'ipcMode': 1
        }
        return rs

    def ipc_mode_info(self, device_id, slot_id):
        """
        设置语言模式
        :param device_id: 设备Id
        :param data: 语言模式
        :return: 结果
        """
        return device.device_ipc_mode_read(device_id, slot_id)

    def write_ipc_mode(self, device_id, slot_id, data):
        """
        设置语言模式
        :param device_id: 设备Id
        :param data: 语言模式
        :return: 结果
        """
        key = CacheKey.device_slot(device_id, slot_id)
        rs = device.device_ipc_mode_write(device_id, slot_id, data)
        if rs['status'] == 0:
            cacher.LayerCache.clear()
            cacher.IPCCache.clear()
            cacher.DeviceCache.delete(key)
        return rs

    def read_resource_mode(self, device_id):
        """读取跨接口减图层模式"""
        return device.device_resource_mode_read(device_id)

    def write_resource_mode(self, device_id, data):
        """设置跨接口减图层资源模式"""
        return device.device_resource_mode_write(device_id, data)

    def backup_mode_read(self, device_id):
        """读取设备备份状态"""
        return device.device_backup_mode_read(device_id)

    def backup_mode_write(self, device_id, data):
        """设置设备备份状态"""
        return device.device_backup_mode_write(device_id, data)

    def init_status_read(self, device_id):
        """读取设备初始化状态"""
        return device.device_init_status_read(device_id)

    def device_type_read(self, device_id):
        return device.device_type_read(device_id)

    def device_background_color_read(self, device_id):
        """读取设备背景颜色"""
        return device.device_background_color_read(device_id)

    def device_background_color_write(self, device_id, data):
        """设置设备背景颜色"""
        return device.device_background_color_write(device_id, data)

    ###### osd接口 #####
    def read_device_font_list(self, device_id):
        """
        读取设备字体列表
        :param device_id: 设备id
        :return: 结果对象
        """
        key = CacheKey.device_font_list(device_id)
        return cacher.DeviceCache.try_get_value(key, CacheDuration.Long, device.read_device_font_list, device_id)

    def device_font_delete(self, device_id, data):
        """
       读取设备字体列表
       :param device_id: 设备id
       :param data: 设备删除参数
       :return: 结果对象
       """
        rs = device.write_device_font_delete(device_id, data)
        if rs['status'] == 0:
            cacher.DeviceCache.delete(CacheKey.device_font_list(device_id))
        return rs

    def device_font_create(self, device_id, data):
        """
        创建osd字体
        """
        rs = device.write_device_font_create(device_id, data)
        if rs['status'] == 0:
            cacher.DeviceCache.delete(CacheKey.device_font_list(device_id))
        return rs

    def device_fiber_mode_write(self, device_id, data):
        """
        设置4光纤卡的模式
        :param device_id: 设备号
        :param params: params
        :return:
        """
        rs = device.write_device_fiber_mode(device_id, data)
        if rs['status'] == 0:
            cacher.clear_all()
        return rs

    ###### osd接口 end #####

    def input_backup_write(self, device_id, enable, type, data):
        """
        输入源开启/关闭备份
        :param device_id:  设备Id
        :param input_backup_enable:  开启/关闭
        :param data:  数据
        :return: 结果对象
        """
        rs = device.input_backup_write(device_id, enable, type, data)
        if rs['status'] == 0:
            cacher.ScreenCache.clear()
            cacher.LayerCache.clear()
        return rs

    def input_backup_read(self, device_id):
        """
        输入源开启/关闭备份状态回读
        :param device_id:  设备Id
        :param input_backup_enable:  开启/关闭
        :param data:  数据
        :return: 结果对象
        """
        return device.input_backup_read(device_id)

    def input_backup_update(self, device_id, data):
        """
         输入源备份添加/更新
        :param device_id:  设备Id
        :param input_backup_enable:  开启/关闭
        :param data:  数据
        :return: 结果对象
        """
        rs = device.input_backup_update(device_id, data)
        if rs['status'] == 0:
            cacher.LayerCache.clear()
        return rs

    def input_backup_list_read(self, device_id):
        """
         输入源备份添加/更新
        :param device_id:  设备Id
        :param input_backup_enable:  开启/关闭
        :param data:  数据
        :return: 结果对象
        """
        return device.input_backup_list_read(device_id)

    def input_backup_delete(self, device_id, data):
        """
        输入源备份删除
        :param device_id:  设备Id
        :param data:  数据
        :return: 结果对象
        """
        return device.input_backup_delete(device_id, data)

    def central_cmd_list_read(self, device_id):
        """
        获取中控命令列表
        :param device_id: 设备id
        :return: 结果对象
        """
        return device.read_device_central_cmd_list(device_id)

    def central_cmd_detail_read(self, device_id, cmd_id):
        """
        获取中控命令列表
        :param device_id: 设备id
        :return: 结果对象
        """
        return device.read_device_central_cmd_detail(device_id, cmd_id)

    def central_cmd_create_write(self, device_id, data):
        """
        中控命令创建
        """
        return device.write_device_central_cmd_create(device_id, data)

    def central_cmd_modify_write(self, device_id, data):
        """
        中控命令修改
        """
        return device.write_device_central_cmd_modify(device_id, data)

    def central_cmd_delete_write(self, device_id, data):
        """
        中控命令删除
        """
        return device.write_device_central_cmd_delete(device_id, data)

    def central_cmd_apply_write(self, device_id, data):
        """
        中控命令应用
        """
        return device.write_device_central_cmd_apply(device_id, data)

    def write_device_output_interface_mode(self, device_id, data):
        """
        设置输出接口的模式切换
        :param device_id: 设备id
        :param data: 设备参数
        :return: 结果对象
        """
        return device.write_device_output_interface_mode(device_id, data)

    def write_device_interface_capacity(self, device_id, slot_id, interface_id, data):
        """
        设置输出接口的模式切换
        :param device_id: 设备id
        :param data: 设备参数
        :return: 结果对象
        """
        return device.write_device_interface_capacity(device_id, slot_id, interface_id, data)

    def read_audio_card_detail(self, device_id, slot_id):
        """
        读取音频卡详情
        """
        key = CacheKey.device_audio_card_detail(device_id, slot_id)
        return cacher.DeviceCache.try_get_value(key, CacheDuration.Long, device.read_audio_card_detail, device_id, slot_id)

    def write_audio_card_attribute(self, device_id, slot_id, data):
        """
         设置音频卡模式
        """
        rs = device.write_audio_card_attribute(device_id, slot_id, data)
        if rs['status'] == 0:
            cacher.clear_all()
        return rs

    def write_audio_interface_delay_time(self, device_id, slot_id, data):
        """
         设音频接口延时
        """
        return device.write_audio_interface_delay_time(device_id, slot_id, data)

    def read_audio_card_list(self, device_id):
        """
        读取音频卡列表
        """
        key = CacheKey.device_audio_card_list(device_id)
        return cacher.DeviceCache.try_get_value(key, CacheDuration.Default, device.read_audio_card_list, device_id)

    def genLock_status_read(self, device_id, genlock_id=0):
        return device.device_genlock_read(device_id, genlock_id)

    def device_slot_eth_distance_write(self, device_id, slot_id, data):
        """
        设置4网口卡模式
        """
        rs = device.device_slot_write(device_id, slot_id, data)
        if rs['status'] == 0:
            key = CacheKey.device_slot(device_id, slot_id)
            cacher.DeviceCache.delete(key)
            cacher.LayerCache.clear()
        return rs

    def write_port_mode(self, device_id, data):
        """
        读取光口卡模式
        :param device_id: 设备id
        :param slotId: slotId
        :return: 结果对象
        """
        rs = device.write_port_mode(device_id, data)
        if rs['status'] == 0:
            cacher.clear_all()
        return rs

    def read_fiber_detail(self, device_id, slot_id):
        return device.read_fiber_detail(device_id, slot_id)

    def sdp_create(self, device_id, data):
        return device.sdp_create(device_id, data)

    def write_lcd_config(self, device_id, data):
        """
		读取光口卡模式
		:param device_id: 设备id
		:param slotId: slotId
		:return: 结果对象
		"""
        rs = device.write_lcd_config(device_id, data)
        return rs

    def read_lcd_config(self, device_id):
        """
		读取光口卡模式
		:param device_id: 设备id
		:param slotId: slotId
		:return: 结果对象
		"""
        rs = device.read_lcd_config(device_id)
        return rs

    def bright_mode_write(self, device_id, data):
        """
        设置亮度调节模式
        :param device_id:  设备Id
        :param data:  数据
        :return: 结果对象
        """
        return device.bright_mode_write(device_id, data)

    def bright_mode_read(self, device_id):
        """
        读取亮度调节模式
        :param device_id:  设备Id
        :return: 结果对象
        """
        return device.bright_mode_read(device_id)

    def read_test_pattern_border_status(self, device_id):
        """
		读取亮度调节模式
		:param device_id:  设备Id
		:return: 结果对象
		"""
        return device.bright_mode_read(device_id)

    def write_test_pattern_border_status(self, device_id, data):
        """
		读取亮度调节模式
		:param device_id:  设备Id
		:return: 结果对象
		"""
        return device.bright_mode_write(device_id, data)

    def test(self):
        return device.test()

    def test_write(self, count):
        return device.test_write(count)


device_api = DeviceApi()


def two_in_one_card_slot(device_id):
    """
    获取设备二合一卡slot列表
    :param device_id:设备Id
    :return:[slotId1,slotId2, ...]
    """
    rs = device_api.read_detail(device_id)
    if rs['status'] == 0:
        slots = rs['data']['slotList']
        data = [x['slotId'] for x in slots
                if x['cardType'] == CardType.Out
                and x['modelId'] in ModelId.Two_In_One_Card_List]
        rs['data'] = data
    return rs


def write_two_in_one_card_payload(device_id, slot_id, payload):
    """
    设置二合一卡的带载面积
    :param device_id: 设备Id
    :param slot_id: slot Id
    :param payload: 带载面积对象
    :return: 结果对象
    """
    data = {
        'deviceId': device_id,
        'slotId': slot_id,
        'resolution': {
            'width': payload['width'],
            'height': payload['height'],
            'refresh': payload['refreshRate'],
            'direction': payload.get('direction', 0),
            'outputCount': payload.get('outputCount', 4)
        }
    }
    return device_api.write_slot(device_id, slot_id, data)


def read_two_in_one_card_payload(device_id, slot_id):
    """
    读取二合一卡payload信息
    :param device_id: 设备Id
    :param slot_id: slot Id
    :return: {width, height, refreshRate}
    """
    rs = device_api.read_slot(device_id, slot_id)
    if rs['status'] == 0:
        if 'resolution' in rs['data']:
            rs['data'] = rs['data']['resolution']
    return rs


def read_device_hdr_support(device_id):
    return device_api.device_hdr_support(device_id)


def output_dl_slot(device_id):
    rs = device_api.read_detail(device_id)
    if rs['status'] == 0:
        slots = rs['data']['slotList']
        data = [x for x in slots
                if x['cardType'] == CardType.Out
                and x['modelId'] in ModelId.DL_Output_Card_List]
        if data:
            dl_op = []
            for s in data:
                if [x for x in s['interfaces'] if x['functionType'] == FunctionType.DL]:
                    dl_op.append(s)
            data = dl_op

        rs['data'] = data
    return rs


def output_4k_slot(device_id):
    rs = device_api.read_detail(device_id)
    if rs['status'] == 0:
        slots = rs['data']['slotList']
        data = [x['slotId'] for x in slots
                if x['cardType'] == CardType.Out
                and x['modelId'] in [ModelId.Output_2_HDMI20_Card, ModelId.Output_12_3G_SDI_Card, ModelId.Pd_Output_2_HDMI20_Card]]
        rs['data'] = data
    return rs
