"""
Created on 2019年6月28日
@author: 刘益宗
bkg接口.
对应3.5代接口协议中的 BKG
返回值统一为 {data:JSON结构体, msg:"", status:0}
"""
from H_9U.models.sysconst import ReadSign
from H_9U.protocol.fncode import FnCode
from H_9U.models.result import transfer_midware_resp
from H_9U import controller as ctrl
from H_9U.util.logwrapper import log_wrapper


@log_wrapper
def bkg_list_read(device_id):
    """
    读取设备bkg列表
    :param device_id: 设备Id
    :return: 参考协议文档：BKGList
    """
    return transfer_midware_resp(ctrl.read(FnCode.BKG_LIST, device_id, ReadSign.Is_ALL))


@log_wrapper
def bkg_full_detail_read(device_id, bkg_id):
    """
    获取BKG的详细信息
    :param device_id:设备号
    :param bkg_id:bkgid
    :return: 参考协议文档：BKGFullDetail
    """
    return transfer_midware_resp(ctrl.read(FnCode.BKG_FULL_DETAIL, device_id, bkg_id))


@log_wrapper
def bkg_create_write(device_id, data):
    """
    创建一个BKG项.
    :param data:  参考协议文档：BKGCreate
    :param device_id: device_id
    :return: 参考协议文档：BKGCreate
    """
    return transfer_midware_resp(ctrl.write(FnCode.BKG_CREATE, [data], device_id))


@log_wrapper
def bkg_delete_write(device_id, bkg_id, data):
    """
    删除bkg
    :param device_id: 设备Id
    :param bkg_id: bkgid
    :param data: 参考协议文档：BKGDelete
    :return: 参考协议文档：BKGDelete
    """
    return transfer_midware_resp(ctrl.write(FnCode.BKG_DELETE, [data], device_id, bkg_id))


@log_wrapper
def bkg_general_read(device_id, bkg_id):
    """
    读取General
    :param device_id: 设备ID
    :param bkg_id: BKG ID
    :return: 参考协议文档：BKGGeneral
    """
    return transfer_midware_resp(ctrl.read(FnCode.BKG_GENERAL, device_id, bkg_id))


@log_wrapper
def bkg_general_write(device_id, bkg_id, data):
    """
    写bkg信息
    :param data: BKGGeneral
    :param device_id: 设备id
    :param bkg_id: bkg id
    :return: 参考协议文档：BKGGeneral
    """

    return transfer_midware_resp(ctrl.write(FnCode.BKG_GENERAL, [data], device_id, bkg_id))
