"""
Created on 2019年6月28日
@author: 刘益宗
mvr接口.
对应3.5代接口协议中的 mvr
返回值统一为 {data:JSON结构体, msg:"", status:0}
"""

import json

from H_9U.protocol.fncode import FnCode
from H_9U.models.result import transfer_midware_resp
from H_9U import controller as ctrl
from H_9U.util.logwrapper import log_wrapper


@log_wrapper
def mvr_list_read(device_id):
    """
    获取MVR数据列表
    :param device_id:设备Id
    :return: 参考中间件接口文档 读取mvr列表
    """
    return transfer_midware_resp(ctrl.read(FnCode.MVR_LIST, device_id))


@log_wrapper
def mvr_full_detail_read(device_id, mvr_id):
    """
    读取MVR详情
    :param device_id: 设备ID
    :param mvr_id: Mvr ID
    :return:参考中间件接口文档 读取全部详情
    """
    return transfer_midware_resp(ctrl.read(FnCode.MVR_FULL_DETAIL, device_id, mvr_id))


@log_wrapper
def mvr_enable_write(device_id, enable):
    """
    设置MVR开关
    :param enable: 0：关闭 1：开启
    :param device_id: 设备ID
    :return: 结果数据MVREnable
    """
    data = json.dumps({'deviceId': device_id, 'enable': enable})
    return transfer_midware_resp(ctrl.write(FnCode.MVR_ENABLE, [data], device_id))


@log_wrapper
def mvr_enable_read(device_id):
    """
    读取mvr开关
    :param device_id: 设备ID
    :return: 参考中间件接口文档 MVREnable
    """
    return transfer_midware_resp(ctrl.read(FnCode.MVR_ENABLE, device_id))


@log_wrapper
def mvr_general_read(device_id, mvr_id):
    """
    读取MVR基本信息
    :param device_id: 设备ID
    :param mvr_id: Mvr ID
    :return: 参考中间件接口文档 MVRGeneral
    """
    return transfer_midware_resp(ctrl.read(FnCode.MVR_GENERAL, device_id, mvr_id))


@log_wrapper
def mvr_general_write(device_id, mvr_id, data):
    """
    读取MVR基本信息
    :param device_id: 设备ID
    :param mvr_id: Mvr ID
    :param data: jsondata
    :return: 参考中间件接口文档 MVRGeneral
    """
    return transfer_midware_resp(ctrl.write(FnCode.MVR_GENERAL, [data], device_id, mvr_id))


@log_wrapper
def mvr_background_color_write(device_id, mvr_id, data):
    """
    设置MVR背景色
    :param device_id: 设备ID
    :param mvr_id: Mvr ID
    :param data: JSON对象
    :return:参考中间件接口文档，MVRBackgroundColor
    """
    return transfer_midware_resp(ctrl.write(FnCode.MVR_BACKGROUND_COLOR, [data], device_id, mvr_id))


@log_wrapper
def mvr_background_color_read(device_id, mvr_id):
    """
    读取MVR背景色
    :param device_id: device_id
    :param mvr_id: mvr_id
    :return: 参考中间件接口文档,MVRBackgroundColor
    """
    return transfer_midware_resp(ctrl.read(FnCode.MVR_BACKGROUND_COLOR, device_id, mvr_id))
