"""
Created on 2025年3月12日
@author: 程声清
main接口..
对应前端接口main
返回值统一为 {body:加密串, msg:"", sign:"", status:0}
"""
from flask import Blueprint, g
from flask.json import jsonify
from H_9U.models.result import get_result_model, ResInfo
from H_9U.open.service import open_device_svc
from H_9U.util.common import get_params
from H_9U.util.logwrapper import open_log

open_device_bp = Blueprint('opn_device', __name__)


@open_device_bp.route('/readDetail', methods=['GET', 'POST'])
@open_log
def device_read_detail():
    """
    读取设备详细信息
    :return:参考前端接口文档readDetail
    """
    params = g.data
    if not params:
        return jsonify(get_result_model(ResInfo.Request_Json_Error))

    values = get_params(params, 'deviceId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id = values

    rs = open_device_svc.device_detail_read(device_id)
    return jsonify(rs)


@open_device_bp.route('/readCardVersion', methods=['GET', 'POST'])
@open_log
def device_read_card_version():
    """
    读取设备详细信息
    :return:参考前端接口文档readDetail
    """
    params = g.data
    if not params:
        return jsonify(get_result_model(ResInfo.Request_Json_Error))

    values = get_params(params, 'deviceId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id = values

    rs = open_device_svc.device_card_version(device_id)
    return jsonify(rs)


@open_device_bp.route('/readIp', methods=['GET', 'POST'])
@open_log
def device_read_ip():
    """
    读取设备详细信息
    :return:参考前端接口文档readDetail
    """
    params = g.data
    if not params:
        return jsonify(get_result_model(ResInfo.Request_Json_Error))

    values = get_params(params, 'deviceId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id = values

    rs = open_device_svc.device_read_ip(device_id)
    return jsonify(rs)


# @open_device_bp.route('/writeIp', methods=['GET', 'POST'])
# @open_log
# def device_write_ip():
#     """
#     读取设备详细信息
#     :return:参考前端接口文档readDetail
#     """
#     params = g.data
#     if not params:
#         return jsonify(get_result_model(ResInfo.Request_Json_Error))
#
#     values = get_params(params, 'deviceId')
#     if values is None:
#         return jsonify(get_result_model(ResInfo.Params_Error))
#     device_id = values
#
#     rs = open_device_svc.device_write_ip(device_id, params)
#     return jsonify(rs)
