"""
Created on 2021年9月17日
@author: 程声清
preset业务处理层.
返回值统一为 {data:JSON结构体, msg:"", status:0}
"""
from H_9U.dao.modelconf import model_conf_dao
from H_9U.mao.preset_mao import preset_api
from H_9U.models.result import get_result_model, ResInfo
from H_9U.models.sysconst import ModelConfKey


def preset_create_middle(device_id, screen_id, data):
    """
    创建场景
    :param device_id: 设备Id
    :param screen_id: 屏幕号
    :param data: 创建场景参数
    :return: 新增场景Id
    """
    return preset_api.write_create(device_id, screen_id, data)


def preset_detail_read_middle(device_id, screen_id, preset_id):
    """
    场景详细信息
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :param preset_id: 场景Id
    :return: 参考中间件协议场景详情
    """
    return preset_api.read_detail(device_id, screen_id, preset_id)


def preset_write_delete_middle(device_id, screen_id, preset_id, data):
    """
    删除场景
    :param data: 删除场景参数
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :param preset_id: 场景Id
    :return: 结果对象
    """
    return preset_api.write_delete(device_id, screen_id, preset_id, data)


def preset_general_write_middle(device_id, screen_id, preset_id, data):
    """
    读取场景基本信息
    :param data: 场景信息参数
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :param preset_id: 场景Id
    :return: 参考中间件协议PresetGeneral部分
    """
    return preset_api.write_general(device_id, screen_id, preset_id, data)


def preset_play_middle(device_id, screen_id, preset_id, data):
    """
    场景播放
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :param preset_id: 场景Id
    :param data:播放场景参数
    :return: 结果对象
    """
    return preset_api.write_play(device_id, screen_id, preset_id, data)


def preset_list_read_middle(device_id, screen_id):
    """
      读取屏幕下所有场景
      :param device_id: 设备Id
      :param screen_id: 屏幕Id
      :return: 场景列表，参考中间件协议
      """
    rs = preset_api.read_list(device_id, screen_id)
    # if rs['status'] == 0 and rs['data']:
    #     preset_list = []
    #     # 循环所有场景，读取详细信息
    #     for preset in rs['data']['presets']:
    #         preset_id = preset['presetId']
    #         detail_rs = preset_detail_read_middle(
    #             device_id, screen_id, preset_id)
    #         if detail_rs['status'] == 0:
    #             preset_list.append(detail_rs['data'])
    #         else:  # 读取单个详情失败，返回
    #             rs = get_result_model(ResInfo.Preset_List_Error)
    #             return rs
    #     rs['data']['presets'] = preset_list
    # return rs
    rs_info = get_result_model()
    if rs['status'] == 0 and rs['data']:
        rs_info['data']['deviceId'] = rs['data']['deviceId']
        rs_info['data']['screenId'] = rs['data']['screenId']
        preset_list = []
        for preset in rs['data']['presets']:
            preset_info = {}
            preset_info['presetId'] = preset['presetId']
            preset_info['name'] = preset['name']
            preset_list.append(preset_info)
        rs_info['data']['presets'] = preset_list
    return rs_info


def preset_delete_middle(device_id, screen_id, preset_id, data):
    """
    删除场景
    :param data: 删除场景参数
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :param preset_id: 场景Id
    :return: 结果对象
    """
    return preset_api.write_delete(device_id, screen_id, preset_id, data)


def preset_group_list_middle(device_id, screen_id):
    """
    读取屏幕下场景分组列表
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :return: 参考前端接口文档场景分组信息
    """
    rs = preset_api.read_group_list(device_id, screen_id)
    if rs['status'] == 0 and rs['data']:
        for group in rs['data']['presetGroups']:
            group_id = group['presetGroupId']
            group_node = preset_api.read_group_node_list(
                device_id, screen_id, group_id)
            if group_node['status'] == 0 and group_node['data']:
                presets = []
                for preset in group_node['data']['presets']:
                    preset_id = preset['presetId']
                    detail_rs = preset_detail_read_middle(
                        device_id, screen_id, preset_id)
                    if detail_rs['status'] == 0:
                        presets.append(detail_rs['data'])
                group['presets'] = presets
    return rs


def preset_group_node_list_middle(device_id, screen_id, group_id):
    """
    读取场景分组节点列表
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :param group_id:  分组Id
    :return:  分组节点列表信息
    """
    return preset_api.read_group_node_list(device_id, screen_id, group_id)


def preset_group_create_middle(device_id, screen_id, data):
    """
    创建场景分组
    :param device_id: 设备Id
    :param screen_id:  屏幕Id
    :param data: 分组信息
    :return:  创建分组Id
    """
    return preset_api.write_group_create(device_id, screen_id, data)


def preset_group_delete_middle(device_id, screen_id, data):
    """
    删除场景分组
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :param data:
    :return: 结果数据
    """
    return preset_api.write_group_delete(device_id, screen_id, data)


def preset_poll_read_middle(device_id, screen_id):
    """
    读取场景轮询数据
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :return: 轮询场景组信息
    """
    return preset_api.read_poll(device_id, screen_id)


def preset_write_poll_middle(device_id, screen_id, data):
    """
    设置场景轮询数据
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :param data
     :return: 结果数据
    """
    return preset_api.write_poll(device_id, screen_id, data)


def preset_play_read_middle(device_id, screen_id):
    """
    读取屏幕播放的场景
    :param device_id:  设备id
    :param screen_id:  屏幕Id
    :return:  场景Id
    """
    key = str(device_id) + '|' + str(screen_id)
    rs = model_conf_dao.get_value(ModelConfKey.PresetPlay, key)
    if rs['status'] == 0:
        preset_id = rs['data']['value']
        rs['data'] = {
            'deviceId': device_id,
            'screenId': screen_id,
            'presetId': preset_id
        }
    return rs


def preset_group_update_middle(device_id, screen_id, data):
    """
    修改场景分组
    :param device_id: 设备Id
    :param screen_id:  屏幕Id
    :param data: 分组信息
    :return:  结果对象
    """
    return preset_api.write_group_update(device_id, screen_id, data)
