import json

from flask import jsonify
from flask.globals import g, request
from functools import wraps


def permission_required(endpoint, form_key='', key=''):
    def decorator(func):
        @wraps(func)
        def decorated_function(*args, **kwargs):
            user = g.user
            is_admin = user['superadmin']
            if is_admin:
                return func(*args, **kwargs)
            else:
                funcs = [x for x in user['funcs'] if x['endpoint'] == endpoint]
                if funcs:
                    current_func = funcs[0]
                    if current_func['is_dependent'] == 0:
                        return func(*args, **kwargs)
                    elif not current_func['bizlist']:
                        return jsonify({'status': 110, 'msg': 'User_Func_Err', 'data': {}})
                    else:
                        if key:
                            try:
                                if form_key:
                                    data = request.form.get(form_key)
                                else:
                                    data = request.get_data().decode()
                                data = json.loads(data)
                            except:
                                return jsonify({'status': 110, 'msg': 'User_Func_Err', 'data': {}})

                            if data:
                                if _valid_model_permission(data, key, current_func['bizlist']):
                                    return func(*args, **kwargs)
                                else:
                                    return jsonify({'status': 110, 'msg': 'User_Func_Err', 'data': {}})
                            else:
                                return jsonify({'status': 110, 'msg': 'User_Func_Err', 'data': {}})
                        else:
                            return jsonify({'status': 110, 'msg': 'User_Func_Err', 'data': {}})
                else:
                    return jsonify({'status': 110, 'msg': 'User_Func_Err', 'data': {}})
        return decorated_function
    return decorator


def _valid_model_permission(data, key, models):
    try:
        if 'list-' not in key:
            if '/' not in key:
                data = data[key]
            else:
                for k in key.split('/'):
                    data = data[k]
            if data not in models:
                return False
        elif key.startswith('list-'):
            if '/' in key:
                k, key = key.split('/', 1)
                for d in data[k[4:]]:
                    return _valid_model_permission(data, key, models)
            else:
                for d in data[key[4:]]:
                    if d not in models:
                        return False
        else:
            k, key = key.split('/', 1)
            data = data[k]
            return _valid_model_permission(data, key, models)
        return True
    except:
        return False


class PermissionName:
    USER_MANAGEMENT = 'USER_MANAGEMENT'
    RESET_SETTING = 'RESET_SETTING'
    OTHER_SETTING = 'OTHER_SETTING'
    IPC_MANAGEMENT = 'IPC_MANAGEMENT'
    FIREWARE_UPDATE = 'FIREWARE_UPDATE'
    EDID_MANAGEMENT = 'EDID_MANAGEMENT'
    COMMUNICATION_SETTING = 'COMMUNICATION_SETTING'
    BACKUP_MANAGEMENT = 'BACKUP_MANAGEMENT'

    SCREEN_UPDATE_ID = 'SCREEN_UPDATE_ID'
    SCREEN_TEST_PATTERN = 'SCREEN_TEST_PATTERN'
    SCREEN_OSD = 'SCREEN_OSD'
    SCREEN_IMAGE_QUALITY = 'SCREEN_IMAGE_QUALITY'
    SCREEN_EDIT_ID = 'SCREEN_EDIT_ID'
    SCREEN_BKG = 'SCREEN_BKG'
    SCREEN_DELETE = 'SCREEN_DELETE'
    SCREEN_CREATE = 'SCREEN_CREATE'

    PRESET_SAVE = 'PRESET_SAVE'
    PRESET_PLAY = 'PRESET_PLAY'
    PRESET_GROUP_PLAY = 'PRESET_GROUP_PLAY'
    PRESET_GROUP_DELETE = 'PRESET_GROUP_DELETE'
    PRESET_GROUP_CREATE = 'PRESET_GROUP_CREATE'
    PRESET_DELETE = 'PRESET_DELETE'

    OUTPUT_TEST_PATTERN = 'OUTPUT_TEST_PATTERN'

    MVR_TEMPLATE = 'MVR_TEMPLATE'
    MVR_MON = 'MVR_MON'
    MVR_ECHO = 'MVR_ECHO'

    INPUT_ID = 'INPUT_ID'


