"""
Created on 2019年6月28日
@author: 刘益宗
service公共处理函数
"""
import shutil
import time
import os

from PIL import Image

from H_9U import BASE_DIR
from H_9U.util.log import logger
from H_9U.conf.syssettings import SysSettings
from H_9U.models.sysconst import UploadFileType
from H_9U.util.upload import upload, open_upload
from H_9U.models.sysconst import InterfaceType, ConnectCapacity


def get_connect_capacity(interface_type=None):
    """
    获取链接容量
    :param interface_type: 接口类型
    :return: 接口容量
    """
    if not interface_type:
        return 0
    rs = ConnectCapacity.SL

    if interface_type in [InterfaceType.Single_Link_DVI, InterfaceType.SDI_3G, InterfaceType.VGA, InterfaceType.CVBS,
                          InterfaceType.YpbPr, InterfaceType.HDMI13, InterfaceType.HDBaseT, InterfaceType.OpticalFiber]:
        rs = ConnectCapacity.SL
    elif interface_type in [InterfaceType.Dual_Link_DVI, InterfaceType.DB9_MALE]:
        rs = ConnectCapacity.DL
    elif interface_type in [InterfaceType.HDMI14, InterfaceType.HDMI20, InterfaceType.DP11, InterfaceType.DP12]:
        rs = ConnectCapacity.K4
    else:
        logger.error("根据接口类型返回连接容量-失败:interfaceType不在处理范围内:%i" % interface_type)

    return rs


def upload_file(file_type, new_name=None, extract=False, extract_folder='extract', file_key='file'):
    """
    上传文件
    :param file_type: 文件类型
    :param file_key:  上传文件key
    :param new_name:  新名词
    :param extract: 是否压缩文件
    :param extract_folder: 解压缩文件夹
    :return: {'bln': u_rs, 'fileName': fn, 'pathNm': path_nm, 'fileSizeStr': file_size_str, 'fileSize': file_size,
            'extractPath': extract_path, 'extractFolderName': extract_folder_name}
    """
    st = time.monotonic()

    # 上传目录判断
    dy_name = True
    if file_type == UploadFileType.BKG:
        path = os.path.join(BASE_DIR, SysSettings.Upload_BKG_Path)
    elif file_type == UploadFileType.Upgrade:
        path = SysSettings.Upload_Upgrade_File_Path
        dy_name = False
        # 删除之前的升级文件
        try:
            if os.path.exists(path):
                shutil.rmtree(path)
        except Exception as e:
            logger.error('删除源升级文件目录失败:%s' % str(e))
    elif file_type == UploadFileType.Input_EDID:
        path = os.path.join(BASE_DIR, SysSettings.Upload_Edid_File_Path)
    elif file_type == UploadFileType.OSD:
        path = os.path.join(BASE_DIR, SysSettings.Upload_OSD_File_Path)
    elif file_type == UploadFileType.Device_Settings:
        path = os.path.join(BASE_DIR, SysSettings.Upload_Device_Settings_File_Path)
        dy_name = False
    elif file_type == UploadFileType.NomarkMode:
        path = os.path.join(BASE_DIR, SysSettings.Nomark_Mode_File_Path)
    elif file_type == UploadFileType.Normal:
        path = os.path.join(BASE_DIR, SysSettings.Normal_File_Path)
    elif file_type == UploadFileType.Font:
        path = os.path.join(BASE_DIR, SysSettings.Font_File_Path)
    elif file_type == UploadFileType.IPC:
        path = os.path.join(BASE_DIR, SysSettings.Upload_IPC_Path)
    elif file_type == UploadFileType.Sdp:
        path = os.path.join(BASE_DIR, SysSettings.Upload_SPD_Path)
    # 上传文件
    u_rs, fn, path_nm, file_size_str, file_size, extract_path, extract_folder_name = upload(path,
                                                                                            file_key=file_key,
                                                                                            filter_Chinese=False,
                                                                                            dy_name=dy_name,
                                                                                            read_file_size=True,
                                                                                            new_name=new_name,
                                                                                            extract=extract,
                                                                                            extract_folder=extract_folder)

    if u_rs:
        msg = '上传成功!'
    else:
        msg = '上传失败!'

    et = time.monotonic()
    tl = (et - st) * 1000  # 耗时,毫秒

    logger.info(msg + ',耗时(毫秒):%s,文件大小：%s, %s, %s' % (str(tl), file_size_str, file_size, fn))

    return {'bln': u_rs, 'fileName': fn, 'pathNm': path_nm, 'fileSizeStr': file_size_str, 'fileSize': file_size,
            'extractPath': extract_path, 'extractFolderName': extract_folder_name}

def open_upload_file(file_type, file_data, file_name, new_name=None, extract=False, extract_folder='extract', file_key='file'):
    """
    上传文件
    :param file_type: 文件类型
    :param file_key:  上传文件key
    :param new_name:  新名词
    :param extract: 是否压缩文件
    :param extract_folder: 解压缩文件夹
    :return: {'bln': u_rs, 'fileName': fn, 'pathNm': path_nm, 'fileSizeStr': file_size_str, 'fileSize': file_size,
            'extractPath': extract_path, 'extractFolderName': extract_folder_name}
    """
    st = time.time()
    path = None
    # 上传目录判断
    if file_type == UploadFileType.BKG:
        path = os.path.join(BASE_DIR, SysSettings.Upload_BKG_Path)
    elif file_type == UploadFileType.Upgrade:
        path = SysSettings.Upload_Upgrade_File_Path
        # 删除之前的升级文件
        try:
            if os.path.exists(path):
                shutil.rmtree(path)
        except Exception as e:
            logger.error('删除源升级文件目录失败:%s' % str(e))
    elif file_type == UploadFileType.Input_EDID:
        path = os.path.join(BASE_DIR, SysSettings.Upload_Edid_File_Path)
    elif file_type == UploadFileType.OSD:
        path = os.path.join(BASE_DIR, SysSettings.Upload_OSD_File_Path)
    elif file_type == UploadFileType.Device_Settings:
        path = os.path.join(BASE_DIR, SysSettings.Upload_Device_Settings_File_Path)
    elif file_type == UploadFileType.NomarkMode:
        path = os.path.join(BASE_DIR, SysSettings.Nomark_Mode_File_Path)
    # 上传文件
    u_rs, fn, path_nm, file_size_str, file_size, extract_path, extract_folder_name = open_upload(path, file_data, file_name)
    if u_rs:
        msg = '上传成功!'
    else:
        msg = '上传失败!'

    et = time.time()
    tl = (et - st) * 1000  # 耗时,毫秒
    logger.info(msg + ',耗时(毫秒):%s,文件大小：%s, %s, %s' % (str(tl), file_size_str, file_size, fn))
    return {'bln': u_rs, 'fileName': fn, 'pathNm': path_nm, 'fileSizeStr': file_size_str, 'fileSize': file_size,
            'extractPath': extract_path, 'extractFolderName': extract_folder_name}


def make_thumbnail(file_abs_path, thumbnail_path, size=(100, 100)):
    """
    生成缩略图
    缩略图名称= 文件名+_thumbnail.扩展名
    :param file_abs_path: 源文件绝对路径
    :param thumbnail_path: 缩略图路径，不指定则在原图路径中，缩略图名称为原图名称后加_thumbnail
    :param size: 缩略图大小（width，height）
    :return: 成功返回图片路径，失败返回None
    """
    if not os.path.exists(file_abs_path):
        return None
    file_path, file_name = os.path.split(file_abs_path)

    # 缩略图绝对路径
    if not thumbnail_path:
        name, ext = os.path.splitext(file_name)
        thumbnail_path = os.path.join(file_path, name + '_thumbnail' + ext)

    th_dir, name = os.path.split(thumbnail_path)
    if not os.path.exists(th_dir):
        os.mkdir(th_dir)

    try:
        im = Image.open(file_abs_path)
        im.thumbnail(size)
        im.save(thumbnail_path)
        im.close()
        return thumbnail_path
    except Exception as e:
        logger.error("生成缩略图失败，filePath：%s, msg: %s" % (file_abs_path, str(e)))
        return None


def file_name_is_support(file_name):
    """
    判断文件扩展名是否合法
    :param filename: 文件名
    :return: True or False
    """
    return file_name.rsplit('.', 1)[1].lower() in SysSettings.OpenAllowedFileTypeList
