"""
Created on 2019年6月28日
@author: 刘益宗
server main 处理函数
"""
from H_9U import get_result_model, ResInfo
from H_9U.dao.device_info_dao import deviceInfodao
from H_9U.dao.modelconf import model_conf_dao
from H_9U.models.sysconst import ModelConfKey, PackagePwdConst
from H_9U.util import common
from H_9U.util.log import logger


class MainSvc(object):

    def write_neutral(self, device_id, neutral):
        """
        设置设备中性模式
        :param neutral: 中性模式 1 是，0 否
        :param device_id: 设备id
        :return: 结果对象
        """
        return model_conf_dao.set_value(ModelConfKey.NeutralMode, device_id, neutral)

    def read_neutral(self, device_id):
        """
        读取设备中性模式
        :param device_id: 设备id
        :return: 结果对象
        """
        rs = model_conf_dao.get_value(ModelConfKey.NeutralMode, device_id)
        if rs['status'] == 0 and rs['data']:
            rs['data'] = {
                'deviceId': device_id,
                'neutral': 0 if rs['data']['value'] <= 0 else rs['data']['value']
            }
        return rs


    def write_video_status(self, device_id, status):
        """
        设置码流开关
        :param device_id: 设备id
        :param status: 0关，1开
        :return: 结果对象
        """
        return model_conf_dao.set_value(ModelConfKey.VideoStatus, ModelConfKey.VideoStatus, status)

    def read_video_status(self, device_id):
        """
        读取码流开关
        :param device_id: 设备Id
        :return: 结果
        """
        rs = model_conf_dao.get_value(ModelConfKey.VideoStatus, ModelConfKey.VideoStatus)
        if rs['status'] == 0 and rs['data']:
            rs['data'] = {
                'videoStatus': 1 if rs['data']['value'] < 0 else rs['data']['value']
            }
        return rs

    def write_package_pwd(self, package_pwd):
        """
        更新升级包密码
        :param package_pwd: 设备密码
        :return: 结果对象
        """
        try:
            package_pwd = common.aes_gcm_decrypt(package_pwd, PackagePwdConst.Secret_Key.encode('utf-8'))
        except Exception as e:
            logger.error('解密升级包密码失败：%s' % e)
            return get_result_model(ResInfo.Decrypt_Error)
        return deviceInfodao.update_package_pwd(package_pwd.decode('utf-8'))

main_svc = MainSvc()


