#!/usr/bin/python
import socket
import struct
import time

MULTICAST_ADDRESS   = "239.168.168.168"
MULTICAST_PORT      = 5000
MULTICAST_TTL       = 4
MULTICAST_COUNT     = 10
MULTICAST_SEND_RATE = 1
MULTICAST_PAYLOAD   = "It is not the network"


sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM, socket.IPPROTO_UDP)
sock.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
sock.bind(('',MULTICAST_PORT))

mreq = struct.pack("4sl", socket.inet_aton(MULTICAST_ADDRESS), socket.INADDR_ANY)
sock.setsockopt(socket.IPPROTO_IP, socket.IP_ADD_MEMBERSHIP, mreq) # sending IGMPv2 membership queries

print("Joined Multicast-Address: " + MULTICAST_ADDRESS + " ... listening on udp port " + str(MULTICAST_PORT))

while True:
	time.sleep(0.02)
