'''
Created on 2019年8月18日
@author: GongQingBao
该类负责创建通讯器/Communicator.
'''
import threading
import traceback
import time

from H_9U.ctrl.down.communicator import Communicator
from H_9U.ctrl.down.pipe import Pipe
from H_9U.protocol.fncode import ExecTimes
from H_9U.util.log import logger


class CreateCommunicator(object):


    def __init__(self, serverIp, serverPort, parser):
        """构造函数
        :param serverIp:Socket-TCP服务端IP地址
        :param serverPort:Socket-TCP服务端Port
        :param parser:协议解析器
        """
        self.serverIp = serverIp
        self.serverPort = serverPort
        self.parser = parser

        self.threadLock = threading.Lock() # 线程同步锁


    def create(self, count=5, synModel=False):
        """创建指定数量的通讯器
        :param count：通讯器数量
        :param synModel-创建是否使用同步模式[True-是|False-否]
        :return:本次创建的通讯器集合[Communicator]
        """
        self.threadLock.acquire() # 同步
        communicatorList = [] # 存储'Communicator/通讯器'实例

        try:
            # 每个Pipe的delayInitTime时间尽量不要一样,因为：经过测试,同时初始化多个Pipe时偶尔会出现失败的情况.
            for i in range(count):
                communicatorList.append(Communicator(time.monotonic(), Pipe(ip=self.serverIp, port=self.serverPort, timeout=ExecTimes.Shot, delayInitTime=i/10, synModel=synModel), self.parser))
        except Exception:
            msg = traceback.format_exc()
            logger.error("创建指定数量的通讯器:出现异常!excetion:%s" % msg)

        self.threadLock.release() # 释放锁
        return communicatorList


